/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Hashtable;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DescriptorHandler
extends HandlerBase {
    private static final String EJB_REF = "ejb-ref";
    private static final String HOME_INTERFACE = "home";
    private static final String REMOTE_INTERFACE = "remote";
    private static final String BEAN_CLASS = "ejb-class";
    private static final String PK_CLASS = "prim-key-class";
    protected String currentElement = null;
    protected String currentText = null;
    protected Hashtable ejbFiles = null;
    private Hashtable fileDTDs = new Hashtable();
    private Hashtable resourceDTDs = new Hashtable();
    private boolean inEJBRef = false;
    private File srcDir;

    public DescriptorHandler(File file) {
        this.srcDir = file;
    }

    public void registerDTD(String string, String string2) {
        if (string2 == null) {
            return;
        }
        File file = new File(string2);
        if (file.exists()) {
            this.fileDTDs.put(string, file);
            return;
        }
        if (this.getClass().getResource(string2) != null) {
            this.resourceDTDs.put(string, string2);
        }
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        InputStream inputStream;
        String string3;
        File file = (File)this.fileDTDs.get(string);
        if (file != null) {
            try {
                return new InputSource(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((string3 = (String)this.resourceDTDs.get(string)) != null && (inputStream = this.getClass().getResourceAsStream(string3)) != null) {
            return new InputSource(inputStream);
        }
        return null;
    }

    public Hashtable getFiles() {
        return this.ejbFiles == null ? new Hashtable() : this.ejbFiles;
    }

    public void startDocument() throws SAXException {
        this.ejbFiles = new Hashtable(10, 1.0f);
        this.currentElement = null;
        this.inEJBRef = false;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.currentElement = string;
        this.currentText = "";
        if (string.equals(EJB_REF)) {
            this.inEJBRef = true;
        }
    }

    public void endElement(String string) throws SAXException {
        this.processElement();
        this.currentText = "";
        this.currentElement = "";
        if (string.equals(EJB_REF)) {
            this.inEJBRef = false;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.currentText = this.currentText + new String(cArray, n, n2);
    }

    protected void processElement() {
        if (this.inEJBRef) {
            return;
        }
        if (this.currentElement.equals(HOME_INTERFACE) || this.currentElement.equals(REMOTE_INTERFACE) || this.currentElement.equals(BEAN_CLASS) || this.currentElement.equals(PK_CLASS)) {
            File file = null;
            String string = this.currentText.trim();
            if (!string.startsWith("java.lang")) {
                string = string.replace('.', File.separatorChar);
                string = string + ".class";
                file = new File(this.srcDir, string);
                this.ejbFiles.put(string, file);
            }
        }
    }
}

