/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.velocity.util.introspection.ClassMap;

public class Introspector {
    private static Hashtable classMethodMaps = new Hashtable();

    public static Method getMethod(Class c, String name, Object[] params) throws Exception {
        if (c == null) {
            throw new Exception("Introspector.getMethod(): Class method key was null: " + name);
        }
        if (!classMethodMaps.containsKey(c)) {
            Hashtable hashtable = classMethodMaps;
            synchronized (hashtable) {
                if (!classMethodMaps.containsKey(c)) {
                    classMethodMaps.put(c, new ClassMap(c));
                }
            }
        }
        return Introspector.findMethod(c, name, params);
    }

    private static Method findMethod(Class c, String name, Object[] params) {
        ClassMap classMethodMap = (ClassMap)classMethodMaps.get(c);
        return classMethodMap.findMethod(name, params);
    }

    public static boolean implementsMethod(Object object, String methodName) {
        Method[] methods = object.getClass().getMethods();
        int m = 0;
        while (m < methods.length) {
            if (methodName.equals(methods[m].getName())) break;
            ++m;
        }
        return m < methods.length;
    }
}

