/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Hashtable;
import org.apache.fop.apps.FOPException;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontMetric;

public class FontState {
    protected FontInfo fontInfo;
    private String fontName;
    private int fontSize;
    private String fontFamily;
    private String fontStyle;
    private String fontWeight;
    private FontMetric metric;
    private int fontVariant;

    public FontState(FontInfo fontInfo, String string, String string2, String string3, int n, int n2) throws FOPException {
        this.fontInfo = fontInfo;
        this.fontFamily = string;
        this.fontStyle = string2;
        this.fontWeight = string3;
        this.fontSize = n;
        this.fontName = fontInfo.fontLookup(string, string2, string3);
        this.metric = fontInfo.getMetricsFor(this.fontName);
        this.fontVariant = n2;
    }

    public int getAscender() {
        return this.metric.getAscender(this.fontSize) / 1000;
    }

    public int getCapHeight() {
        return this.metric.getCapHeight(this.fontSize) / 1000;
    }

    public int getDescender() {
        return this.metric.getDescender(this.fontSize) / 1000;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public int getFontVariant() {
        return this.fontVariant;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public Hashtable getKerning() {
        Hashtable hashtable = new Hashtable();
        try {
            FontMetric fontMetric = this.fontInfo.getMetricsFor(this.fontFamily, this.fontStyle, this.fontWeight);
            if (fontMetric instanceof FontDescriptor) {
                FontDescriptor fontDescriptor = (FontDescriptor)((Object)fontMetric);
                hashtable = fontDescriptor.getKerningInfo();
            }
        }
        catch (Exception exception) {}
        return hashtable;
    }

    public int getXHeight() {
        return this.metric.getXHeight(this.fontSize) / 1000;
    }

    public int width(int n) {
        return this.metric.width(n, this.fontSize) / 1000;
    }
}

