/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeDOMAttrModifiedListener;
import org.apache.batik.bridge.BridgeDOMInsertedRemovedListener;
import org.apache.batik.bridge.BridgeEventSupport;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BuilderException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.css.HiddenChildElement;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGSymbolElement;
import org.w3c.dom.svg.SVGTests;

public class ConcreteGVTBuilder
implements GVTBuilder,
SVGConstants {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GraphicsNode build(BridgeContext bridgeContext, Document document) {
        bridgeContext.initialize(this);
        RootGraphicsNode rootGraphicsNode = new RootGraphicsNode();
        Element element = document.getDocumentElement();
        Bridge bridge = bridgeContext.getBridge(element);
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            return rootGraphicsNode;
        }
        GraphicsNode graphicsNode = null;
        GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge;
        try {
            try {
                graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
                this.buildComposite(bridgeContext, (CompositeGraphicsNode)graphicsNode, element.getFirstChild());
                graphicsNodeBridge.buildGraphicsNode(graphicsNode, bridgeContext, element);
                BridgeEventSupport.loadScripts(bridgeContext, document);
                EventTarget eventTarget = (EventTarget)((Object)element);
                eventTarget.addEventListener("DOMAttrModified", new BridgeDOMAttrModifiedListener(bridgeContext), true);
                BridgeDOMInsertedRemovedListener bridgeDOMInsertedRemovedListener = new BridgeDOMInsertedRemovedListener(bridgeContext);
                eventTarget.addEventListener("DOMNodeInserted", bridgeDOMInsertedRemovedListener, true);
                eventTarget.addEventListener("DOMNodeRemoved", bridgeDOMInsertedRemovedListener, true);
                BridgeEventSupport.addGVTListener(bridgeContext, element);
            }
            catch (BuilderException builderException) {
                builderException.setRootGraphicsNode(rootGraphicsNode);
                throw builderException;
            }
            Object var11_11 = null;
            if (graphicsNode != null) {
                rootGraphicsNode.getChildren().add(graphicsNode);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (graphicsNode != null) {
                rootGraphicsNode.getChildren().add(graphicsNode);
            }
            throw throwable;
        }
        bridgeContext.getDocumentLoader().dispose(document);
        return rootGraphicsNode;
    }

    public GraphicsNode build(BridgeContext bridgeContext, Element element) {
        Bridge bridge = bridgeContext.getBridge(element);
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            return null;
        }
        GraphicsNode graphicsNode = null;
        GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge;
        graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
        if (graphicsNode instanceof CompositeGraphicsNode) {
            this.buildComposite(bridgeContext, (CompositeGraphicsNode)graphicsNode, element.getFirstChild());
        }
        graphicsNodeBridge.buildGraphicsNode(graphicsNode, bridgeContext, element);
        return graphicsNode;
    }

    protected void buildComposite(BridgeContext bridgeContext, CompositeGraphicsNode compositeGraphicsNode, Node node) {
        Node node2 = node;
        while (node2 != null) {
            if (node2.getNodeType() == 1) {
                this.buildGraphicsNode(bridgeContext, compositeGraphicsNode, (Element)node2);
            }
            node2 = node2.getNextSibling();
        }
    }

    protected void buildGraphicsNode(BridgeContext bridgeContext, CompositeGraphicsNode compositeGraphicsNode, Element element) {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedBridgeException();
        }
        Bridge bridge = bridgeContext.getBridge(element);
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            return;
        }
        GraphicsNode graphicsNode = null;
        GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge;
        List list = compositeGraphicsNode.getChildren();
        try {
            graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
            list.add(graphicsNode);
            if (graphicsNodeBridge.isContainer()) {
                this.buildComposite(bridgeContext, (CompositeGraphicsNode)graphicsNode, element.getFirstChild());
            } else if ("use".equals(element.getLocalName())) {
                URIResolver uRIResolver = new URIResolver((SVGDocument)element.getOwnerDocument(), bridgeContext.getDocumentLoader());
                String string = XLinkSupport.getXLinkHref(element);
                try {
                    Object object;
                    Node node;
                    Node node2 = uRIResolver.getNode(string);
                    if (node2.getOwnerDocument() == null) {
                        throw new Error("Can't use documents");
                    }
                    Element element2 = (Element)node2;
                    boolean bl = node2.getOwnerDocument() == element.getOwnerDocument();
                    Node node3 = bl ? (Element)element2.cloneNode(true) : (Element)element.getOwnerDocument().importNode(element2, true);
                    if (node3 instanceof SVGSymbolElement) {
                        node = element.getOwnerDocument().createElementNS("http://www.w3.org/2000/svg", "svg");
                        node2 = node3.getFirstChild();
                        while (node2 != null) {
                            node.appendChild(node2);
                            node2 = node3.getFirstChild();
                        }
                        object = node3.getAttributes();
                        int n = object.getLength();
                        int n2 = 0;
                        while (n2 < n) {
                            Attr attr = (Attr)object.item(n2);
                            String string2 = attr.getNamespaceURI();
                            node.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
                            ++n2;
                        }
                        node.setAttributeNS(null, "width", "100%");
                        node.setAttributeNS(null, "height", "100%");
                        node3 = node;
                    }
                    ((HiddenChildElement)((Object)node3)).setParentElement(element);
                    if (node3 instanceof SVGSVGElement) {
                        if (element.hasAttributeNS(null, "width")) {
                            node3.setAttributeNS(null, "width", element.getAttributeNS(null, "width"));
                        }
                        if (element.hasAttributeNS(null, "height")) {
                            node3.setAttributeNS(null, "height", element.getAttributeNS(null, "height"));
                        }
                    }
                    if (!bl) {
                        node = (SVGOMDocument)element2.getOwnerDocument();
                        object = (SVGOMDocument)element.getOwnerDocument();
                        CSSUtilities.computeStyleAndURIs(element2, (ViewCSS)((SVGOMDocument)node).getDefaultView(), node3, (ViewCSS)((SVGOMDocument)object).getDefaultView(), ((SVGOMDocument)node).getURLObject());
                    }
                    this.buildGraphicsNode(bridgeContext, (CompositeGraphicsNode)graphicsNode, (Element)node3);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new BridgeException(malformedURLException.getMessage());
                }
                catch (InterruptedIOException interruptedIOException) {
                    throw new InterruptedBridgeException();
                }
                catch (IOException iOException) {
                    throw new BridgeException(iOException.getMessage());
                }
            } else if ("switch".equals(element.getLocalName())) {
                Node node = element.getFirstChild();
                while (node != null) {
                    if (node.getNodeType() == 1 && node instanceof SVGTests && SVGUtilities.matchUserAgent((Element)node, bridgeContext.getUserAgent())) {
                        this.buildGraphicsNode(bridgeContext, (CompositeGraphicsNode)graphicsNode, (Element)node);
                        break;
                    }
                    node = node.getNextSibling();
                }
            }
            graphicsNodeBridge.buildGraphicsNode(graphicsNode, bridgeContext, element);
        }
        catch (InterruptedBridgeException interruptedBridgeException) {
            throw interruptedBridgeException;
        }
        catch (BridgeException bridgeException) {
            if (bridgeException.getGraphicsNode() != null) {
                GraphicsNode graphicsNode2 = bridgeException.getGraphicsNode();
                graphicsNodeBridge.buildGraphicsNode(graphicsNode2, bridgeContext, element);
                list.add(graphicsNode2);
            } else if (graphicsNode != null) {
                list.remove(graphicsNode);
            }
            throw new BuilderException(element, bridgeException.getMessage());
        }
        catch (DOMException dOMException) {
            if (graphicsNode != null) {
                list.remove(graphicsNode);
            }
            throw new BuilderException(element, dOMException.getMessage());
        }
    }
}

