/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.util.DocumentDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DocumentLoader {
    public static final int DEFAULT_MAX_CACHED_NODE_COUNT = 2000;
    protected SVGDocumentFactory documentFactory;
    private HashMap documentMap = new HashMap();
    private List cachedDocs = new LinkedList();
    private List currentDocs = new LinkedList();
    private int currentCachedNodeCount = 0;
    private int size;

    protected DocumentLoader() {
    }

    public DocumentLoader(String string) {
        this(string, 2000);
    }

    public DocumentLoader(String string, int n) {
        this.documentFactory = new SAXSVGDocumentFactory(string);
        this.size = n;
    }

    public Document loadDocument(String string) throws IOException {
        Document document;
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((document = (Document)this.documentMap.get(string)) != null) {
            DocumentState documentState = this.getDocumentState(this.cachedDocs, document);
            if (documentState != null) {
                this.cachedDocs.remove(documentState);
                this.cachedDocs.add(0, documentState);
            }
        } else {
            DocumentState documentState;
            document = this.documentFactory.createDocument(string);
            int n2 = this.getNodeCount(document.getDocumentElement());
            while (this.currentCachedNodeCount + n2 > this.size && this.cachedDocs.size() > 0) {
                int n3 = this.cachedDocs.size() - 1;
                documentState = (DocumentState)this.cachedDocs.get(n3);
                this.cachedDocs.remove(n3);
                this.documentMap.remove(documentState.uri);
                this.currentCachedNodeCount -= documentState.nodeCount;
            }
            this.currentCachedNodeCount += n2;
            DocumentDescriptor documentDescriptor = this.documentFactory.getDocumentDescriptor();
            documentState = new DocumentState(string, document, n2, documentDescriptor);
            this.currentDocs.add(0, documentState);
            this.documentMap.put(string, document);
        }
        return document;
    }

    public void dispose(Document document) {
        DocumentState documentState = this.getDocumentState(this.currentDocs, document);
        if (documentState != null) {
            documentState.desc = null;
            this.currentDocs.remove(documentState);
            this.cachedDocs.add(0, documentState);
        }
    }

    public void dispose() {
        if (this.currentDocs.size() > 0) {
            System.err.println("WARNING: The loader still has " + this.currentDocs.size() + " documents marked in progress.");
        }
        this.documentMap.clear();
        this.cachedDocs.clear();
    }

    protected DocumentState getDocumentState(List list, Document document) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DocumentState documentState = (DocumentState)iterator.next();
            if (documentState.document != document) continue;
            return documentState;
        }
        return null;
    }

    protected int getNodeCount(Node node) {
        int n = 1;
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            n += this.getNodeCount(node2);
            node2 = node2.getNextSibling();
        }
        return n;
    }

    private static class DocumentState {
        private String uri;
        private Document document;
        private int nodeCount;
        private DocumentDescriptor desc;

        public DocumentState(String string, Document document, int n, DocumentDescriptor documentDescriptor) {
            this.uri = string;
            this.document = document;
            this.nodeCount = n;
            this.desc = documentDescriptor;
        }

        public DocumentDescriptor getDocumentDescriptor() {
            return this.desc;
        }

        public String getURI() {
            return this.uri;
        }

        public Document getDocument() {
            return this.document;
        }

        public int getNodeCount() {
            return this.nodeCount;
        }
    }
}

