/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.io.StringReader;
import org.apache.batik.dom.svg.DefaultUnitProcessorContext;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.ModificationHandler;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.parser.LengthHandler;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLength;

public class SVGOMLength
implements SVGLength,
LiveAttributeValue,
LengthHandler {
    protected static final String[] UNITS = new String[]{"", "", "%", "em", "ex", "px", "cm", "mm", "in", "pt", "pc"};
    protected float valueInSpecifiedUnits;
    protected short unitType = 1;
    protected ModificationHandler modificationHandler;
    protected short direction;
    protected boolean internalChange;

    public void setModificationHandler(ModificationHandler modificationHandler) {
        this.modificationHandler = modificationHandler;
    }

    public void setDirection(short s) {
        this.direction = s;
    }

    public void valueChanged(Attr attr, Attr attr2) {
        if (!this.internalChange) {
            this.parseLength(attr2.getValue());
        }
    }

    public short getUnitType() {
        return this.unitType;
    }

    public float getValue() {
        try {
            if (this.modificationHandler == null) {
                switch (this.unitType) {
                    case 1: 
                    case 5: {
                        return this.valueInSpecifiedUnits;
                    }
                }
                throw new RuntimeException("Invalid Unit");
            }
            SVGElement sVGElement = (SVGElement)this.modificationHandler.getObject(null);
            SVGOMDocument sVGOMDocument = (SVGOMDocument)sVGElement.getOwnerDocument();
            DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(sVGOMDocument.getSVGContext(), sVGElement);
            return UnitProcessor.svgToUserSpace(this.unitType, this.valueInSpecifiedUnits, sVGElement, this.direction, defaultUnitProcessorContext);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw new DOMException(11, runtimeException.getMessage());
        }
    }

    public void setValue(float f) throws DOMException {
        block6: {
            try {
                if (this.modificationHandler == null) {
                    switch (this.unitType) {
                        case 1: 
                        case 5: {
                            this.valueInSpecifiedUnits = f;
                            break block6;
                        }
                        default: {
                            throw new RuntimeException("Invalid Unit");
                        }
                    }
                }
                SVGElement sVGElement = (SVGElement)this.modificationHandler.getObject(null);
                SVGOMDocument sVGOMDocument = (SVGOMDocument)sVGElement.getOwnerDocument();
                DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(sVGOMDocument.getSVGContext(), sVGElement);
                this.setValueInSpecifiedUnits(UnitProcessor.userSpaceToSVG(this.unitType, f, sVGElement, this.direction, defaultUnitProcessorContext));
            }
            catch (RuntimeException runtimeException) {
                throw new DOMException(11, runtimeException.getMessage());
            }
        }
    }

    public float getValueInSpecifiedUnits() {
        return this.valueInSpecifiedUnits;
    }

    public void setValueInSpecifiedUnits(float f) throws DOMException {
        this.valueInSpecifiedUnits = f;
        if (this.modificationHandler != null) {
            this.internalChange = true;
            this.modificationHandler.valueChanged(this, f + UNITS[this.unitType]);
            this.internalChange = false;
        }
    }

    public String getValueAsString() {
        return this.valueInSpecifiedUnits + UNITS[this.unitType];
    }

    public void setValueAsString(String string) throws DOMException {
        if (this.modificationHandler == null) {
            this.parseLength(string);
        } else {
            this.modificationHandler.valueChanged(this, string);
        }
    }

    public void newValueSpecifiedUnits(short s, float f) {
        this.unitType = s;
        this.valueInSpecifiedUnits = f;
        if (this.modificationHandler != null) {
            this.internalChange = true;
            this.modificationHandler.valueChanged(this, f + UNITS[s]);
            this.internalChange = false;
        }
    }

    public void convertToSpecifiedUnits(short s) {
        throw new RuntimeException(" !!! TODO: SVGLength.convertToSpecifiedUnits()");
    }

    public void parseLength(String string) {
        LengthParser lengthParser = new LengthParser();
        lengthParser.setLengthHandler(this);
        try {
            lengthParser.parse(new StringReader(string));
        }
        catch (ParseException parseException) {
            throw new DOMException(12, parseException.getMessage());
        }
    }

    public void startLength() throws ParseException {
        this.unitType = 0;
    }

    public void lengthValue(float f) throws ParseException {
        this.valueInSpecifiedUnits = f;
    }

    public void em() throws ParseException {
        this.unitType = (short)3;
    }

    public void ex() throws ParseException {
        this.unitType = (short)4;
    }

    public void in() throws ParseException {
        this.unitType = (short)8;
    }

    public void cm() throws ParseException {
        this.unitType = (short)6;
    }

    public void mm() throws ParseException {
        this.unitType = (short)7;
    }

    public void pc() throws ParseException {
        this.unitType = (short)10;
    }

    public void pt() throws ParseException {
        this.unitType = (short)9;
    }

    public void px() throws ParseException {
        this.unitType = (short)5;
    }

    public void percentage() throws ParseException {
        this.unitType = (short)2;
    }

    public void endLength() throws ParseException {
        if (this.unitType == 0) {
            this.unitType = 1;
        }
    }
}

