/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.BumpMap;
import org.apache.batik.ext.awt.image.renderable.DiffuseLightingRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.Light;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.DiffuseLightingRed;
import org.apache.batik.ext.awt.image.rendered.PadRed;

public class DiffuseLightingRable8Bit
extends AbstractRable
implements DiffuseLightingRable {
    private double surfaceScale;
    private double kd;
    private Light light;
    private Rectangle2D litRegion;
    static final boolean SCALE_RESULT = true;

    public DiffuseLightingRable8Bit(Filter filter, Rectangle2D rectangle2D, Light light, double d, double d2) {
        super(filter, null);
        this.setLight(light);
        this.setKd(d);
        this.setSurfaceScale(d2);
        this.setLitRegion(rectangle2D);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.litRegion.clone();
    }

    public Rectangle2D getLitRegion() {
        return this.getBounds2D();
    }

    public void setLitRegion(Rectangle2D rectangle2D) {
        this.litRegion = rectangle2D;
    }

    public Light getLight() {
        return this.light;
    }

    public void setLight(Light light) {
        this.light = light;
    }

    public double getSurfaceScale() {
        return this.surfaceScale;
    }

    public void setSurfaceScale(double d) {
        this.surfaceScale = d;
    }

    public double getKd() {
        return this.kd;
    }

    public void setKd(double d) {
        this.kd = d;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            shape = this.getBounds2D();
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        Rectangle2D.intersect(rectangle2D, this.getBounds2D(), rectangle2D);
        AffineTransform affineTransform = renderContext.getTransform();
        Rectangle rectangle = affineTransform.createTransformedShape(rectangle2D).getBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return null;
        }
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getScaleY();
        double d3 = affineTransform.getShearX();
        double d4 = affineTransform.getShearY();
        double d5 = affineTransform.getTranslateX();
        double d6 = affineTransform.getTranslateY();
        double d7 = Math.sqrt(d * d + d4 * d4);
        double d8 = Math.sqrt(d2 * d2 + d3 * d3);
        if (d7 == 0.0 || d8 == 0.0) {
            return null;
        }
        d7 = 1.0;
        d8 = 1.0;
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(d7, d8);
        rectangle = affineTransform2.createTransformedShape(rectangle2D).getBounds();
        rectangle2D.setRect(rectangle2D.getX() - 2.0 / d7, rectangle2D.getY() - 2.0 / d8, rectangle2D.getWidth() + 4.0 / d7, rectangle2D.getHeight() + 4.0 / d8);
        renderContext = (RenderContext)renderContext.clone();
        renderContext.setAreaOfInterest(rectangle2D);
        renderContext.setTransform(affineTransform2);
        CachableRed cachableRed = GraphicsUtil.wrap(this.getSource().createRendering(renderContext));
        BumpMap bumpMap = new BumpMap(cachableRed, this.surfaceScale, d7, d8);
        cachableRed = new DiffuseLightingRed(this.kd, this.light, bumpMap, rectangle, 1.0 / d7, 1.0 / d8);
        AffineTransform affineTransform3 = new AffineTransform(d / d7, d4 / d7, d3 / d8, d2 / d8, d5, d6);
        if (!affineTransform3.isIdentity()) {
            RenderingHints renderingHints = renderContext.getRenderingHints();
            Rectangle rectangle2 = new Rectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            cachableRed = new PadRed(cachableRed, rectangle2, PadMode.REPLICATE, renderingHints);
            cachableRed = new AffineRed(cachableRed, affineTransform3, renderingHints);
        }
        return cachableRed;
    }
}

