/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.batik.util.gui.resource.ResourceFormatException;

public class ResourceManager {
    protected ResourceBundle bundle;

    public ResourceManager(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public String getString(String string) throws MissingResourceException {
        return this.bundle.getString(string);
    }

    public List getStringList(String string) throws MissingResourceException {
        return this.getStringList(string, " \t\n\r\f", false);
    }

    public List getStringList(String string, String string2) throws MissingResourceException {
        return this.getStringList(string, string2, false);
    }

    public List getStringList(String string, String string2, boolean bl) throws MissingResourceException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString(string), string2, bl);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public boolean getBoolean(String string) throws MissingResourceException, ResourceFormatException {
        String string2 = this.getString(string);
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw new ResourceFormatException("Malformed boolean", this.bundle.getClass().getName(), string);
    }

    public int getInteger(String string) throws MissingResourceException, ResourceFormatException {
        String string2 = this.getString(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ResourceFormatException("Malformed integer", this.bundle.getClass().getName(), string);
        }
    }
}

