/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.LogStreamOptions;
import common.ScrollText;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;

public class LogStream
extends PrintStream {
    private ScrollText ST = null;
    private PrintWriter PW = null;
    private LogStreamOptions LSO;

    public LogStream(OutputStream os, LogStreamOptions lso) throws FileNotFoundException {
        super(os);
        this.LSO = lso;
        if (lso == null) {
            new NullPointerException("LogStreamOptions is null");
        }
        if (this.LSO.getTypeOfLog() != 0) {
            if (this.LSO.getTypeOfLog() >= 2) {
                this.windowInit(lso.getInitMsg());
            }
            if (this.LSO.getTypeOfLog() <= 2 && this.LSO.getFilePath() != null) {
                this.PW = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.LSO.getFilePath())));
                this.PW.println(lso.getInitMsg());
            }
        }
    }

    public short getTypeOfLog() {
        return this.LSO.getTypeOfLog();
    }

    public boolean isFileType() {
        return this.LSO.isFileType();
    }

    public boolean isWindowType() {
        return this.LSO.isWindowType();
    }

    public void switchTo(short type, String windowTitle, boolean isClosable, boolean doExit) throws FileNotFoundException {
        short prevType = this.LSO.getTypeOfLog();
        if (prevType == type) {
            return;
        }
        if (LogStreamOptions.isWindowType(prevType) && !LogStreamOptions.isWindowType(type)) {
            this.closeWindow();
            this.ST = null;
        }
        if (LogStreamOptions.isFileType(prevType) && !LogStreamOptions.isFileType(type)) {
            this.PW.close();
            this.PW = null;
        }
        this.LSO.setTypeOfLog(type);
        if (this.LSO.isWindowType() && !LogStreamOptions.isWindowType(prevType)) {
            this.windowInit(this.LSO.getInitMsg());
            this.setTitle(windowTitle);
            this.setClosable(isClosable, doExit);
        }
        if (this.LSO.isFileType() && !LogStreamOptions.isFileType(prevType) && this.LSO.getFilePath() != null) {
            this.PW = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.LSO.getFilePath())));
            this.PW.println(this.LSO.getInitMsg());
        }
    }

    private void windowInit(String initialMsg) {
        this.ST = initialMsg != null ? new ScrollText(initialMsg) : new ScrollText();
        this.ST.setEditable(false);
        this.ST.setDisabledColor();
        this.ST.setClosable(true, true);
        this.ST.addClearLog();
        this.ST.setVisible(true);
    }

    public void setTitle(String str) {
        if (this.LSO.getTypeOfLog() >= 2) {
            this.ST.setTitle(str);
        }
    }

    public void setClosable(boolean isClosable, boolean doExit) {
        if (this.LSO.getTypeOfLog() >= 2) {
            this.ST.setClosable(isClosable, doExit);
        }
    }

    public void println() {
        if (this.LSO.getTypeOfLog() >= 2) {
            this.ST.append("\n");
            this.ST.setVisible(true);
        }
        if (this.LSO.getTypeOfLog() <= 2 && this.LSO.getTypeOfLog() != 0) {
            this.PW.println();
        }
    }

    public void print(String s) {
        if (this.LSO.getTypeOfLog() >= 2) {
            this.ST.append(s);
        }
        if (this.LSO.getTypeOfLog() <= 2 && this.LSO.getTypeOfLog() != 0) {
            this.PW.print(s);
        }
        this.println();
    }

    public void println(String s) {
        this.print(s);
    }

    public void println(Object obj) {
        String aux = "null";
        if (obj != null) {
            aux = obj.toString();
        }
        this.println(aux);
    }

    public void print(Object obj) {
        this.println(obj);
    }

    public void log(String s) {
        if (this.LSO.getTypeOfLog() >= 2) {
            this.ST.append(String.valueOf(s) + "\n");
        }
        if (this.LSO.getTypeOfLog() <= 2 && this.LSO.getTypeOfLog() != 0) {
            this.PW.println(s);
        }
    }

    public void logNoNewLine(String s) {
        if (this.LSO.getTypeOfLog() >= 2) {
            this.ST.append(s);
        }
        if (this.LSO.getTypeOfLog() <= 2 && this.LSO.getTypeOfLog() != 0) {
            this.PW.print(s);
        }
    }

    public void close() {
        super.close();
        if (this.LSO.getTypeOfLog() <= 2 && this.LSO.getTypeOfLog() != 0) {
            this.PW.close();
        }
    }

    public void flush() {
        super.flush();
        if (this.LSO.getTypeOfLog() <= 2 && this.LSO.getTypeOfLog() != 0) {
            this.PW.flush();
        }
    }

    public void closeWindow() {
        if (this.ST != null) {
            this.ST.setVisible(false);
            this.ST.dispose();
        } else {
            this.print("Hidding window");
        }
    }
}

