/* callbacks.c */
void on_visu_schem_clicked(GtkButton *button, EasySpice *es);
void on_gen_netlist_clicked(GtkButton *button, EasySpice *es);
void on_visu_netlist_clicked(GtkButton *button, EasySpice *es);
void on_op_ok_clicked(GtkButton *button, EasySpice *es);
void on_dc_ok_clicked(GtkButton *button, EasySpice *es);
void on_ac_ok_clicked(GtkButton *button, EasySpice *es);
void on_tran_ok_clicked(GtkButton *button, EasySpice *es);
void on_tf_ok_clicked(GtkButton *button, EasySpice *es);
void on_noise_ok_clicked(GtkButton *button, EasySpice *es);
void on_spice_default_clicked(GtkButton *button, gpointer user_data);
void on_plot_res_activate(GtkMenuItem *menuitem, ExternalProgramms *ep);
void on_param_enable_pressed(GtkButton *button, EasySpice *es);
void on_param_lin_pressed(GtkButton *button, EasySpice *es);
void on_param_dec_pressed(GtkButton *button, EasySpice *es);
void on_param_list_pressed(GtkButton *button, EasySpice *es);
void on_ac_dec_pressed(GtkButton *button, EasySpice *es);
void on_ac_lin_pressed(GtkButton *button, EasySpice *es);
void on_ac_oct_pressed(GtkButton *button, EasySpice *es);
void on_noise_dec_pressed(GtkButton *button, EasySpice *es);
void on_noise_lin_pressed(GtkButton *button, EasySpice *es);
void on_noise_oct_pressed(GtkButton *button, EasySpice *es);
void on_plot_reset_clicked(GtkButton *button, EasySpice *es);
void on_plot_ok_clicked(GtkButton *button, EasySpice *es);
void on_plot_xscale_default_clicked(GtkButton *button, EasySpice *es);
void on_plot_xscale_value_clicked(GtkButton *button, EasySpice *es);
gboolean do_not_destroy(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_op_node_changed(GtkEditable *editable, EasySpice *es);
void on_op_device_changed(GtkEditable *editable, EasySpice *es);
void on_op_item_changed(GtkEditable *editable, EasySpice *es);
void on_viewerspiceoutput_clicked(GtkButton *button, EasySpice *es);
void on_textviewer_button_close_clicked(GtkButton *button, Textviewer *tv);
void on_textviewer_destroy(GtkDialog *dialog, Textviewer *tv);
void on_geda_setup_destroy(GtkDialog *dialog, GedaSettings *geda);
void on_geda_setup_default_clicked(GtkButton *button, GedaSettings *geda);
void on_geda_setup_ok_clicked(GtkButton *button, GedaSettings *geda);
void on_geda_setup_cancel_clicked(GtkButton *button, GedaSettings *geda);
void on_command_setup_destroy(GtkDialog *dialog, ExternalProgramms *prog);
void on_command_setup_default_clicked(GtkButton *button, ExternalProgramms *prog);
void on_command_setup_cancel_clicked(GtkButton *button, ExternalProgramms *prog);
void on_command_setup_ok_clicked(GtkButton *button, ExternalProgramms *prog);
void on_quickmessage_ok_clicked(GtkButton *button, GtkWidget *dialog);
void on_verify_quit_button_no_clicked(GtkButton *button, GtkWidget *dialog);
void on_verify_quit_button_yes_clicked(GtkButton *button, GtkWidget *dialog);
void on_postprocessing_destroy(GtkWidget *widget, PostProcessing *postproc);
void on_postprocessing_button_cancel_clicked(GtkButton *button, PostProcessing *postproc);
void on_postprocessing_button_ok_clicked(GtkButton *button, PostProcessing *postproc);
void on_library_dialog_destroy(GtkWidget *widget, SpiceLibrary *spicelib);
void on_library_dialog_add_clicked(GtkButton *button, SpiceLibrary *spicelib);
void on_library_file_select(GtkWidget *file_dialog, gpointer user_data);
void on_library_dialog_remove_clicked(GtkButton *button, SpiceLibrary *spicelib);
void on_library_dialog_edit_clicked(GtkButton *button, SpiceLibrary *spicelib);
void on_library_dialog_cancel_clicked(GtkButton *button, SpiceLibrary *spicelib);
void on_library_dialog_ok_clicked(GtkButton *button, SpiceLibrary *spicelib);
/* geda.c */
void visu_result_gschem(EasySpice *es);
void geda_create_config(GedaSettings *geda);
/* interface.c */
GtkWidget *create_toplevel_window(EasySpice *easyspice);
GtkWidget *create_verify_quit(void);
GtkWidget *create_config_spice(void);
GtkWidget *create_txt_viewer(Textviewer *textviewer);
GtkWidget *create_geda_setup(GedaSettings *geda);
GtkWidget *create_command_setup(ExternalProgramms *prog);
GtkWidget *create_quickmessage(gchar *title, gchar *text);
GtkWidget *create_postproc(PostProcessing *postproc);
GtkWidget *create_library_dialog(SpiceLibrary *spicelib);
/* main.c */
int main(int argc, char *argv[]);
/* menu.c */
void on_menu_file_new_activate(GtkMenuItem *menuitem, EasySpice *es);
void on_new_file_select(GtkWidget *file_dialog, gpointer user_data);
void on_menu_file_open_activate(GtkMenuItem *menuitem, EasySpice *es);
void on_open_file_select(GtkWidget *file_dialog, gpointer user_data);
void localconfiguration_file_read(EasySpice *es);
void configuration_file_read(EasySpice *es, gchar *filename);
void configuration_file_read_new(EasySpice *es, gchar *filename);
void configuration_file_read_old(EasySpice *es, gchar *filename);
void localconfiguration_file_write(EasySpice *es);
void configuration_file_write_new(EasySpice *es, gchar *filename, gboolean configfile);
void configuration_file_write_old(EasySpice *es, gchar *filename);
void write_multiline_text(FILE *file, gchar *section, gchar *name, gchar *data);
void on_menu_file_save_activate(GtkMenuItem *menuitem, EasySpice *es);
void on_menu_file_saveas_activate(GtkMenuItem *menuitem, EasySpice *es);
void on_saveas_file_select(GtkWidget *file_dialog, gpointer user_data);
void on_menu_file_quit_activate(GtkMenuItem *menuitem, EasySpice *es);
gboolean on_main_window_destroy_event(GtkWidget *widget, GdkEvent *event, EasySpice *es);
void on_menu_options_commands_activate(GtkMenuItem *menuitem, ExternalProgramms *prog);
void on_menu_options_library_activate(GtkMenuItem *menuitem, SpiceLibrary *spicelib);
void on_menu_options_gschem_activate(GtkMenuItem *menuitem, GedaSettings *geda);
void on_menu_options_save_activate (GtkMenuItem *menuitem, EasySpice *es);
void on_menu_windows_simulcommands_activate(GtkMenuItem *menuitem, EasySpice *es);
void on_menu_windows_plotcommands_activate(GtkMenuItem *menuitem, EasySpice *es);
void on_menu_windows_spiceinteractive_activate(GtkMenuItem *menuitem, ExternalProgramms *ep);
void on_menu_windows_postproc_activate(GtkMenuItem *menuitem, PostProcessing *postproc);
void on_menu_help_spiceman_activate(GtkMenuItem *menuitem, ExternalProgramms *ep);
void on_menu_help_spicehtml_activate(GtkMenuItem *menuitem, ExternalProgramms *ep);
void on_menu_help_spicehelp_activate(GtkMenuItem *menuitem, ExternalProgramms *ep);
void on_menu_help_about_activate(GtkMenuItem *menuitem, gpointer user_data);
/* netlist.c */
void print_list(GList *list);
void free_element(void *ptr, gpointer user_data);
void free_keyvalue(KeyValue *kv, gpointer user_data);
void free_device(SpiceDevice *dev, gpointer user_data);
void netlist_read(SpiceNetlist *result, gchar *filename);
gint netlist_test(EasySpice *es, gboolean verbose);
void netlist2easy(EasySpice *es, SpiceNetlist *netlist);
/* spice.c */
void spice2easy(EasySpice *es);
int spice_test_field(EasySpice *es, gint type_simul);
void fatal_error(EasySpice *es);
int spice_parse_error_file(gchar *filename);
void spice_txt_results(EasySpice *es);
int spice_test_error(EasySpice *es);
void spice_write_simul(FILE *fp_simul, gint type_simul, EasySpice *es);
void spice_view_result(EasySpice *es, int type_simul, int n_step);
gint spice_write_cir(EasySpice *es, FILE *fp_simul, int type_simul);
void spice_start_spice(EasySpice *es);
void simul(EasySpice *es, gint type_simul);
/* spice_plot.c */
void create_spice_plot_file(EasySpice *es, int n_step, int type_simul);
void start_plot(EasySpice *es);
void destroy_plot(EasySpice *es);
/* support.c */
GtkWidget *lookup_widget(GtkWidget *widget, const gchar *widget_name);
void add_pixmap_directory(const gchar *directory);
GtkWidget *create_pixmap(GtkWidget *widget, const gchar *filename);
/* util.c */
gchar *val2txt(double val, int mode);
gchar *update_str(gchar *ptr, const gchar *str);
void set_str(gchar **dest, const gchar *str);
gchar *get_gtk_entry(GtkWidget *widget, gchar *entry_name);
void set_gtk_entry(char *text, GtkWidget *widget, char *entry_name);
gboolean get_gtk_toggle_button(GtkWidget *widget, char *entry_name);
void set_gtk_toggle_button(GtkWidget *widget, char *entry_name);
gboolean textfile2buffer(gchar *textfile, GtkTextBuffer *buffer);
void write_log(gchar *message);
void clean_log(EasySpice *es);
void clean_std_output(EasySpice *es);
void clean_std_err(EasySpice *es);
void easyspice_init(EasySpice *es);
void easyspice_filename_update(EasySpice *es);
void spice_variables_init(SpiceVariables *sv);
void spice_variables_default(SpiceVariables *sv);
void spice_variables_set_entries(GtkWidget *win, SpiceVariables *sv);
void spice_variables_get_entries(GtkWidget *win, SpiceVariables *sv);
void spice_variables_delete(SpiceVariables *sv);
void readspice_value(gchar **dest, gchar *s1, gchar *s2, gchar *value);
void textviewer_init(Textviewer *tv);
void geda_settings_init(GedaSettings *geda);
void geda_settings_default(GedaSettings *geda);
void geda_settings_delete(GedaSettings *geda);
void geda_settings_set_entries(GtkWidget *dialog, GedaSettings *geda);
void geda_settings_get_entries(GtkWidget *dialog, GedaSettings *geda);
void commands_init(ExternalProgramms *prog);
void commands_set_default(ExternalProgramms *prog);
void commands_delete(ExternalProgramms *prog);
void commands_set_entries(GtkWidget *dialog, ExternalProgramms *prog);
void commands_get_entries(GtkWidget *dialog, ExternalProgramms *prog);
void postprocessing_init(PostProcessing *postproc);
void postprocessing_set_entries(PostProcessing *postproc);
void postprocessing_get_entries(PostProcessing *postproc);
void postprocessing_delete(PostProcessing *postproc);
void spicelibrary_init(SpiceLibrary *spicelib);
void spicelibrary_delete(SpiceLibrary *spicelib);
double spice2double(gchar *sp_value);
void project_set_title(EasySpice *es);
void textfile_view(Textviewer *tv, gchar *filename);
void select_fichier(gchar *titre, gint type);
void led_ok(GtkWidget *win);
void led_false(GtkWidget *win);
void led_off(GtkWidget *win);
void keyvalue_print_list(GList *item);
gint keyvalue_compare_key(KeyValue *kv1, gchar *key);
gint spicedevice_compare_name(SpiceDevice *sd, gchar *name);
