/*  Festalon - NSF Player
 *  Copyright (C) 2002 Ben Parnell
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "common.h"

uint8 dopol;
static uint8 MapperExRAM[0x80];

static void DoNamcoSoundHQ(void);
static void SyncHQ(int32 ts);

DECLFR(Namco_Read4800)
{
	uint8 ret=MapperExRAM[dopol&0x7f];
	if(dopol&0x80)
	 dopol=(dopol&0x80)|((dopol+1)&0x7f);
	return ret;
}

static DECLFW(Mapper19_write)
{
	A&=0xF800;
        switch(A)
	{
	 case 0x4800:
		   if(dopol&0x40)
                   {
		    DoNamcoSoundHQ();
                    GameExpSound.HiFill=DoNamcoSoundHQ;
                    GameExpSound.HiSync=SyncHQ;
                   }
		   MapperExRAM[dopol&0x7f]=V;
                   if(dopol&0x80)
                    dopol=(dopol&0x80)|((dopol+1)&0x7f);
                   break;
        case 0xf800: dopol=V;break;
        }
}

static uint32 PlayIndex[8];
static int32 vcount[8];
static int32 CVBC;

#define TOINDEX (16+1)
                     
// 16:15
static void SyncHQ(int32 ts)
{
 CVBC=ts;
}

static void DoNamcoSoundHQ(void)
{
 int32 P,V;          
 int32 cyclesuck=(((MapperExRAM[0x7F]>>4)&7)+1)*15;

 for(P=7;P>=(7-((MapperExRAM[0x7F]>>4)&7));P--)
 {
  if(!(FSettings.disabled&(0x20<<P)))
  if((MapperExRAM[0x44+(P<<3)]&0xE0) && (MapperExRAM[0x47+(P<<3)]&0xF))
  {
   uint32 freq;
   int32 vco;   
   uint32 duff,duff2,lengo,envelope;
        
   vco=vcount[P];
   freq=MapperExRAM[0x40+(P<<3)];
   freq|=MapperExRAM[0x42+(P<<3)]<<8;
   freq|=(MapperExRAM[0x44+(P<<3)]&3)<<16;

   envelope=((MapperExRAM[0x47+(P<<3)]&0xF)<<18)/20;
   lengo=((8-((MapperExRAM[0x44+(P<<3)]>>2)&7)))<<2;
 
   for(V=CVBC<<1;V<timestamp<<1;V++)
   {
    duff=MapperExRAM[((MapperExRAM[0x46+(P<<3)]+(PlayIndex[P]>>TOINDEX))&0xFF)>>1];
    if((MapperExRAM[0x46+(P<<3)]+(PlayIndex[P]>>TOINDEX))&1)
     duff>>=4; 
    duff&=0xF;
    duff2=(duff*envelope)>>11;
    WaveHi[V>>1]+=duff2;
    if(!vco)
    {
     PlayIndex[P]+=freq;
     while((PlayIndex[P]>>TOINDEX)>=lengo)
      PlayIndex[P]-=lengo<<TOINDEX;
     vco=cyclesuck;
    }
    vco--;
   }
   vcount[P]=vco;
  }
 }
 CVBC=timestamp;
}

static void M19SC(void)
{
 Mapper19_ESI();
}

void Mapper19_ESI(void)
{
  GameExpSound.RChange=M19SC;
  SetWriteHandler(0xf800,0xffff,Mapper19_write);
  SetWriteHandler(0x4800,0x4fff,Mapper19_write);
  SetReadHandler(0x4800,0x4fff,Namco_Read4800);
  memset(vcount,0,sizeof(vcount));
  memset(PlayIndex,0,sizeof(PlayIndex));
  CVBC=0;
}
