/*
 * DefaultActiveAssistance.java
 *
 * Created on December 25, 2003, 12:51 PM
 */

package com.sun.enterprise.config.backup.pluggable.impl;

import com.sun.enterprise.config.backup.pluggable.ActiveAssistance;
import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.BackupAbortException;
import com.sun.enterprise.config.backup.BackupException;

import java.util.Properties;
import java.io.InputStream;

/**
 *
 * @author  sridatta
 */
public class DefaultActiveAssistance implements ActiveAssistance {
    
    private static final String DID_YOU_KNOW_PATH =
     "/com/sun/enterprise/config/backup/pluggable/impl/didyouknow.properties";
        private static final String DIAGNOSABILITY_INFO_PATH =
     "/com/sun/enterprise/config/backup/pluggable/impl/diagnosability.properties";
    
    /** Creates a new instance of DefaultActiveAssistance */
    public DefaultActiveAssistance() {
    }
    
    public String getDiagnosabilityInfo(Status s) {
        if(s == null || s.isSuccess()) {
            return null;
        }
        
        Exception e = s.getException();
        if (e == null) {
            return null;
        } else if (e instanceof BackupException) {
            String code = ((BackupException)e).getCode();
            Properties p = getAllCodes();
            if(p == null) return null;
            return (String)p.get(code);
        } else if (e instanceof BackupAbortException) {
            String code = ((BackupAbortException)e).getCode();
            Properties p = getAllCodes();
            if(p == null) return null;
            return (String)p.get(code);
        } else {
            return null;
        }
    }
    
    public String getDidYouKnow(Status status) {
        Properties p = getAllDidYouKnow();
        if(p == null) return null;
        long num = Math.round(Math.random() * p.size());
        return (String) p.get("DYK" + num);
    }
    
    private Properties getAllDidYouKnow() {
         try {
            InputStream i = DefaultActiveAssistance.class.
                        getResourceAsStream(DID_YOU_KNOW_PATH );
            Properties p = new Properties();
            p.load(i);
            return p;
        } catch (Exception io) {
            //fail
          return null;
        }
    } 
    
    private Properties getAllCodes() {
         try {
            InputStream i = DefaultActiveAssistance.class.
                        getResourceAsStream(DIAGNOSABILITY_INFO_PATH );
            Properties p = new Properties();
            p.load(i);
            return p;
        } catch (Exception io) {
            //fail
          return null;
        }
    }
    
}
