/*
 ** Copyright (C) 2001-2008 Dirk-Jan C. Binnema <djcb@djcbsoftware.nl>
 **  
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **  
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; woithout even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **  
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **  
 */

#ifdef HAVE_CONFIG
#include <config.h>
#endif /*HAVE_CONFIG*/

#include <ctype.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <langinfo.h>

#include "gnuvd.h"

#if HAVE_STRNDUP
/*OK*/
#else
#define strndup(s,n) strdup(s) 
#endif /*HAVE_STRNDUP*/

#ifndef VERSION
#define VERSION "?.?"
#endif /*VERSION*/

#define S_KARS_MAX 10

/* internal functions */
static int show_results     (Buffer *results, int keep_entities);
static void help             (void);

int
main (int argc, char* argv[])
{
	int   keep_entities = 0;
	char *word = NULL;
	
	VDQuery *vd_query  = NULL;
	VDError vd_ex;

	while (1) {

		int c = getopt (argc, argv, "h");

		switch  (c) {
		case -1:
			break;
		case 'h':
			help();
			return 0;
		default:
			help();
			return 1;
		}

		if (optind >= argc) {
			help();
			return 1;
		}  else
			break;
	}
			
	if (!word)
		/* let's hope for the best */
	word  = argv[optind];
	
	/* prepare query */
	vd_ex = VD_ERR_OK;
	vd_query = vd_query_new (word, &vd_ex);
	if (!vd_query) {
		if (vd_ex != VD_ERR_OK)
			fprintf (stderr, "error: %s\n", 
				 vd_error_string(vd_ex));
		else 	
			fprintf (stderr, "an unknown error occurred\n");
		return 1;
	}

	/* do query */
	vd_query_perform (vd_query, &vd_ex);
	if (vd_ex == VD_ERR_NOT_FOUND) {
		fprintf (stderr, "'%s' was not found in the dictionary\n", 
			 word); 
		vd_query_destroy (vd_query);
		return 2;	
	} else if (vd_ex != VD_ERR_OK) {
		fprintf  (stderr, "error: %s\n", vd_error_string (vd_ex));
		vd_query_destroy (vd_query);
		return 1;	
	} 

	if (!show_results (vd_query->_result_buffer, keep_entities))
		fprintf (stderr, "'%s' was not found in the dictionary\n", 
			 word); 

	vd_query_destroy (vd_query);
	
	return 0;
}


static int
show_results (Buffer* buffer, int keep_entities)
{
	BufferIterator j;
	Buffer *output;
	int skip_spc     = 1;
	char *data;
	FILE *out        = stdout;
	int have_output   = 0;

	/* output to PAGER or to STDOUT? */
	if (isatty(fileno(stdin)) && isatty(fileno(stdout))) {
		char *pager = getenv("PAGER");
		if (pager && pager[0] && strcmp(pager, "-") != 0) {
			out = popen(pager, "w");
			if (!out)
				out = stdout;
		}
	}

	output = buffer_new ();
	
	for (j = buffer_begin (buffer); j < buffer_end(buffer); ++j) {
		
		/* remove tags */
		if (buffer_at(buffer,j) == '<' || buffer_at(buffer,j) == '\t') {
			while (j < buffer_end(buffer) && buffer_at(buffer,j) != '>') 
				++j;
			continue;
		}
				
		/* skip superfluous space at beginning */
		if (skip_spc) {
			if (isspace(buffer_at(buffer,j))) 
				continue;
			else
				skip_spc = 0;
		}

		/* convert DOS-style CR/LF line-endings to Unix-style LF */
		if (buffer_at(buffer,j) == 13)
			continue;

		/* append one character */
		buffer_append (output, buffer_data_pos(buffer, j), 1);
        }

	if (buffer_length(output) != 0) {
		/* strip trailing space */
		for (j = buffer_end(output) - 1; j >= buffer_begin(output); --j) 
			if (isalnum(buffer_at(output, j)))
				break;
		if (j >= buffer_begin(output))
			buffer_erase (output, j + 1, buffer_end(output) - j - 1);
		
		data = buffer_data_to_string (output);
		fprintf (out, "%s\n", data);
		free (data);
		
		/* if we were outputing to PAGER, close it */
		if (out != stdout) {
			fflush (out);
			pclose (out);
		}
		have_output = 1;
	} else
		have_output = 0;

	buffer_destroy (output);

	return have_output;
}

static void
help(void)
{
	printf ("gnuvd version " VERSION  ",\n"
		"(c) 2001-2008 Dirk-Jan C. Binnema <djcb@djcbsoftware.nl>\n\n"
		"usage: gnuvd [options] word\n"
		"where [options] are:\n"
		"\t-h: show this help message\n");
}


