/* GSnes9x -- globalprefs.h
 * Copyright (C) 1999 Canek Pelez Valds <canek@abulafia.fciencias.unam.mx>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GSNES9X_PREFERENCES_H
#define GSNES9X_PREFERENCES_H

/* Callback. */
void global_preferences_cb (GtkWidget *widget, GSnes9xData *gsnes_data);

/* Structs constructors. */
GlobalPrefs*     global_prefs_new               ();
GlobalPrefsData* global_prefs_data_new          ();

/* Notebook pages.*/
GtkWidget*       global_prefs_system_ops        (GlobalPrefsData *gpd);
GtkWidget*       global_prefs_graphics_ops      (GlobalPrefsData *gpd);
GtkWidget*       global_prefs_sound_ops         (GlobalPrefsData *gpd);
GtkWidget*       global_prefs_speed_ops         (GlobalPrefsData *gpd);
GtkWidget*       global_prefs_joystick_ops      (GlobalPrefsData *gpd);

/* Setup. */
void             global_prefs_nosound_cb        (GtkWidget *widget, GlobalPrefsData *gpd);
void             global_prefs_nojoy_cb          (GtkWidget *widget, GlobalPrefsData *gpd);
void             global_prefs_dialog_changed_cb (GtkWidget *widget, GlobalPrefsData *rpd);
void             global_prefs_connect_changes   (GlobalPrefsData *gpd);
void             global_prefs_set_tooltips      (GlobalPrefsData *gpd);
void             global_prefs_dialog_set_status (GlobalPrefsData *gpd);
void             global_prefs_dialog_get_status (GlobalPrefsData *rpd);

/* Dialog buttons. */
void             global_prefs_apply_cb          (GtkWidget *widget, GlobalPrefsData *gpd);
void             global_prefs_close_cb          (GtkWidget *widget, GlobalPrefsData *gpd);
void             global_prefs_help_cb           (GtkWidget *widget, GtkWidget *notebook);

/* Close functions.  */
void             global_prefs_destroy_cb        (GtkWidget *widget, GlobalPrefsData *rpd);
gboolean         global_prefs_delete_cb         (GtkWidget *widget);
void             global_prefs_free_cb           (GtkWidget *widget, GlobalPrefsData *rpd);

/* Messages. */
void             no_global_data                 (GlobalPrefsData *gpd);

#endif

/* globalprefs.h ends here. */
