/*

	history_c

*/

#include "header.h"

GList *load_history(GList *list) {
	
	FILE *fp;
	char *fname = _NULL;
	char *buf = _NULL;
	gint count = 0;

	buf = dalloc(buf, BUFLEN);
	list = _NULL;
	fname = find_home_path(fname, HISTFILE);	

	if (fp = fopen(fname, "r")) {

		while (count < HISTLEN) {

			fgets(buf, BUFLEN, fp);
			buf[strlen(buf) - 1] = 0;

			if (!feof(fp)) {
				list = g_list_prepend(list, strdup(buf)); 
				count++;
			} else
				count = HISTLEN;
		}

		fclose(fp);

	}
	
	dfree(buf);
	return list;
}


GList *save_history(GList *list, gpointer name) {

	FILE *fp;

	gpointer data;
	gchar *nstr;
	gchar *str;
	GList *cur;
	char *fname = _NULL;
	
	cur = g_list_first(list);

	while (cur) {
		str=(gchar *) cur->data;

		if (str)
			if(!strcasecmp(str,nstr)) 
				return list; /* already one */
		
		cur=g_list_next(cur); 
	};

	if (g_list_length(list) == HISTLEN) {
		g_list_remove(list, g_list_last(list)->data);
	}
	 
	list = g_list_prepend(list, g_strdup(name));
	fname = find_home_path(fname, HISTFILE);	
	cur = g_list_first(list);

	if (fp = fopen(fname, "w")) {
		while(cur) {
			fprintf(fp, "%s\n", (gchar *) cur->data);
			cur = g_list_next(cur);
		};
		fclose(fp);
	}

	dfree(fname);
	return list;
}

