
/* image data and metadata */
struct ida_image_info {
    int width;
    int height;
    int dpi;
};
struct ida_image {
    struct ida_image_info  i;
    unsigned char          *data;
};

/* load image files */
struct ida_loader {
    char  *magic;
    int   moff;
    int   mlen;
    char  *name;
    void* (*init)(FILE *fp, char *filename, struct ida_image_info *i);
    void  (*read)(unsigned char *dst, int line, void *data);
    void  (*done)(void *data);
};

/* ----------------------------------------------------------------------- */
/* resolution                                                              */

#define res_cm_to_inch(x) ((x * 2540 + 5) / 1000)
#define res_m_to_inch(x)  ((x * 2540 + 5) / 100000)
#define res_inch_to_m(x)  ((x * 100000 + 5) / 2540)

/* ----------------------------------------------------------------------- */

/* helpers */
void load_gray(unsigned char *dst, unsigned char *src, int width);
void load_graya(unsigned char *dst, unsigned char *src, int width);
void load_rgba(unsigned char *dst, unsigned char *src, int width);

/* import */
extern struct ida_loader ppm_loader;
extern struct ida_loader pgm_loader;
extern struct ida_loader xwd_loader;
extern struct ida_loader pcd_loader;
extern struct ida_loader xpm_loader;
extern struct ida_loader xbm1_loader;
extern struct ida_loader xbm2_loader;
extern struct ida_loader bmp_loader;
extern struct ida_loader jpeg_loader;
extern struct ida_loader gif_loader;
extern struct ida_loader png_loader;
extern struct ida_loader tiff1_loader;
extern struct ida_loader tiff2_loader;
extern struct ida_loader magick_loader;
extern struct ida_loader sane_loader;

/* export */
extern struct ida_writer ppm_writer;
extern struct ida_writer jpeg_writer;
extern struct ida_writer tiff_writer;
extern struct ida_writer ps_writer;
extern struct ida_writer png_writer;

/* lists */
extern struct ida_loader *loaders[];
extern struct ida_writer *writers[];

/* other */
extern int debug;
