/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Available
extends Task {
    private String property;
    private String classname;
    private File file;
    private String resource;
    private Path classpath;
    private AntClassLoader loader;
    private String value = "true";

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setClassname(String string) {
        if (!"".equals(string)) {
            this.classname = string;
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("property attribute is required", this.location);
        }
        if (this.classname == null && this.file == null && this.resource == null) {
            throw new BuildException("At least one of (classname|file|resource) is required", this.location);
        }
        if (this.classpath != null) {
            this.loader = new AntClassLoader(this.project, this.classpath, false);
        }
        if (this.classname != null && !this.checkClass(this.classname)) {
            this.log("Unable to load class " + this.classname + " to set property " + this.property, 3);
            return;
        }
        if (this.file != null && !this.checkFile(this.file)) {
            this.log("Unable to find file " + this.file + " to set property " + this.property, 3);
            return;
        }
        if (this.resource != null && !this.checkResource(this.resource)) {
            this.log("Unable to load resource " + this.resource + " to set property " + this.property, 3);
            return;
        }
        this.project.setProperty(this.property, this.value);
    }

    private boolean checkFile(File file) {
        return file.exists();
    }

    private boolean checkResource(String string) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(string) != null;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            return classLoader.getResourceAsStream(string) != null;
        }
        return ClassLoader.getSystemResourceAsStream(string) != null;
    }

    private boolean checkClass(String string) {
        try {
            if (this.loader != null) {
                this.loader.loadClass(string);
            } else {
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader != null) {
                    classLoader.loadClass(string);
                } else {
                    Class.forName(string);
                }
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }
}

