/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jde.debugger.Application;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.command.DebugCommandFactory;

public class Jdebug
extends Thread
implements Protocol {
    BufferedReader in;
    PrintWriter out;
    Map applications;
    private Collection pendingCommands;
    public static final Integer debuggerID = new Integer(-1);
    public static Jdebug theDebugger = new Jdebug();

    protected Jdebug() {
    }

    public void init() throws IOException {
        this.out = new PrintWriter(System.out);
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.applications = Collections.synchronizedMap(new HashMap());
        this.pendingCommands = Collections.synchronizedSet(new HashSet());
    }

    private void setSyntax(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.quoteChar(34);
    }

    /*
     * Loose catch block
     */
    public void run() {
        block21: {
            StreamTokenizer streamTokenizer = new StreamTokenizer(this.in);
            this.setSyntax(streamTokenizer);
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                try {
                    List list;
                    String string;
                    Integer n2;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (n != 10) {
                        if (n == -1) {
                            throw new IOException("I/O EOF occured");
                        }
                        if (n == -3) {
                            arrayList.add(streamTokenizer.sval);
                        } else if (n == 34 || n == 39) {
                            arrayList.add(streamTokenizer.sval);
                        } else {
                            arrayList.add(String.valueOf((char)n));
                        }
                        n = streamTokenizer.nextToken();
                    }
                    if (arrayList.size() < 3) {
                        if (arrayList.size() > 0) {
                            this.signalCommandError(debuggerID, new Integer(-1), "Malformed command");
                        }
                        n = streamTokenizer.nextToken();
                        continue;
                    }
                    final Integer n3 = Integer.valueOf(arrayList.get(0).toString());
                    Thread thread = DebugCommandFactory.theFactory.createCommand(n3, n2 = Integer.valueOf(arrayList.get(1).toString()), string = arrayList.get(2).toString().toLowerCase(), list = arrayList.subList(3, arrayList.size()));
                    if (thread == null) {
                        thread = new Thread("Executing (" + n3 + "," + n2 + ")"){

                            public void run() {
                                Jdebug.this.handleAppCommand(n3, n2, string, list);
                            }
                        };
                    }
                    thread.start();
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {
                    this.signalCommandError(debuggerID, new Integer(-1), "Malformed command: " + exception.toString());
                }
                n = streamTokenizer.nextToken();
            }
            Object var10_12 = null;
            try {
                this.shutdown();
            }
            catch (Exception exception) {}
            break block21;
            {
                catch (IOException iOException) {
                    Object var10_13 = null;
                    try {
                        this.shutdown();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    this.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void handleAppCommand(Integer n, Integer n2, String string, List list) {
        Application application;
        Map map = this.applications;
        synchronized (map) {
            if (!this.applications.containsKey(n)) {
                this.signalCommandError(debuggerID, n2, "Application ID '" + n + "' does not exist");
                return;
            }
        }
        Map map2 = this.applications;
        synchronized (map2) {
            application = (Application)this.applications.get(n);
            if (application == null) {
                this.signalCommandError(debuggerID, n2, "Application ID '" + n + "' does not correspond to a valid application");
            }
        }
        application.handleCommand(n2, string, list);
    }

    public void addApplication(Integer n, Application application) {
        Map map = this.applications;
        synchronized (map) {
            this.applications.put(n, application);
        }
    }

    public void removeApplication(Integer n) {
        Map map = this.applications;
        synchronized (map) {
            this.applications.remove(n);
        }
    }

    public boolean appExists(Integer n) {
        Map map = this.applications;
        synchronized (map) {
            boolean bl = this.applications.containsKey(n);
            return bl;
        }
    }

    public Application getApplication(Integer n) {
        Map map = this.applications;
        synchronized (map) {
            Application application = (Application)this.applications.get(n);
            return application;
        }
    }

    public void addPendingCommand(Integer n) {
        Collection collection = this.pendingCommands;
        synchronized (collection) {
            this.pendingCommands.add(n);
        }
    }

    public void removePendingCommand(Integer n) {
        Collection collection = this.pendingCommands;
        synchronized (collection) {
            this.pendingCommands.remove(n);
        }
    }

    public boolean pendingCmdExists(Integer n) {
        Collection collection = this.pendingCommands;
        synchronized (collection) {
            boolean bl = this.pendingCommands.contains(n);
            return bl;
        }
    }

    public void shutdown() throws JDEException {
        Map map = this.applications;
        synchronized (map) {
            Iterator iterator = this.applications.values().iterator();
            while (iterator.hasNext()) {
                ((Application)iterator.next()).shutdown();
                iterator.remove();
            }
        }
    }

    public String stringRep(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return "\"" + object.toString() + "\"";
        }
        if (object instanceof List) {
            StringBuffer stringBuffer = new StringBuffer("");
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(this.stringRep(iterator.next()) + " ");
            }
            return Protocol.BR + stringBuffer.toString().trim();
        }
        return object.toString();
    }

    public synchronized void signal(Integer n, String string, Object object) {
        String string2 = this.stringRep(object);
        if (string2.equals("")) {
            System.out.println(Protocol.BR + "(" + "jde-dbo-" + string + " " + n + ")" + Protocol.BR);
        } else {
            String string3 = "(jde-dbo-" + string + Protocol.BR + n + " " + this.stringRep(object) + ")";
            if (string3.length() <= 80) {
                System.out.println(Protocol.BR + "(" + "jde-dbo-" + string + " " + n + " " + this.stringRep(object) + ")" + Protocol.BR);
            } else {
                System.out.println(Protocol.BR + string3 + Protocol.BR);
            }
        }
        System.out.flush();
    }

    private synchronized void signalReply(Integer n, Integer n2, Object object, String string) {
        String string2 = this.stringRep(object);
        if (string2.equals("")) {
            System.out.println(Protocol.BR + "(" + string + " " + n2 + ")" + Protocol.BR);
        } else {
            String string3 = "(" + string + Protocol.BR + n2 + " " + string2 + ")";
            if (string3.length() <= 80) {
                System.out.println(Protocol.BR + "(" + string + " " + n2 + " " + string2 + ")" + Protocol.BR);
            } else {
                System.out.println(Protocol.BR + string3 + Protocol.BR);
            }
        }
        System.out.flush();
    }

    public void signalCommandResult(Integer n, Integer n2) {
        this.signalCommandResult(n, n2, null);
    }

    public void signalDebug(String string) {
        this.signal(debuggerID, "message", string);
    }

    public synchronized void signalCommandResult(Integer n, Integer n2, Object object) {
        this.signalReply(n, n2, object, "jde-dbo-command-result");
    }

    public synchronized void signalCommandError(Integer n, Integer n2, Object object) {
        this.signalReply(n, n2, object, "jde-dbo-command-error");
    }
}

