/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.InterpreterError;
import bsh.NameSpace;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.TargetErrorPrinter;
import java.lang.reflect.InvocationTargetException;

public class TargetError
extends EvalError
implements TargetErrorPrinter {
    Throwable target;
    TargetErrorPrinter targetPrinter;

    public TargetError(String string, Throwable throwable, SimpleNode simpleNode) {
        super(string, simpleNode);
        this.target = throwable;
    }

    public TargetError(Throwable throwable, SimpleNode simpleNode) {
        this("TargetError", throwable, simpleNode);
    }

    public Throwable getTarget() {
        if (this.target instanceof InvocationTargetException) {
            return ((InvocationTargetException)this.target).getTargetException();
        }
        return this.target;
    }

    public String toString() {
        return super.toString() + "\nTarget exception: " + this.getTargetErrorPrinter().printTargetError(this.target);
    }

    public void printStackTrace() {
        super.printStackTrace();
        System.out.println("--- Target Stack Trace ---");
        this.target.printStackTrace();
    }

    public void reThrow(String string) throws TargetError {
        throw new TargetError(string + ":" + this.getMessage(), this.target, this.node);
    }

    public TargetErrorPrinter getTargetErrorPrinter() {
        if (this.targetPrinter == null) {
            try {
                this.targetPrinter = NameSpace.haveProxyMechanism() ? (TargetErrorPrinter)Reflect.constructObject("bsh.XTargetErrorPrinter", new Object[0]) : this;
            }
            catch (Exception exception) {
                throw new InterpreterError("internal error 1 in TargetError: " + exception);
            }
        }
        return this.targetPrinter;
    }

    public String printTargetError(Throwable throwable) {
        return this.target.toString();
    }
}

