/*
 * Decompiled with CFR 0.152.
 */
package smr.util;

import java.util.Enumeration;
import java.util.Vector;
import smr.util.VisitNode;

public class Node {
    Vector outEdges = new Vector();
    Vector inEdges = new Vector();
    boolean isDiscovered;
    boolean isFinished;

    public Node() {
        this.DFSReset();
    }

    public void linkTo(Node node) {
        if (node != this && !this.outEdges.contains(node)) {
            this.outEdges.addElement(node);
            node.inEdges.addElement(this);
        }
    }

    public Enumeration neighbours() {
        return this.outEdges.elements();
    }

    void transpose() {
        Vector vector = this.outEdges;
        this.outEdges = this.inEdges;
        this.inEdges = vector;
    }

    void DFSReset() {
        this.isFinished = false;
        this.isDiscovered = false;
    }

    void DFSVisit(VisitNode visitNode, VisitNode visitNode2) {
        this.isDiscovered = true;
        if (visitNode != null) {
            visitNode.visit(this);
        }
        Enumeration enumeration = this.neighbours();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (node.isDiscovered) continue;
            node.DFSVisit(visitNode, visitNode2);
        }
        this.isFinished = true;
        if (visitNode2 != null) {
            visitNode2.visit(this);
        }
    }
}

