/*
 * Copyright (c) 1997-2000 The Java Apache Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Java Apache 
 *    Project for use in the Apache JServ servlet engine project
 *    <http://java.apache.org/>."
 *
 * 4. The names "Apache JServ", "Apache JServ Servlet Engine" and 
 *    "Java Apache Project" must not be used to endorse or promote products 
 *    derived from this software without prior written permission.
 *
 * 5. Products derived from this software may not be called "Apache JServ"
 *    nor may "Apache" nor "Apache JServ" appear in their names without 
 *    prior written permission of the Java Apache Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Java Apache 
 *    Project for use in the Apache JServ servlet engine project
 *    <http://java.apache.org/>."
 *    
 * THIS SOFTWARE IS PROVIDED BY THE JAVA APACHE PROJECT "AS IS" AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE JAVA APACHE PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Java Apache Group. For more information
 * on the Java Apache Project and the Apache JServ Servlet Engine project,
 * please see <http://java.apache.org/>.
 *
 */

/*****************************************************************************
 * Description: command-line tool to edit the shared memory file contents    *
 * Comments:    MT-unsafe                                                    *
 * Author:      christos@zoulas.com (Christos Zoulas)                        *
 * has to be linked with jserv_mmap.o                                        *
 * Version:     $Revision: 1.2 $                                             *
 *****************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <stdarg.h>

#include <netinet/in.h>

#include "jserv.h"

static int list(void);
static int change(char **, int);
static void usage(void);
static char *progname = "argv[0]";
static int verbose = 10;

static void
usage()
{
        fprintf(stderr, "Usage: %s [-v] [-s <shmfile>] <list|up|down|shutdown|halt> [<host>]...\n", progname);
        exit(1);
}

int
main(argc, argv)
        int argc;
        char *argv[];
{
        int c;
        char *shm = NULL;

        if ((progname = strrchr(argv[0], '/')) == NULL)
                progname = argv[0];
        else
                progname++;

        while ((c = getopt(argc, argv, "vs:")) != -1) {
                switch (c) {
                case 'v':
                        verbose = 0;
                        break;
                case 's':
                        shm = optarg;
                        break;
                default:
                        usage();
                        break;
                }

        }

        if (access(shm, W_OK) == -1) {
                fprintf(stderr, "%s: Cannot access `%s' (%s)", progname, shm,
                    strerror(errno));
                return 1;
        }

        if (!mmapjservfile(NULL, shm)) {
                fprintf(stderr, "%s: Cannot mmap `%s' (%s)", progname, shm,
                    strerror(errno));
                return 1;
        }

        argv += optind;
        argc -= optind;

        if (argc == 0)
                usage();
        if (strcmp(argv[0], "list") == 0) {
                return list();
        } else if (strcmp(argv[0], "shutdown") == 0) {
                return change(argv + 1, '/');
        } else if (strcmp(argv[0], "halt") == 0) {
                return change(argv + 1, 'X');
        } else if (strcmp(argv[0], "down") == 0) {
                return change(argv + 1, '-');
        } else if (strcmp(argv[0], "up") == 0) {
                return change(argv + 1, '+');
        } else
                usage();
        /*NOTREACHED*/
}

static int
list()
{
        ShmHost *h, space;
        struct in_addr ia;

        for (h = jserv_get1st_host(&space); h != NULL;
             h = jserv_getnext_host(&space)) {
                ia.s_addr = (unsigned int) h->ip;
                printf("%20.20s\t%c\t%15.15s\t%5u\n",
                        h->name, h->state, inet_ntoa(ia), h->port);
        }
        return 0;
}

static int
change(hlist, state)
        char **hlist;
        int state;
{
        ShmHost *h, space;
        int error = 0;

        for (; *hlist; hlist++) {
                for (h = jserv_get1st_host(&space); h != NULL;
                     h = jserv_getnext_host(&space))
                        if (strcmp(h->name, *hlist) == 0)
                                break;
                if (h == NULL) {
                        (void)fprintf(stderr, "Host `%s' not found\n",
                            *hlist);
                        error++;
                        continue;
                }
                jserv_changeexistingstate(h->name, "+-/X", state);
        }
        return error;
}

void
jserv_error(const char *file, int line, int level, jserv_config *cfg, const char *fmt, ...)
{
        va_list ap;
        if (level < verbose)
                return;
                
        fprintf(stderr, "%s, %d [%d]: ", file, line, level);
        va_start(ap, fmt);
        vfprintf(stderr, fmt, ap);
        fprintf(stderr, "\n");
        va_end(ap);
}

void ap_block_alarms() {}
void ap_unblock_alarms() {}


