package com.clarkware.junitperf;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * The <code>JUnitPerfTestSuite</code> is a <code>TestCase</code> 
 * for the JUnitPerf package.
 * 
 * @author <a href="mailto:mike@clarkware.com">Mike Clark</a>
 * @author <a href="http://www.clarkware.com">Clarkware Consulting, Inc.</a>
 */

public class JUnitPerfTestSuite extends TestCase {

	/**
	 * Constructs an <code>JUnitPerfTestSuite</code>
	 * with the specified name.
	 *
	 * @param name Test name.
	 */
	public JUnitPerfTestSuite(String name) {
		super(name);
	}

	/**
	 * Assembles and returns a test suite 
	 * containing all JUnitPerf tests.
	 *
	 * @return A non-null <code>Test</code> instance.
	 */
	public static Test suite() {
		TestSuite suite = new TestSuite();

		suite.addTest(LoadTestTest.suite());
		suite.addTest(TimedTestTest.suite());

		return suite;
	}
		
	/**
	 * Main.
	 */
	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}
}
