#ifndef TEST_H
#define TEST_H

#include <qdialog.h>

#include "translator.h"
#include "registry.h"


//========================================================================
// $Id: test.h,v 1.5 2001/01/26 07:32:19 radnev Exp $
//========================================================================


class QLineEdit;
class QPushButton;
class QLabel;
class QTextView;
class QCheckBox;
class QSpinBox;
class QComboBox;
class QFont;


class Test:public QDialog {

Q_OBJECT

public:
	Test(QWidget *parent, const char *name, Translator *pDictionary, Registry *pReg, const QFont *pFont, const int pBorderWidth);
	~Test();

protected:
	void resizeEvent(QResizeEvent *resizeEvent);
	void setView();

protected slots:
	void answer_EnterPressed();
	void button_New();
	void button_Help();

private:
	QFont font;
	QLineEdit *answer;
	QPushButton *bnew;
	QPushButton *bclose;
	QPushButton *bhelp;
	QLabel *question;
	QLabel *found;
	QLabel *word;
	QLabel *info;
	QTextView *result;

	Translator *dictionary;
	Registry *reg;
	int borderWidth;

	int translate;
	int showAnswer;
	int session;
	int questions;
	int level;

	int current;
	int correct;

	char *buf;

}; // End of class Test

#endif
