/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.om;

import com.icl.saxon.om.DocumentInfo;

public final class DocumentPool {
    private DocumentInfo[] documents = new DocumentInfo[10];
    private String[] documentNames = new String[10];
    private int numberOfDocuments = 0;

    public int add(DocumentInfo documentInfo, String string) {
        int n = this.getDocumentNumber(documentInfo);
        if (n >= 0) {
            return n;
        }
        if (this.numberOfDocuments == this.documents.length) {
            DocumentInfo[] documentInfoArray = new DocumentInfo[this.numberOfDocuments * 2];
            System.arraycopy(this.documents, 0, documentInfoArray, 0, this.numberOfDocuments);
            this.documents = documentInfoArray;
            String[] stringArray = new String[this.numberOfDocuments * 2];
            System.arraycopy(this.documentNames, 0, stringArray, 0, this.numberOfDocuments);
            this.documentNames = stringArray;
        }
        if (this.numberOfDocuments == 65535) {
            throw new UnsupportedOperationException("Too many documents in one transformation: limit is 65535");
        }
        int n2 = this.numberOfDocuments++;
        this.documents[n2] = documentInfo;
        this.documentNames[n2] = string;
        return n2;
    }

    public int getDocumentNumber(DocumentInfo documentInfo) {
        int n = 0;
        while (n < this.numberOfDocuments) {
            if (this.documents[n] == documentInfo) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public DocumentInfo find(String string) {
        int n = 0;
        while (n < this.numberOfDocuments) {
            if (string.equals(this.documentNames[n])) {
                return this.documents[n];
            }
            ++n;
        }
        return null;
    }

    public int getNumberOfDocuments() {
        return this.numberOfDocuments;
    }
}

