/* AbstractGraphGeneratorInstance.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.generators.graphs;

import org.grinvin.graphs.Embedding;
import org.grinvin.graphs.Graph;
import org.grinvin.graphs.GraphBundle;

/**
 * Abstract super class of all graph generator instances.
 */
public abstract class AbstractGraphGeneratorInstance implements GraphGeneratorInstance {
    
    //
    private final String name;

    public String getName() {
        return name;
    }
    
    //
    private final String id;

    public String getId() {
        return this.id;
    }
    
    //
    private final String description;

    public String getDescription() {
        return description;
    }
    
    //
    public AbstractGraphGeneratorInstance (AbstractGraphGenerator agg) {
        this.id = agg.getInstanceId();
        this.name = agg.getInstanceName();
        this.description = agg.getInstanceDescription();
    }
    
    /**
     * Auxiliary method that creates a cyclic embedding for the given bundle.
     */
    protected static void createCyclicEmbedding (GraphBundle bundle) {
        
        // TODO: should go into a different class?
        
        Graph graph = bundle.getGraph();
        int order = graph.getNumberOfVertices();
        Embedding embedding = bundle.createEmbedding();
        if (embedding != null) {
            embedding.setDimension(2);
            for(int i = 0; i < order; i++) {
                double angle = 2 * i * Math.PI / order;
                double[] coords = new double[2];
                coords[0] = Math.cos(angle);
                coords[1] = Math.sin(angle);
                embedding.setCoordinates(graph.getVertex(i), coords);
            }
        }
    }
    
}
