/* GraphEditor3D.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred;

import be.ugent.caagt.swirl.menus.MenuBuilder;
import be.ugent.caagt.swirl.mouse.MouseTool;

import java.awt.BorderLayout;
import java.util.ResourceBundle;
import javax.swing.ActionMap;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

import org.grinvin.graphs.AnnotationModel;
import org.grinvin.graphs.EmbeddingModel;
import org.grinvin.graphs.render.DefaultRenderer;
import org.grinvin.graphs.render.Renderer;
import org.grinvin.gred.actions.ClearSelection;
import org.grinvin.gred.actions.SelectAll;
import org.grinvin.gred.mouse.RollOverOverlay;
import org.grinvin.gred.mouse.Rotate3D;
import org.grinvin.gred.mouse.SelectElements;
import org.grinvin.gred.mouse.SelectRectangle;
import org.grinvin.gred.transformations.OrthogonalProjection;

/**
 * Graph editor window for three-dimensional embeddings
 */
public class GraphEditor3D extends JFrame {

    /**
     * Create an editor that uses the given embedding model and context.
     * This constructor is mainly useful when models and contexts should be
     * shared between editors. In most cases users should use the
     * no argument constructor.
     */
    public GraphEditor3D (EmbeddingModel model, AnnotationModel annotationModel, GraphContext context) {
        super ();
        ResourceBundle rbundle = ResourceBundle.getBundle ("org.grinvin.gred.editor");
        setTitle (rbundle.getString ("editor3D.title"));
        
        Renderer renderer = DefaultRenderer.getInstance();
        OrthogonalProjection trans = new OrthogonalProjection ();
        trans.rotateXY (0.6, 0.6);
        GraphPanel3D panel = new GraphPanel3D (model, trans, annotationModel, renderer, context, 100);
        RollOverOverlay roo = new RollOverOverlay (panel);
        
        MouseTool rotationTool = new MouseTool ();
        rotationTool.addHandler (Rotate3D.getHandler ());
        roo.setTool (rotationTool);
        
        MouseTool selectionTool = new MouseTool ();
        //selectionTool.addHandler (MoveSelection.getHandler ());
        selectionTool.addHandler (SelectElements.getHandler ());
        selectionTool.addHandler (SelectRectangle.getHandler ());
        roo.setTool (selectionTool);
        
        MenuBuilder menuBuilder = new MenuBuilder();
        menuBuilder.load("/org/grinvin/gred/editor3d-menus.xml",
                "org.grinvin.gred.editor-menus");
        
        ActionMap actionMap = menuBuilder.getActionMap();
        actionMap.setParent(panel.getActionMap());
        panel.setActionMap(actionMap);

        // initialize actions
        actionMap.put("ClearSelection", new ClearSelection(panel));

        actionMap.put("SelectAll", new SelectAll(panel));

        // Register mouse tools group
        menuBuilder.registerGroup("tools",
                roo.getMouseToolModel(),
                "tool.selection", selectionTool,
                "tool.rotation", rotationTool);
        
        JMenuBar menuBar = menuBuilder.createJMenuBar("main.menu");
        setJMenuBar(menuBar);
        JToolBar toolBar = menuBuilder.createJToolBar("toolbar");
        add (toolBar, BorderLayout.NORTH);
        
        pack ();
        setVisible (true);
    }
    
}
