/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.remoting.transport.multiplex.config;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transport.multiplex.InputMultiplexor;
import org.jboss.remoting.transport.multiplex.Multiplex;
import org.jboss.remoting.transport.multiplex.MultiplexClientInvoker;
import org.jboss.remoting.transport.multiplex.MultiplexServerInvoker;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.OutputMultiplexor;
import org.jboss.remoting.transport.multiplex.VirtualSocket;


/**
 * 
 * @author <a href="mailto:ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision$
 * <p>
 * Copyright (c) May 20, 2006
 * </p>
 */
public class ClientConfigurationByMapTestClient extends ClientConfigurationTestClient
{
   
   public void testConfigurationByMap()
   {
      log.info("entering " + getName());
      
      try
      {
         // Create HashMap with parameters.
         HashMap conf = new HashMap();
         
         // MultiplexingManager parameters
         conf.put(Multiplex.STATIC_THREADS_MONITOR_PERIOD,
               new Integer(2 + Multiplex.STATIC_THREADS_MONITOR_PERIOD_DEFAULT));
         conf.put(Multiplex.SHUTDOWN_REQUEST_TIMEOUT,
               new Integer(3 + Multiplex.SHUTDOWN_REQUEST_TIMEOUT_DEFAULT));
         conf.put(Multiplex.SHUTDOWN_REFUSALS_MAXIMUM,
               new Integer(4 + Multiplex.SHUTDOWN_REFUSALS_MAXIMUM_DEFAULT));
         conf.put(Multiplex.SHUTDOWN_MONITOR_PERIOD,
               new Integer(5 + Multiplex.SHUTDOWN_MONITOR_PERIOD_DEFAULT));
         
         // InputMultiplexor parameters
         conf.put(Multiplex.INPUT_BUFFER_SIZE,
               new Integer(2 + Multiplex.INPUT_BUFFER_SIZE_DEFAULT));
         conf.put(Multiplex.INPUT_MAX_ERRORS,
               new Integer(3 + Multiplex.INPUT_MAX_ERRORS_DEFAULT));
         
         // OutputMultiplexor parameters
         conf.put(Multiplex.OUTPUT_MESSAGE_POOL_SIZE,
               new Integer(2 + Multiplex.OUTPUT_MESSAGE_POOL_SIZE_DEFAULT));
         conf.put(Multiplex.OUTPUT_MESSAGE_SIZE,
               new Integer(3 + Multiplex.OUTPUT_MESSAGE_SIZE_DEFAULT));
         conf.put(Multiplex.OUTPUT_MAX_CHUNK_SIZE,
               new Integer(4 + Multiplex.OUTPUT_MAX_CHUNK_SIZE_DEFAULT));
         conf.put(Multiplex.OUTPUT_MAX_TIME_SLICE,
               new Integer(5 + Multiplex.OUTPUT_MAX_TIME_SLICE_DEFAULT));
         conf.put(Multiplex.OUTPUT_MAX_DATA_SLICE,
               new Integer(6 + Multiplex.OUTPUT_MAX_DATA_SLICE_DEFAULT));
 
         log.info("configuration: " + conf);
         
         // Create Client.
         InvokerLocator locator = new InvokerLocator(ClientConfigurationTestServer.connectorURI);
         Client client = new Client(locator, conf);
         client.connect();
         
         // Tell test server to connect.
         os.write(13);
         
         /////////////////////////////////////////////////////////////////////////////////////
         // Get MultiplexingManager.
         MultiplexClientInvoker invoker = (MultiplexClientInvoker) client.getInvoker();
         Field field = MultiplexClientInvoker.class.getDeclaredField("socketGroupInfo");
         field.setAccessible(true);
         Object o = field.get(invoker);
         MultiplexServerInvoker.SocketGroupInfo sgi = (MultiplexServerInvoker.SocketGroupInfo) o;
         VirtualSocket vs = sgi.getPrimingSocket();
         MultiplexingManager manager = vs.getMultiplexingManager();
         
         // Test MultiplexingManager parameters.
         field = MultiplexingManager.class.getDeclaredField("staticThreadsMonitorPeriod");
         field.setAccessible(true);
         assertEquals(field.getInt(manager), 2 + Multiplex.STATIC_THREADS_MONITOR_PERIOD_DEFAULT);
         
         field = MultiplexingManager.class.getDeclaredField("shutdownRequestTimeout");
         field.setAccessible(true);
         assertEquals(field.getInt(manager), 3 + Multiplex.SHUTDOWN_REQUEST_TIMEOUT_DEFAULT);
         
         field = MultiplexingManager.class.getDeclaredField("shutdownRefusalsMaximum");
         field.setAccessible(true);
         assertEquals(field.getInt(manager), 4 + Multiplex.SHUTDOWN_REFUSALS_MAXIMUM_DEFAULT);
         
         field = MultiplexingManager.class.getDeclaredField("shutdownMonitorPeriod");
         field.setAccessible(true);
         assertEquals(field.getInt(manager), 5 + Multiplex.SHUTDOWN_MONITOR_PERIOD_DEFAULT);
         
         /////////////////////////////////////////////////////////////////////////////////////
         // Get InputMultiplexor.
         field =  MultiplexingManager.class.getDeclaredField("inputMultiplexor");
         field.setAccessible(true);
         InputMultiplexor inputMultiplexor = (InputMultiplexor) field.get(manager);
         log.info("inputMultiplexor: " + inputMultiplexor);
         
         // Test InputMultiplexor parameters.
         field = InputMultiplexor.class.getDeclaredField("bufferSize");
         field.setAccessible(true);
         assertEquals(field.getInt(inputMultiplexor), 2 + Multiplex.INPUT_BUFFER_SIZE_DEFAULT);
         
         field = InputMultiplexor.class.getDeclaredField("maxErrors");
         field.setAccessible(true);
         assertEquals(field.getInt(inputMultiplexor), 3 + Multiplex.INPUT_MAX_ERRORS_DEFAULT);
         
         /////////////////////////////////////////////////////////////////////////////////////
         // Get OutputMultiplexor.
         field =  MultiplexingManager.class.getDeclaredField("outputMultiplexor");
         field.setAccessible(true);
         OutputMultiplexor outputMultiplexor = (OutputMultiplexor) field.get(manager);
         log.info("outputMultiplexor: " + outputMultiplexor);
         
         // Test OutputMultiplexor parameters.
         field = OutputMultiplexor.class.getDeclaredField("messagePoolSize");
         field.setAccessible(true);
         assertEquals(field.getInt(outputMultiplexor), 2 + Multiplex.OUTPUT_MESSAGE_POOL_SIZE_DEFAULT);
         
         field = OutputMultiplexor.class.getDeclaredField("messagePool");
         field.setAccessible(true);
         List messagePool = (List) field.get(outputMultiplexor);
         assertTrue(messagePool.size() <= 2 + Multiplex.OUTPUT_MESSAGE_POOL_SIZE_DEFAULT);
         
         field = OutputMultiplexor.class.getDeclaredField("messageSize");
         field.setAccessible(true);
         assertEquals(field.getInt(outputMultiplexor), 3 + Multiplex.OUTPUT_MESSAGE_SIZE_DEFAULT);
         
         Object message = messagePool.get(0);
         field = message.getClass().getDeclaredField("baos");
         field.setAccessible(true);
         ByteArrayOutputStream baos = (ByteArrayOutputStream) field.get(message);
         field = ByteArrayOutputStream.class.getDeclaredField("buf");
         field.setAccessible(true);
         byte[] buf = (byte[]) field.get(baos);
         assertEquals(buf.length, 3 + Multiplex.OUTPUT_MESSAGE_SIZE_DEFAULT);
         
         field = OutputMultiplexor.class.getDeclaredField("maxChunkSize");
         field.setAccessible(true);
         assertEquals(field.getInt(outputMultiplexor), 4 + Multiplex.OUTPUT_MAX_CHUNK_SIZE_DEFAULT);
         
         field = OutputMultiplexor.class.getDeclaredField("buffer");
         field.setAccessible(true);
         ByteBuffer bb = (ByteBuffer) field.get(outputMultiplexor);
         field = OutputMultiplexor.class.getDeclaredField("HEADER_SIZE");
         field.setAccessible(true);
         int headerSize = ((Integer) field.get(outputMultiplexor)).intValue();
         assertEquals(bb.capacity(), 4 + Multiplex.OUTPUT_MAX_CHUNK_SIZE_DEFAULT + headerSize);
         
         field = OutputMultiplexor.class.getDeclaredField("maxTimeSlice");
         field.setAccessible(true);
         assertEquals(field.getInt(outputMultiplexor), 5 + Multiplex.OUTPUT_MAX_TIME_SLICE_DEFAULT);
         
         field = OutputMultiplexor.class.getDeclaredField("maxDataSlice");
         field.setAccessible(true);
         assertEquals(field.getInt(outputMultiplexor), 6 + Multiplex.OUTPUT_MAX_DATA_SLICE_DEFAULT);
 
         client.disconnect();
         
         // Tell test server test is over.
         os.write(7);
         log.info(getName() + " PASSES");
      }
      catch (Exception e)
      {
         log.error(e);
         e.printStackTrace();
         fail();
         log.info(getName() + " FAILS");
      }
   }
   
   
   public void testConclusion()
   {
      try
      {
         if (os != null)
            os.write(3);
         if (syncSocket != null)
            syncSocket.close();
      }
      catch (IOException e)
      {
         log.error(e);
         e.printStackTrace();
      }
   }
}
