/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.exceptions.*;
import com.sap.dbtech.util.MessageKey;
import com.sap.dbtech.util.MessageTranslator;

/**
 *
 */
class MemoryResultSetMetaDataSapDB
    implements java.sql.ResultSetMetaData
{
    private String [] colHeadings;
/**
 *
 * @param colHeadings java.lang.String[]
 */
MemoryResultSetMetaDataSapDB(String [] colHeadings) {
    this.colHeadings = colHeadings;
}
/**
 * getCatalogName method comment.
 */
public String getCatalogName(int column) throws java.sql.SQLException {
    return "";
}
/**
 *
 * @return java.lang.String
 * @param column int
 * @exception java.sql.SQLException The exception description.
 */
public String getColumnClassName(int column) throws java.sql.SQLException {
    throw new NotImplemented (MessageTranslator.translate(MessageKey.ERROR_GETCOLUMNCLASSNAME_NOTIMPLEMENTED));
}
/**
 * getColumnCount method comment.
 */
public int getColumnCount() throws java.sql.SQLException {
    return this.colHeadings.length;
}
/**
 * getColumnDisplaySize method comment.
 */
public int getColumnDisplaySize(int column) throws java.sql.SQLException {
    return 20;
}
/**
 * getColumnLabel method comment.
 */
public String getColumnLabel(int column) throws java.sql.SQLException {
    try {
        return this.colHeadings [column - 1];
    }
    catch (ArrayIndexOutOfBoundsException exc) {
        throw new InvalidColumnException (column, this);
    }

}
/**
 * getColumnName method comment.
 */
public String getColumnName(int column) throws java.sql.SQLException {
    return this.getColumnLabel (column);
}
/**
 * getColumnType method comment.
 */
public int getColumnType(int column) throws java.sql.SQLException {
    return java.sql.Types.CHAR;
}
/**
 * getColumnTypeName method comment.
 */
public String getColumnTypeName(int column) throws java.sql.SQLException {
    return "String";
}
/**
 * getPrecision method comment.
 */
public int getPrecision(int column) throws java.sql.SQLException {
    return 0;
}
/**
 * getScale method comment.
 */
public int getScale(int column) throws java.sql.SQLException {
    return 0;
}
/**
 * getSchemaName method comment.
 */
public String getSchemaName(int column) throws java.sql.SQLException {
    return "";
}
/**
 * getTableName method comment.
 */
public String getTableName(int column) throws java.sql.SQLException {
    return "";
}
/**
 * isAutoIncrement method comment.
 */
public boolean isAutoIncrement(int column) throws java.sql.SQLException {
    return false;
}
/**
 * isCaseSensitive method comment.
 */
public boolean isCaseSensitive(int column) throws java.sql.SQLException {
    return false;
}
/**
 * isCurrency method comment.
 */
public boolean isCurrency(int column) throws java.sql.SQLException {
    return false;
}
/**
 * isDefinitelyWritable method comment.
 */
public boolean isDefinitelyWritable(int column) throws java.sql.SQLException {
    return false;
}
/**
 * isNullable method comment.
 */
public int isNullable(int column) throws java.sql.SQLException {
    return 0;
}
/**
 * isReadOnly method comment.
 */
public boolean isReadOnly(int column) throws java.sql.SQLException {
    return true;
}
/**
 * isSearchable method comment.
 */
public boolean isSearchable(int column) throws java.sql.SQLException {
    return false;
}
/**
 * isSigned method comment.
 */
public boolean isSigned(int column) throws java.sql.SQLException {
    return false;
}
/**
 * isWritable method comment.
 */
public boolean isWritable(int column) throws java.sql.SQLException {
    return false;
}
}
