/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.enhydra.instantdb.db.Column;
import org.enhydra.instantdb.db.Database;
import org.enhydra.instantdb.db.StringColumn;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.Trace;
import org.enhydra.instantdb.db.Transaction;
import org.enhydra.instantdb.db.idbDataOutputStream;
import org.enhydra.instantdb.db.utils;

public class BlobColumn
extends Column {
    long freeOffsetPosn;
    File blobFile;
    RandomAccessFile rndBlob;
    FileDescriptor fd;
    int lastRowFetched;
    int binType;
    private static byte NULL_BLOB = 0;
    byte[] NULL = new byte[]{NULL_BLOB};
    public static byte FILE_BLOB = 1;
    public static byte STRING_BLOB = (byte)2;
    public static byte BINARY_BLOB = (byte)3;
    public static byte OBJECT_BLOB = (byte)4;
    private static long SIZE_OFFSET = 0L;
    private static long NEXT_OFFSET = 8L;
    private static long DATA_SIZE_OFFSET = 16L;
    private static long RESERVED_OFFSET = 24L;
    private static long DATA_OFFSET;
    private static long HEADER_SIZE;
    private static int MAX_WIDTH;

    static {
        HEADER_SIZE = DATA_OFFSET = 32L;
        MAX_WIDTH = 64;
    }

    BlobColumn(Table table, String string, int n) throws SQLException {
        super(table, string, 8);
        this.nullObj = this.NULL;
        this.type = 10;
        this.binType = n;
        this.requiresRecovery = true;
        String string2 = String.valueOf(table.dbase.filename) + "$" + table.getTableName() + "$" + string + ".blb";
        this.blobFile = new File(table.path, string2);
        try {
            String string3 = "rw";
            if (this.dbase.readOnly && this.cTable.tableType != 3) {
                string3 = "r";
            }
            this.rndBlob = new RandomAccessFile(this.blobFile, string3);
            Database cfr_ignored_0 = table.dbase;
            int n2 = 3;
            Database cfr_ignored_1 = table.dbase;
            int n3 = 25;
            if (this.rndBlob.length() == 0L) {
                this.rndBlob.writeInt(n2);
                this.rndBlob.writeInt(n3);
                this.rndBlob.writeInt(this.binType);
                this.freeOffsetPosn = this.rndBlob.getFilePointer();
                this.rndBlob.writeLong(0L);
            } else {
                n2 = this.rndBlob.readInt();
                n3 = this.rndBlob.readInt();
                Database cfr_ignored_2 = table.dbase;
                if (n2 > 3) {
                    throw new SQLException("Blob file: " + string2 + " has too high a version number: " + n2);
                }
                if (n3 < 10) {
                    n3 *= 10;
                }
                if (n2 == 2 && n3 >= 34 || n2 > 2) {
                    this.binType = this.rndBlob.readInt();
                }
                this.freeOffsetPosn = this.rndBlob.getFilePointer();
                this.rndBlob.readLong();
            }
            if (table.tableType != 3) {
                this.fd = this.rndBlob.getFD();
                this.fd.sync();
            }
        }
        catch (IOException iOException) {
            throw new SQLException("IO problem with blob file: " + iOException.toString());
        }
    }

    public static String blobToString(Object object) {
        byte[] byArray = (byte[])object;
        if (byArray[0] != STRING_BLOB) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.readByte();
            StringBuffer stringBuffer = new StringBuffer(byArray.length / 2);
            while (dataInputStream.available() > 1) {
                char c = dataInputStream.readChar();
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void close(RandomAccessFile randomAccessFile) throws IOException {
    }

    boolean compare(int n, Object object, int n2, boolean bl) throws SQLException {
        return BlobColumn.compareVals(this.getByRow(n), object, n2, bl);
    }

    static boolean compareVals(Object object, Object object2, int n, boolean bl) throws SQLException {
        byte[] byArray = BlobColumn.objToObject(object);
        byte[] byArray2 = BlobColumn.objToObject(object2);
        if (byArray[0] == STRING_BLOB && byArray2[0] == STRING_BLOB) {
            String string = BlobColumn.objToString(byArray);
            String string2 = BlobColumn.objToString(byArray2);
            return StringColumn.compareVals(string, string2, n, bl);
        }
        if (!(bl || byArray[0] != NULL_BLOB && byArray2[0] != NULL_BLOB)) {
            return false;
        }
        switch (n) {
            case 1: {
                return BlobColumn.equals(byArray, byArray2);
            }
            case 4: {
                return BlobColumn.equals(byArray, byArray2) ^ true;
            }
            case 7: {
                return byArray.length < byArray2.length;
            }
            case 8: {
                return byArray.length <= byArray2.length;
            }
            case 5: {
                return byArray.length > byArray2.length;
            }
            case 6: {
                return byArray.length >= byArray2.length;
            }
        }
        throw new SQLException("Internal error: undefined operation: " + n, "XOPEN?");
    }

    void deleteBlob(long l) throws SQLException {
        try {
            this.rndBlob.seek(this.freeOffsetPosn);
            long l2 = this.rndBlob.readLong();
            this.rndBlob.seek(l + NEXT_OFFSET);
            this.rndBlob.writeLong(l2);
            this.rndBlob.seek(this.freeOffsetPosn);
            this.rndBlob.writeLong(l);
            if (this.fd != null && !this.cTable.fastUpdate) {
                this.fd.sync();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SQLException("IO error adding blob to free list: offset = " + l + " " + iOException.toString());
        }
    }

    static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    void extractBinaryNumbers(String var1_1, DataOutputStream var2_2) throws NumberFormatException {
        var1_1 = var1_1.toLowerCase();
        var3_3 = new StringTokenizer(var1_1, ",", false);
        var4_4 = null;
        if (var3_3.countTokens() == 1 && var1_1.length() % 2 == 0) {
            var4_4 = new byte[var1_1.length() / 2];
            var5_5 = 0;
            while (var5_5 < var1_1.length() / 2) {
                var6_7 = var1_1.substring(var5_5 * 2, var5_5 * 2 + 2);
                try {
                    var7_8 = Integer.valueOf(var6_7, 16);
                    var4_4[var5_5] = (byte)var7_8.intValue();
                }
                catch (NumberFormatException v0) {
                    var4_4 = null;
                    break;
                }
                ++var5_5;
            }
        }
        if (var4_4 == null) ** GOTO lbl46
        try {
            var2_2.write(var4_4, 0, var4_4.length);
        }
        catch (Exception v1) {
            throw new NumberFormatException("Writing value " + var1_1);
        }
        return;
lbl-1000:
        // 1 sources

        {
            var6_7 = var3_3.nextToken().trim();
            if (var6_7.startsWith("0x")) {
                var6_7 = var6_7.substring(2);
                var5_6 = Long.valueOf(var6_7, 16);
            } else {
                var5_6 = Long.valueOf(var6_7);
            }
            var7_9 = var5_6;
            try {
                if (var7_9 > 0x7FFFFFFFL || var7_9 < -2147483648L) {
                    var2_2.writeLong(var7_9);
                    continue;
                }
                if (var7_9 > 32767L || var7_9 < -32768L) {
                    var2_2.writeInt((int)var7_9);
                    continue;
                }
                if (var7_9 > 127L || var7_9 < -128L) {
                    var2_2.writeShort((short)var7_9);
                    continue;
                }
                var2_2.writeByte((byte)var7_9);
                continue;
            }
            catch (IOException v2) {
                throw new NumberFormatException("Writing value " + var5_6);
            }
lbl46:
            // 5 sources

            ** while (var3_3.hasMoreTokens())
        }
lbl47:
        // 1 sources

    }

    Object getByRow(int n) throws SQLException {
        Object object = super.getByRow(n);
        if (object == null) {
            try {
                long l = this.cTable.dataIn.readLong();
                this.cTable.rndFile.freeReadAhead();
                this.rndBlob.seek(l + DATA_SIZE_OFFSET);
                long l2 = this.rndBlob.readLong();
                this.rndBlob.readLong();
                byte[] byArray = new byte[(int)l2];
                this.rndBlob.read(byArray);
                if (this.cTable.encryptor != null) {
                    byArray = this.cTable.encryptor.BinaryDecrypt(this.cTable.tableName, this.colName, byArray, n);
                }
                object = byArray;
            }
            catch (Exception exception) {
                this.cTable.rndFile.freeReadAhead();
                throw new SQLException("Problem reading column, " + this.colName + ", in table, " + this.cTable.tableName + ", " + exception.toString());
            }
            this.rowCache.add(object, n);
        }
        this.lastRowFetched = n;
        return object;
    }

    int getHash(Object object) {
        byte[] byArray = object instanceof String ? (byte[])this.toObject(object) : (byte[])object;
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += byArray[n2];
            ++n2;
        }
        return n;
    }

    public int getMaxWidth() {
        return MAX_WIDTH;
    }

    long getOffsetByRow(int n) throws SQLException {
        long l = 0L;
        try {
            this.cTable.rndFile.readRow(n, this.recOffset);
            l = this.cTable.dataIn.readLong();
            this.cTable.rndFile.freeReadAhead();
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        return l;
    }

    boolean hashPreservesOrder() {
        return false;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public boolean isNull(Object object) {
        byte[] byArray = (byte[])object;
        return byArray[0] == NULL_BLOB;
    }

    boolean numeric() {
        return false;
    }

    static byte[] objToObject(Object object) {
        byte[] byArray;
        block6: {
            block5: {
                byArray = null;
                if (object instanceof String) {
                    String string = (String)object;
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() * 2 + 1);
                        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                        dataOutputStream.writeByte(STRING_BLOB);
                        dataOutputStream.writeChars(string);
                        byArray = byteArrayOutputStream.toByteArray();
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
                if (!(object instanceof byte[])) break block5;
                byArray = (byte[])object;
                break block6;
            }
            if (!(object instanceof Serializable)) break block6;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(OBJECT_BLOB);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    static String objToString(Object object) {
        byte[] byArray = (byte[])object;
        if (byArray[0] == NULL_BLOB) {
            return "NULL";
        }
        try {
            Object object2;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.readByte();
            if (byArray[0] == STRING_BLOB) {
                StringBuffer stringBuffer = new StringBuffer(byArray.length / 2);
                while (dataInputStream.available() > 1) {
                    char c = dataInputStream.readChar();
                    stringBuffer.append(c);
                }
                return stringBuffer.toString();
            }
            if (byArray[0] == OBJECT_BLOB) {
                object2 = new ObjectInputStream(byteArrayInputStream);
                try {
                    Object object3 = ((ObjectInputStream)object2).readObject();
                    if (object3 instanceof int[]) {
                        object3 = utils.getIntArrayAsString(object3);
                    }
                    return object3.toString();
                }
                catch (Exception exception) {}
            }
            object2 = new StringBuffer(byArray.length * 3);
            while (dataInputStream.available() > 0) {
                byte by = dataInputStream.readByte();
                if (by < 16) {
                    ((StringBuffer)object2).append('0');
                }
                ((StringBuffer)object2).append(Integer.toHexString(by));
            }
            return ((StringBuffer)object2).toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void onClose() {
        block3: {
            if (this.rndBlob == null) {
                return;
            }
            super.onClose();
            try {
                this.rndBlob.close();
            }
            catch (IOException iOException) {
                if (!Trace.traceIt(4)) break block3;
                Trace.traceOut("IOException closing blob file: " + iOException.toString());
            }
        }
        this.rndBlob = null;
    }

    void onDelete(RandomAccessFile randomAccessFile, int n, Transaction transaction) throws SQLException {
        super.onDelete(randomAccessFile, n, transaction, null);
        long l = this.getOffsetByRow(n);
        if (transaction != null) {
            transaction.journal.writeTransactionRecord(transaction, 1147300962, 0, this.cTable, this, new Long(l));
        }
    }

    void onDrop() throws SQLException {
        super.onDrop();
        if (this.rndBlob != null) {
            this.onClose();
        }
        this.blobFile.delete();
    }

    void read(RandomAccessFile randomAccessFile) throws IOException {
    }

    Object toObject(Object object) {
        byte[] byArray;
        block13: {
            block14: {
                block12: {
                    byArray = null;
                    if (object == null) {
                        return this.nullObj;
                    }
                    if (!(object instanceof String)) break block12;
                    String string = (String)object;
                    if (this.binType == STRING_BLOB) {
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() * 2 + 1);
                            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                            dataOutputStream.writeByte(STRING_BLOB);
                            dataOutputStream.writeChars(string);
                            byArray = byteArrayOutputStream.toByteArray();
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    try {
                        File file = new File(string);
                        FileInputStream fileInputStream = new FileInputStream(file);
                        byArray = new byte[(int)file.length() + 1];
                        byArray[0] = FILE_BLOB;
                        fileInputStream.read(byArray, 1, byArray.length - 1);
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                    catch (IOException iOException) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() * 2 + 1);
                        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                        try {
                            dataOutputStream.writeByte(BINARY_BLOB);
                            this.extractBinaryNumbers(string, dataOutputStream);
                        }
                        catch (Exception exception) {
                            try {
                                dataOutputStream.close();
                                byteArrayOutputStream.close();
                                byteArrayOutputStream = new ByteArrayOutputStream(string.length() * 2 + 1);
                                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                                dataOutputStream.writeByte(STRING_BLOB);
                                dataOutputStream.writeChars(string);
                            }
                            catch (IOException iOException2) {
                                return null;
                            }
                        }
                        byArray = byteArrayOutputStream.toByteArray();
                    }
                    break block13;
                }
                if (!(object instanceof byte[])) break block14;
                byArray = (byte[])object;
                break block13;
            }
            if (!(object instanceof Serializable)) break block13;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(OBJECT_BLOB);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public String toString(Object object) {
        return BlobColumn.objToString(object);
    }

    void write(RandomAccessFile randomAccessFile) throws IOException {
    }

    void writeObject(idbDataOutputStream idbDataOutputStream2, Object object, Transaction transaction, int n) throws IOException {
        if (this.cTable.doingRollback && this.lastRowFetched != 0) {
            this.cTable.rndFile.readRow(this.lastRowFetched, this.recOffset);
            long l = this.cTable.dataIn.readLong();
            this.cTable.rndFile.freeReadAhead();
            idbDataOutputStream2.writeLong(l);
            this.lastRowFetched = 0;
            return;
        }
        byte[] byArray = (byte[])object;
        if (this.cTable.encryptor != null) {
            byArray = this.cTable.encryptor.BinaryEncrypt(this.cTable.tableName, this.colName, byArray, n);
        }
        long l = byArray.length;
        this.rndBlob.seek(this.freeOffsetPosn);
        long l2 = this.rndBlob.readLong();
        long l3 = 0L;
        long l4 = 0L;
        while (l2 != 0L) {
            this.rndBlob.seek(l2);
            long l5 = this.rndBlob.readLong();
            l4 = this.rndBlob.readLong();
            if (l5 >= l + HEADER_SIZE) break;
            l3 = l2;
            l2 = l4;
        }
        boolean bl = true;
        if (l2 == 0L) {
            l2 = this.rndBlob.length();
            this.rndBlob.seek(l2);
            this.rndBlob.writeLong(l + HEADER_SIZE);
            this.rndBlob.writeLong(0L);
            bl = false;
        }
        this.rndBlob.seek(l2 + DATA_SIZE_OFFSET);
        this.rndBlob.writeLong(l);
        this.rndBlob.writeLong(0L);
        this.rndBlob.write(byArray);
        try {
            if (this.cTable.tableType != 3 && transaction != null) {
                transaction.journal.writeTransactionRecord(transaction, 1231187042, 0, this.cTable, this, new Long(l2));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        if (bl) {
            if (l3 == 0L) {
                this.rndBlob.seek(this.freeOffsetPosn);
            } else {
                this.rndBlob.seek(l3 + NEXT_OFFSET);
            }
            this.rndBlob.writeLong(l4);
        }
        idbDataOutputStream2.writeLong(l2);
        if (this.fd != null && !this.cTable.fastUpdate) {
            this.fd.sync();
        }
    }
}

