%define name mod_frontpage
%define version 1.6.1
%define release 3mdk

%define sysconfdir /etc
%define apachecontent /var/www/html
%define apachebase %{sysconfdir}/httpd
%define apacheroot /var/www
%define oldapacheroot /home/httpd
%define apachelogs /var/log
%define mm_major 1
%define mm_minor 1.3
%define apache_version 1.3.23
%define apache_release 1mdk

Summary: The improved mod_frontpage module for the Apache Web server.
Name: %{name}
Version: %{version}
Release: %{release}
Epoch: 1
Group: System/Servers
URL: http://home.edo.uni-dortmund.de/~chripo/
#Source0: http://home.edo.uni-dortmund.de/~chripo/download/%{name}-%{version}mdk-1.3.19.tar.bz2
#The patch is now maintained by FreeBSD, but is moving to SourfeForge
Source0:http://people.freebsd.org/~mbr/distfiles/mod_frontpage-1.6.1.tar.bz2
#Source1:mod_frontpage.html
#Patch: mod_frontpage-mdk.patch.bz2
License: Apache License
BuildRoot:  %{_tmppath}/%{name}-root
Prereq:		apache-common >= %{apache_version}-%{apache_release}
Prereq:		apache-conf >= %{apache_version}-%{apache_release}
Prereq: 	mm >= %{mm_major}.%{mm_minor}
Requires:	apache
BuildRequires: apache-devel >= %{apache_version}-%{apache_release} apache >= %{apache_version}-%{apache_release}


%description
This is a module for the Apache HTTP Server <http://www.apache.org/httpd.html>.
It replaces the Apache-FP patches and module supplied with the FrontPage Server
Extensions available from Microsoft <http://www.microsoft.com> and Ready-to-Run
Software <http://www.rtr.com/fpsupport>.

Using this module allows you to use advanced features of the FrontPage client
with your Apache HTTP Server (e.g. creating FrontPage-extended subwebs
using the FrontPage client in contrast to creating them as user "root" with
"fpinstall.sh" or the "fpsrvadm.exe"-utility on the system's shell).

%prep
%setup -n %{name}-%{version}

#%patch -p1

perl Makefile.PL

#Fix in case the build environment is not clean (ie, somebody chowned the
#/var/www/html directory!)
perl -pi -e "s|-DFP_UID_MIN=\d+|-DFP_UID_MIN=48|" Makefile
perl -pi -e "s|-DFP_GID_MIN=\d+|-DFP_GID_MIN=48|" Makefile

%build
make

%install

rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_libdir}/apache-extramodules
mkdir -p $RPM_BUILD_ROOT%{_sbindir}
mkdir -p $RPM_BUILD_ROOT%{apachecontent}/addon-modules

install -m 755 mod_frontpage.so \
	$RPM_BUILD_ROOT%{_libdir}/apache-extramodules
install -m 4711 fpexec $RPM_BUILD_ROOT%{_sbindir}
install -m 755 fpstatic $RPM_BUILD_ROOT%{_sbindir}

mkdir -p $RPM_BUILD_ROOT%{_docdir}/mod_frontpage-%{version}
cp mod_frontpage.html \
        $RPM_BUILD_ROOT%{_docdir}/mod_frontpage-%{version}
 
mkdir -p $RPM_BUILD_ROOT%{apachecontent}/addon-modules
pushd $RPM_BUILD_ROOT%{apachecontent}/addon-modules
ln -s ../../../..%{_docdir}/mod_frontpage-%{version} mod_frontpage
popd

%post
if [ $1 = "1" ]; then 
   #We're in Install mode, add module to the config files
   for config in %{apachebase}/conf/{httpd,httpd-perl}.conf; do
     if [ -x %{_sbindir}/advxaddmod -a -e $config ]; then
       %{_sbindir}/advxaddmod $config \
	extramodules/mod_frontpage.so mod_frontpage.c \
	frontpage_module define=HAVE_FRONTPAGE
     fi
   done
   if [ -x %{_sbindir}/AESctl ]; then %{_sbindir}/AESctl update;fi 
fi

if [ $1 -gt 1 ]; then 
   #We're in *upgrade mode*. Since we can't be sure the configuration files
   #are sane, remove module from the conf files to clean them, re-add again 
   #in a way that the older module we're replacing won't try to erase (the 
   #post scripts were broken on some packages), and finally clean the module
   #specific config file so it's compatible with the upgrade.
   for config in %{apachebase}/conf/{httpd,httpd-perl}.conf; do
     if [ -x %{_sbindir}/advxdelmod -a -e $config ]; then
       %{_sbindir}/advxdelmod $config \
	extramodules/mod_frontpage.so mod_frontpage.c \
	frontpage_module define=HAVE_FRONTPAGE
     fi
     if [ -x %{_sbindir}/advxaddmod -a -e $config ]; then
       %{_sbindir}/advxaddmod $config \
	extramodules/mod_frontpage.so mod_frontpage.c \
	frontpage_module define=HAVE_FRONTPAGE 
     fi
   done
   if [ -x %{_sbindir}/AESctl ]; then %{_sbindir}/AESctl update;fi 
fi

%postun
if [ $1 = "0" ]; then 
   for config in %{apachebase}/conf/{httpd,httpd-perl}.conf; do
     if [ -x %{_sbindir}/advxdelmod -a -e $config ]; then
       %{_sbindir}/advxdelmod $config \
	extramodules/mod_frontpage.so mod_frontpage.c \
	frontpage_module define=HAVE_FRONTPAGE
     fi
   done
   if [ -x %{_sbindir}/AESctl ]; then %{_sbindir}/AESctl update;fi 
fi



%files
%defattr(-,root,root)
%{_libdir}/apache-extramodules/mod_frontpage.so
%attr(4551,root,root) %{_sbindir}/fpexec
%attr(0555,root,root) %{_sbindir}/fpstatic
%{apachecontent}/addon-modules/* 
%dir %{_docdir}/mod_frontpage-%{version}
%doc %{_docdir}/mod_frontpage-%{version}/*

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Mon Mar 04 2002 Jean-Michel Dault <jmdault@mandrakesoft.com> 1.6.1-3mdk
- BUGFIX RELEASE (AKA Brown Paper Bag On The Head Hiding In The Closet)
- Fix chmod for fpexec (should be 4551)
- Fix UID and GID bug
- Modify documentation page since Frontpage 2002 has a completely different
  admin tool syntax.
- Buy Frontpage 2002, find a windows machine, install the software, and test
  publishing. I created a Root Web, a Per User Web, Virtual Hosts.
- EVERYTHING WORKS NOW ;-)
- Mess up completely the httpd.conf a few times so I can find out what
  potential problems can arise and write a Troubleshooting section.
- Added a link to the FAQ at www.rtr.com

* Tue Feb 05 2002 Jean-Michel Dault <jmdault@mandrakesoft.com> 1.6.1-2mdk
- Added extra security checks so only user "apache" can execute the suid
  binary.

* Tue Feb 05 2002 Jean-Michel Dault <jmdault@mandrakesoft.com> 1.6.1-1mdk
- SECURITY UPDATE
- Merge with FreeBSD port, since it's no longer maintained by author
- apache 1.3.23

* Thu Nov 22 2001 Christian Belisle <cbelisle@mandrakesoft.com> 1.5.1-6mdk
- fix invalid-packager and no-url warning (rpmlint).
- Added apache in BuildRequires

* Tue Oct 16 2001 Christian Belisle <cbelisle@mandrakesoft.com> 1.5.1-5mdk
- apache 1.3.22.
- remove mdk after version.

* Thu Jul 12 2001 Philippe Libat <philippe@mandrakesoft.com> 1.5.1mdk-4mdk
- new apache

* Sat Apr 14 2001 Jean-Michel Dault <jmdault@mandrakesoft.com> 1.5.1mdk-3mdk
- fix Makefile.PL so it picks commonhttpd.conf too!

* Mon Apr  9 2001 Jean-Michel Dault <jmdault@mandrakesoft.com> 1.5.1mdk-2mdk
- fix post scripts for good 

* Sun Mar 25 2001 Jean-Michel Dault <jmdault@mandrakesoft.com> 1.5.1mdk-1mdk
- Replaced the old Microsoft frontpage extensions by the new Improved
  mod_frontpage module, more secure and totally buildable with apxs.
