/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharFormatter;

class CppCharFormatter
implements CharFormatter {
    CppCharFormatter() {
    }

    public String escapeChar(int c, boolean forCharLiteral) {
        switch (c) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return forCharLiteral ? "\\'" : "'";
            }
            case 34: {
                return forCharLiteral ? "\"" : "\\\"";
            }
        }
        if (c < 32 || c > 126) {
            if (c > 255) {
                return "\\u" + Integer.toString(c, 16);
            }
            return "\\" + Integer.toString(c, 8);
        }
        return String.valueOf((char)c);
    }

    public String escapeString(String s) {
        String retval = new String();
        for (int i = 0; i < s.length(); ++i) {
            retval = retval + this.escapeChar(s.charAt(i), false);
        }
        return retval;
    }

    public String literalChar(int c) {
        return "static_cast<unsigned char>('" + this.escapeChar(c, true) + "')";
    }

    public String literalString(String s) {
        return "\"" + this.escapeString(s) + "\"";
    }
}

