/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.custom.runtime;

import com.sun.encoder.runtime.CoderException;
import com.sun.encoder.runtime.StringCoder;

public class NestedStringCoder
implements StringCoder {
    private StringCoder mCoder = null;

    public NestedStringCoder(StringCoder coder) {
        this.mCoder = coder;
    }

    public StringCoder getCoder() {
        return this.mCoder;
    }

    public void setCoder(StringCoder coder) {
        this.mCoder = coder;
    }

    private void haveCoder() {
        if (this.mCoder == null) {
            throw new RuntimeException("no current coder");
        }
    }

    public byte[] encode(String s) throws CoderException {
        this.haveCoder();
        return this.mCoder.encode(s);
    }

    public byte[] encode(String s, int min, int max) throws CoderException {
        this.haveCoder();
        return this.mCoder.encode(s, min, max);
    }

    public String decode(byte[] b) throws CoderException {
        this.haveCoder();
        return this.mCoder.decode(b);
    }

    public String decode(byte[] b, int from, int length) throws CoderException {
        this.haveCoder();
        return this.mCoder.decode(b, from, length);
    }

    public void setProperty(String name, Object value) {
        this.haveCoder();
        this.mCoder.setProperty(name, value);
    }

    public Object getProperty(String name) {
        this.haveCoder();
        return this.mCoder.getProperty(name);
    }
}

