/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.custom.runtime.provider;

import com.sun.encoder.runtime.provider.Misc;

public class Delim
implements com.sun.encoder.custom.runtime.Delim {
    public final byte mType;
    public final byte mTerm;
    public final byte mLieu;
    public final short mSlot;
    public final byte[] mData;
    public final byte mPrec;
    public final boolean mSkipLeading;
    public final boolean mCollapse;

    private Delim(byte type, byte prec, byte term, byte lieu, short slot, byte[] data, boolean skipLeading, boolean collap) {
        if (type < 0 || 2 < type) {
            throw new IllegalArgumentException("unknown delimiter type " + type);
        }
        if (slot < 0) {
            if (data == null) {
                throw new NullPointerException("no delim data");
            }
            if (data.length == 0) {
                throw new IllegalArgumentException("delim must be > 0 bytes");
            }
        }
        if (prec < 0) {
            throw new IllegalArgumentException("negative precedence");
        }
        this.mType = type;
        this.mTerm = term;
        this.mLieu = lieu;
        this.mSlot = slot;
        this.mData = data;
        this.mPrec = prec;
        this.mSkipLeading = skipLeading;
        this.mCollapse = collap;
    }

    public Delim(byte type, byte prec, byte term, byte lieu, byte[] data, boolean skipLeading, boolean collap) {
        this(type, prec, term, lieu, -1, data, skipLeading, collap);
    }

    public Delim(byte type, byte prec, byte term, byte lieu, short slot, boolean skipLeading, boolean collap) {
        this(type, prec, term, lieu, slot, null, skipLeading, collap);
    }

    public Delim(byte prec, byte[] data) {
        this(0, prec, 0, 0, data, false, false);
    }

    public Delim(byte prec, String data) {
        this(prec, Misc.str2bytes((String)data));
    }

    public static String typeName(byte type) {
        switch (type) {
            case 2: {
                return "ESCAPE";
            }
            case 0: {
                return "NORMAL";
            }
            case 1: {
                return "REPEAT";
            }
        }
        throw new RuntimeException("unknown type " + type);
    }

    public static String termName(byte term) {
        switch (term) {
            case 0: {
                return "AVOID";
            }
            case 1: {
                return "ALLOW";
            }
            case 2: {
                return "FAVOR";
            }
            case 3: {
                return "FORCE";
            }
        }
        throw new RuntimeException("unknown final " + term);
    }

    public String typeName() {
        return Delim.typeName(this.mType);
    }

    public String termName() {
        return Delim.termName(this.mTerm);
    }

    public String lieuName() {
        return Delim.termName(this.mLieu);
    }

    public boolean embedded() {
        return this.mSlot >= 0;
    }

    public boolean skipLeading() {
        return this.mSkipLeading;
    }

    public boolean collapse() {
        return this.mCollapse;
    }

    public static class Slot {
        public final long mOffset;
        public final int mLength;

        public Slot(long offset, int length) {
            if (offset < 0L) {
                throw new IllegalArgumentException("negative offset: " + offset);
            }
            if (length <= 0) {
                throw new IllegalArgumentException("non-positive length: " + length);
            }
            this.mOffset = offset;
            this.mLength = length;
        }
    }
}

