/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.PrintWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pretty
extends Tree.Visitor {
    private final boolean sourceOutput;
    PrintWriter out;
    public int width = 4;
    int lmargin = 0;
    Name enclClassName;
    Map<Tree, String> docComments = null;
    int prec;

    public Pretty(PrintWriter printWriter, boolean bl) {
        this.out = printWriter;
        this.sourceOutput = bl;
    }

    void align() {
        for (int i = 0; i < this.lmargin; ++i) {
            this.out.print(" ");
        }
    }

    void indent() {
        this.lmargin += this.width;
    }

    void undent() {
        this.lmargin -= this.width;
    }

    void open(int n, int n2) {
        if (n2 < n) {
            this.out.print("(");
        }
    }

    void close(int n, int n2) {
        if (n2 < n) {
            this.out.print(")");
        }
    }

    public void print(Object object) {
        this.out.print(Convert.escapeUnicode(object.toString()));
    }

    public void println() {
        this.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printExpr(Tree tree, int n) {
        int n2 = this.prec;
        try {
            this.prec = n;
            if (tree == null) {
                this.print("/*missing*/");
            } else {
                tree.accept(this);
            }
        }
        finally {
            this.prec = n2;
        }
    }

    public void printExpr(Tree tree) {
        this.printExpr(tree, 0);
    }

    public void printStat(Tree tree) {
        this.printExpr(tree, -1);
    }

    public <T extends Tree> void printExprs(List<T> list, String string) {
        if (list.nonEmpty()) {
            this.printExpr((Tree)list.head);
            List list2 = list.tail;
            while (list2.nonEmpty()) {
                this.print(string);
                this.printExpr((Tree)list2.head);
                list2 = list2.tail;
            }
        }
    }

    public <T extends Tree> void printExprs(List<T> list) {
        this.printExprs(list, ", ");
    }

    public <T extends Tree> void printStats(List<T> list) {
        List<Object> list2 = list;
        while (list2.nonEmpty()) {
            this.align();
            this.printStat((Tree)list2.head);
            this.println();
            list2 = list2.tail;
        }
    }

    public void printFlags(long l) {
        if ((l & 0x1000L) != 0L) {
            this.print("/*synthetic*/ ");
        }
        this.print(TreeInfo.flagNames(l));
        if ((l & 0xFFFL) != 0L) {
            this.print(" ");
        }
        if ((l & 0x2000L) != 0L) {
            this.print("@");
        }
    }

    public void printAnnotations(List<Tree.Annotation> list) {
        List<Tree.Annotation> list2 = list;
        while (list2.nonEmpty()) {
            this.printStat((Tree)list2.head);
            this.println();
            this.align();
            list2 = list2.tail;
        }
    }

    public void printDocComment(Tree tree) {
        String string;
        if (this.docComments != null && (string = this.docComments.get(tree)) != null) {
            this.print("/**");
            this.println();
            int n = 0;
            int n2 = Pretty.lineEndPos(string, n);
            while (n < string.length()) {
                this.align();
                this.print(" *");
                if (n < string.length() && string.charAt(n) > ' ') {
                    this.print(" ");
                }
                this.print(string.substring(n, n2));
                this.println();
                n = n2 + 1;
                n2 = Pretty.lineEndPos(string, n);
            }
            this.align();
            this.print(" */");
            this.println();
            this.align();
        }
    }

    static int lineEndPos(String string, int n) {
        int n2 = string.indexOf(10, n);
        if (n2 < 0) {
            n2 = string.length();
        }
        return n2;
    }

    public void printTypeParameters(List<Tree.TypeParameter> list) {
        if (list.nonEmpty()) {
            this.print("<");
            this.printExprs(list);
            this.print(">");
        }
    }

    public void printBlock(List<Tree> list) {
        this.print("{");
        this.println();
        this.indent();
        this.printStats(list);
        this.undent();
        this.align();
        this.print("}");
    }

    public void printEnumBody(List<Tree> list) {
        this.print("{");
        this.println();
        this.indent();
        boolean bl = true;
        List<Tree> list2 = list;
        while (list2.nonEmpty()) {
            if (this.isEnumerator((Tree)list2.head)) {
                if (!bl) {
                    this.print(",");
                    this.println();
                }
                this.align();
                this.printStat((Tree)list2.head);
                bl = false;
            }
            list2 = list2.tail;
        }
        this.print(";");
        this.println();
        list2 = list;
        while (list2.nonEmpty()) {
            if (!this.isEnumerator((Tree)list2.head)) {
                this.align();
                this.printStat((Tree)list2.head);
                this.println();
            }
            list2 = list2.tail;
        }
        this.undent();
        this.align();
        this.print("}");
    }

    boolean isEnumerator(Tree tree) {
        return tree.tag == 5 && (((Tree.VarDef)tree).mods.flags & 0x4000L) != 0L;
    }

    public void printUnit(Tree.TopLevel topLevel, Tree.ClassDef classDef) {
        this.docComments = topLevel.docComments;
        this.printDocComment(topLevel);
        if (topLevel.pid != null) {
            this.print("package ");
            this.printExpr(topLevel.pid);
            this.print(";");
            this.println();
        }
        boolean bl = true;
        List<Tree> list = topLevel.defs;
        while (list.nonEmpty() && (classDef == null || ((Tree)list.head).tag == 2)) {
            if (((Tree)list.head).tag == 2) {
                Tree.Import import_ = (Tree.Import)list.head;
                Name name = TreeInfo.name(import_.qualid);
                if (name == name.table.asterisk || classDef == null || this.isUsed(TreeInfo.symbol(import_.qualid), classDef)) {
                    if (bl) {
                        bl = false;
                        this.println();
                    }
                    this.printStat(import_);
                }
            } else {
                this.printStat((Tree)list.head);
            }
            list = list.tail;
        }
        if (classDef != null) {
            this.printStat(classDef);
            this.println();
        }
    }

    boolean isUsed(final Symbol symbol, Tree tree) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UsedVisitor
        extends TreeScanner {
            boolean result = false;

            UsedVisitor() {
            }

            @Override
            public void scan(Tree tree) {
                if (tree != null && !this.result) {
                    tree.accept(this);
                }
            }

            @Override
            public void visitIdent(Tree.Ident ident) {
                if (ident.sym == symbol) {
                    this.result = true;
                }
            }
        }
        UsedVisitor usedVisitor = new UsedVisitor();
        usedVisitor.scan(tree);
        return usedVisitor.result;
    }

    @Override
    public void visitTopLevel(Tree.TopLevel topLevel) {
        this.printUnit(topLevel, null);
    }

    @Override
    public void visitImport(Tree.Import import_) {
        this.print("import ");
        if (import_.staticImport) {
            this.print("static ");
        }
        this.printExpr(import_.qualid);
        this.print(";");
        this.println();
    }

    @Override
    public void visitClassDef(Tree.ClassDef classDef) {
        this.println();
        this.align();
        this.printDocComment(classDef);
        this.printAnnotations(classDef.mods.annotations);
        this.printFlags(classDef.mods.flags & 0xFFFFFFFFFFFFFDFFL);
        Name name = this.enclClassName;
        this.enclClassName = classDef.name;
        if ((classDef.mods.flags & 0x200L) != 0L) {
            this.print("interface " + classDef.name);
            this.printTypeParameters(classDef.typarams);
            if (classDef.implementing.nonEmpty()) {
                this.print(" extends ");
                this.printExprs(classDef.implementing);
            }
        } else {
            if ((classDef.mods.flags & 0x4000L) != 0L) {
                this.print("enum " + classDef.name);
            } else {
                this.print("class " + classDef.name);
            }
            this.printTypeParameters(classDef.typarams);
            if (classDef.extending != null) {
                this.print(" extends ");
                this.printExpr(classDef.extending);
            }
            if (classDef.implementing.nonEmpty()) {
                this.print(" implements ");
                this.printExprs(classDef.implementing);
            }
        }
        this.print(" ");
        if ((classDef.mods.flags & 0x4000L) != 0L) {
            this.printEnumBody(classDef.defs);
        } else {
            this.printBlock(classDef.defs);
        }
        this.enclClassName = name;
    }

    @Override
    public void visitMethodDef(Tree.MethodDef methodDef) {
        if (methodDef.name == methodDef.name.table.init && this.enclClassName == null && this.sourceOutput) {
            return;
        }
        this.println();
        this.align();
        this.printDocComment(methodDef);
        this.printExpr(methodDef.mods);
        this.printTypeParameters(methodDef.typarams);
        if (methodDef.name == methodDef.name.table.init) {
            this.print(this.enclClassName != null ? this.enclClassName : methodDef.name);
        } else {
            this.printExpr(methodDef.restype);
            this.print(" " + methodDef.name);
        }
        this.print("(");
        this.printExprs(methodDef.params);
        this.print(")");
        if (methodDef.thrown.nonEmpty()) {
            this.print(" throws ");
            this.printExprs(methodDef.thrown);
        }
        if (methodDef.body != null) {
            this.print(" ");
            this.printStat(methodDef.body);
        } else {
            this.print(";");
        }
    }

    @Override
    public void visitVarDef(Tree.VarDef varDef) {
        if (this.docComments != null && this.docComments.get(varDef) != null) {
            this.println();
            this.align();
        }
        this.printDocComment(varDef);
        if ((varDef.mods.flags & 0x4000L) != 0L) {
            this.print("/*public static final*/ ");
            this.print(varDef.name);
            if (varDef.init != null) {
                this.print(" /* = ");
                this.printExpr(varDef.init);
                this.print(" */");
            }
        } else {
            this.printExpr(varDef.mods);
            if ((varDef.mods.flags & 0x400000000L) != 0L) {
                this.printExpr(((Tree.TypeArray)varDef.vartype).elemtype);
                this.print("... " + varDef.name);
            } else {
                this.printExpr(varDef.vartype);
                this.print(" " + varDef.name);
            }
            if (varDef.init != null) {
                this.print(" = ");
                this.printExpr(varDef.init);
            }
            if (this.prec == -1) {
                this.print(";");
            }
        }
    }

    @Override
    public void visitSkip(Tree.Skip skip) {
        this.print(";");
    }

    @Override
    public void visitBlock(Tree.Block block) {
        this.printFlags(block.flags);
        this.printBlock(block.stats);
    }

    @Override
    public void visitDoLoop(Tree.DoLoop doLoop) {
        this.print("do ");
        this.printStat(doLoop.body);
        this.align();
        this.print(" while ");
        if (doLoop.cond.tag == 29) {
            this.printExpr(doLoop.cond);
        } else {
            this.print("(");
            this.printExpr(doLoop.cond);
            this.print(")");
        }
        this.print(";");
    }

    @Override
    public void visitWhileLoop(Tree.WhileLoop whileLoop) {
        this.print("while ");
        if (whileLoop.cond.tag == 29) {
            this.printExpr(whileLoop.cond);
        } else {
            this.print("(");
            this.printExpr(whileLoop.cond);
            this.print(")");
        }
        this.print(" ");
        this.printStat(whileLoop.body);
    }

    @Override
    public void visitForLoop(Tree.ForLoop forLoop) {
        this.print("for (");
        if (forLoop.init.nonEmpty()) {
            if (((Tree)forLoop.init.head).tag == 5) {
                this.printExpr((Tree)forLoop.init.head);
                List list = forLoop.init.tail;
                while (list.nonEmpty()) {
                    Tree.VarDef varDef = (Tree.VarDef)list.head;
                    this.print(", " + varDef.name + " = ");
                    this.printExpr(varDef.init);
                    list = list.tail;
                }
            } else {
                this.printExprs(forLoop.init);
            }
        }
        this.print("; ");
        if (forLoop.cond != null) {
            this.printExpr(forLoop.cond);
        }
        this.print("; ");
        this.printExprs(forLoop.step);
        this.print(") ");
        this.printStat(forLoop.body);
    }

    @Override
    public void visitForeachLoop(Tree.ForeachLoop foreachLoop) {
        this.print("for (");
        this.printExpr(foreachLoop.var);
        this.print(" : ");
        this.printExpr(foreachLoop.expr);
        this.print(") ");
        this.printStat(foreachLoop.body);
    }

    @Override
    public void visitLabelled(Tree.Labelled labelled) {
        this.print(labelled.label + ": ");
        this.printStat(labelled.body);
    }

    @Override
    public void visitSwitch(Tree.Switch switch_) {
        this.print("switch ");
        if (switch_.selector.tag == 29) {
            this.printExpr(switch_.selector);
        } else {
            this.print("(");
            this.printExpr(switch_.selector);
            this.print(")");
        }
        this.print(" {");
        this.println();
        this.printStats(switch_.cases);
        this.align();
        this.print("}");
    }

    @Override
    public void visitCase(Tree.Case case_) {
        if (case_.pat == null) {
            this.print("default");
        } else {
            this.print("case ");
            this.printExpr(case_.pat);
        }
        this.print(": ");
        this.println();
        this.indent();
        this.printStats(case_.stats);
        this.undent();
        this.align();
    }

    @Override
    public void visitSynchronized(Tree.Synchronized synchronized_) {
        this.print("synchronized ");
        if (synchronized_.lock.tag == 29) {
            this.printExpr(synchronized_.lock);
        } else {
            this.print("(");
            this.printExpr(synchronized_.lock);
            this.print(")");
        }
        this.print(" ");
        this.printStat(synchronized_.body);
    }

    @Override
    public void visitTry(Tree.Try try_) {
        this.print("try ");
        this.printStat(try_.body);
        List<Tree.Catch> list = try_.catchers;
        while (list.nonEmpty()) {
            this.printStat((Tree)list.head);
            list = list.tail;
        }
        if (try_.finalizer != null) {
            this.print(" finally ");
            this.printStat(try_.finalizer);
        }
    }

    @Override
    public void visitCatch(Tree.Catch catch_) {
        this.print(" catch (");
        this.printExpr(catch_.param);
        this.print(") ");
        this.printStat(catch_.body);
    }

    @Override
    public void visitConditional(Tree.Conditional conditional) {
        this.open(this.prec, 3);
        this.printExpr(conditional.cond, 3);
        this.print(" ? ");
        this.printExpr(conditional.truepart, 3);
        this.print(" : ");
        this.printExpr(conditional.falsepart, 3);
        this.close(this.prec, 3);
    }

    @Override
    public void visitIf(Tree.If if_) {
        this.print("if ");
        if (if_.cond.tag == 29) {
            this.printExpr(if_.cond);
        } else {
            this.print("(");
            this.printExpr(if_.cond);
            this.print(")");
        }
        this.print(" ");
        this.printStat(if_.thenpart);
        if (if_.elsepart != null) {
            this.print(" else ");
            this.printStat(if_.elsepart);
        }
    }

    @Override
    public void visitExec(Tree.Exec exec) {
        this.printExpr(exec.expr);
        if (this.prec == -1) {
            this.print(";");
        }
    }

    @Override
    public void visitBreak(Tree.Break break_) {
        this.print("break");
        if (break_.label != null) {
            this.print(" " + break_.label);
        }
        this.print(";");
    }

    @Override
    public void visitContinue(Tree.Continue continue_) {
        this.print("continue");
        if (continue_.label != null) {
            this.print(" " + continue_.label);
        }
        this.print(";");
    }

    @Override
    public void visitReturn(Tree.Return return_) {
        this.print("return");
        if (return_.expr != null) {
            this.print(" ");
            this.printExpr(return_.expr);
        }
        this.print(";");
    }

    @Override
    public void visitThrow(Tree.Throw throw_) {
        this.print("throw ");
        this.printExpr(throw_.expr);
        this.print(";");
    }

    @Override
    public void visitAssert(Tree.Assert assert_) {
        this.print("assert ");
        this.printExpr(assert_.cond);
        if (assert_.detail != null) {
            this.print(" : ");
            this.printExpr(assert_.detail);
        }
        this.print(";");
    }

    @Override
    public void visitApply(Tree.Apply apply) {
        if (apply.typeargs != null) {
            if (apply.meth.tag == 34) {
                Tree.Select select = (Tree.Select)apply.meth;
                this.printExpr(select.selected);
                this.print(".<");
                this.printExprs(apply.typeargs);
                this.print(">" + select.name);
            } else {
                this.print("<");
                this.printExprs(apply.typeargs);
                this.print(">");
                this.printExpr(apply.meth);
            }
        } else {
            this.printExpr(apply.meth);
        }
        this.print("(");
        this.printExprs(apply.args);
        this.print(")");
    }

    @Override
    public void visitNewClass(Tree.NewClass newClass) {
        if (newClass.encl != null) {
            this.printExpr(newClass.encl);
            this.print(".");
        }
        this.print("new ");
        if (newClass.typeargs != null) {
            this.print("<");
            this.printExprs(newClass.typeargs);
            this.print(">");
        }
        this.printExpr(newClass.clazz);
        this.print("(");
        this.printExprs(newClass.args);
        this.print(")");
        if (newClass.def != null) {
            Name name = this.enclClassName;
            Name name2 = newClass.def.name != null ? newClass.def.name : (this.enclClassName = newClass.type != null && newClass.type.tsym.name != newClass.type.tsym.name.table.empty ? newClass.type.tsym.name : null);
            if ((newClass.def.mods.flags & 0x4000L) != 0L) {
                this.print("/*enum*/");
            }
            this.printBlock(newClass.def.defs);
            this.enclClassName = name;
        }
    }

    @Override
    public void visitNewArray(Tree.NewArray newArray) {
        if (newArray.elemtype != null) {
            this.print("new ");
            Tree tree = newArray.elemtype;
            if (tree instanceof Tree.TypeArray) {
                this.printBaseElementType((Tree.TypeArray)tree);
            } else {
                this.printExpr(tree);
            }
            List<Tree> list = newArray.dims;
            while (list.nonEmpty()) {
                this.print("[");
                this.printExpr((Tree)list.head);
                this.print("]");
                list = list.tail;
            }
            if (tree instanceof Tree.TypeArray) {
                this.printBrackets((Tree.TypeArray)tree);
            }
        }
        if (newArray.elems != null) {
            if (newArray.elemtype != null) {
                this.print("[]");
            }
            this.print("{");
            this.printExprs(newArray.elems);
            this.print("}");
        }
    }

    @Override
    public void visitParens(Tree.Parens parens) {
        this.print("(");
        this.printExpr(parens.expr);
        this.print(")");
    }

    @Override
    public void visitAssign(Tree.Assign assign) {
        this.open(this.prec, 1);
        this.printExpr(assign.lhs, 2);
        this.print(" = ");
        this.printExpr(assign.rhs, 1);
        this.close(this.prec, 1);
    }

    public String operatorName(int n) {
        switch (n) {
            case 46: {
                return "+";
            }
            case 47: {
                return "-";
            }
            case 48: {
                return "!";
            }
            case 49: {
                return "~";
            }
            case 50: {
                return "++";
            }
            case 51: {
                return "--";
            }
            case 52: {
                return "++";
            }
            case 53: {
                return "--";
            }
            case 54: {
                return "<*nullchk*>";
            }
            case 55: {
                return "||";
            }
            case 56: {
                return "&&";
            }
            case 60: {
                return "==";
            }
            case 61: {
                return "!=";
            }
            case 62: {
                return "<";
            }
            case 63: {
                return ">";
            }
            case 64: {
                return "<=";
            }
            case 65: {
                return ">=";
            }
            case 57: {
                return "|";
            }
            case 58: {
                return "^";
            }
            case 59: {
                return "&";
            }
            case 66: {
                return "<<";
            }
            case 67: {
                return ">>";
            }
            case 68: {
                return ">>>";
            }
            case 69: {
                return "+";
            }
            case 70: {
                return "-";
            }
            case 71: {
                return "*";
            }
            case 72: {
                return "/";
            }
            case 73: {
                return "%";
            }
        }
        throw new Error();
    }

    @Override
    public void visitAssignop(Tree.Assignop assignop) {
        this.open(this.prec, 2);
        this.printExpr(assignop.lhs, 3);
        this.print(" " + this.operatorName(assignop.tag - 17) + "= ");
        this.printExpr(assignop.rhs, 2);
        this.close(this.prec, 2);
    }

    @Override
    public void visitUnary(Tree.Unary unary) {
        int n = TreeInfo.opPrec(unary.tag);
        String string = this.operatorName(unary.tag).toString();
        this.open(this.prec, n);
        if (unary.tag <= 51) {
            this.print(string);
            this.printExpr(unary.arg, n);
        } else {
            this.printExpr(unary.arg, n);
            this.print(string);
        }
        this.close(this.prec, n);
    }

    @Override
    public void visitBinary(Tree.Binary binary) {
        int n = TreeInfo.opPrec(binary.tag);
        String string = this.operatorName(binary.tag).toString();
        this.open(this.prec, n);
        this.printExpr(binary.lhs, n);
        this.print(" " + string + " ");
        this.printExpr(binary.rhs, n + 1);
        this.close(this.prec, n);
    }

    @Override
    public void visitTypeCast(Tree.TypeCast typeCast) {
        this.open(this.prec, 14);
        this.print("(");
        this.printExpr(typeCast.clazz);
        this.print(")");
        this.printExpr(typeCast.expr, 14);
        this.close(this.prec, 14);
    }

    @Override
    public void visitTypeTest(Tree.TypeTest typeTest) {
        this.open(this.prec, 10);
        this.printExpr(typeTest.expr, 10);
        this.print(" instanceof ");
        this.printExpr(typeTest.clazz, 11);
        this.close(this.prec, 10);
    }

    @Override
    public void visitIndexed(Tree.Indexed indexed) {
        this.printExpr(indexed.indexed, 15);
        this.print("[");
        this.printExpr(indexed.index);
        this.print("]");
    }

    @Override
    public void visitSelect(Tree.Select select) {
        this.printExpr(select.selected, 15);
        this.print("." + select.name);
    }

    @Override
    public void visitIdent(Tree.Ident ident) {
        this.print(ident.name);
    }

    @Override
    public void visitLiteral(Tree.Literal literal) {
        switch (literal.typetag) {
            case 4: {
                this.print(literal.value.toString());
                break;
            }
            case 5: {
                this.print(literal.value + "L");
                break;
            }
            case 6: {
                this.print(literal.value + "F");
                break;
            }
            case 7: {
                this.print(literal.value.toString());
                break;
            }
            case 2: {
                this.print("'" + Convert.quote(String.valueOf((char)((Number)literal.value).intValue())) + "'");
                break;
            }
            default: {
                this.print("\"" + Convert.quote(literal.value.toString()) + "\"");
            }
        }
    }

    @Override
    public void visitTypeIdent(Tree.TypeIdent typeIdent) {
        switch (typeIdent.typetag) {
            case 1: {
                this.print("byte");
                break;
            }
            case 2: {
                this.print("char");
                break;
            }
            case 3: {
                this.print("short");
                break;
            }
            case 4: {
                this.print("int");
                break;
            }
            case 5: {
                this.print("long");
                break;
            }
            case 6: {
                this.print("float");
                break;
            }
            case 7: {
                this.print("double");
                break;
            }
            case 8: {
                this.print("boolean");
                break;
            }
            case 9: {
                this.print("void");
                break;
            }
            default: {
                this.print("error");
            }
        }
    }

    @Override
    public void visitTypeArray(Tree.TypeArray typeArray) {
        this.printBaseElementType(typeArray);
        this.printBrackets(typeArray);
    }

    private void printBaseElementType(Tree.TypeArray typeArray) {
        Tree tree = typeArray.elemtype;
        while (tree instanceof Tree.TypeArgument) {
            tree = ((Tree.TypeArgument)tree).inner;
        }
        if (tree instanceof Tree.TypeArray) {
            this.printBaseElementType((Tree.TypeArray)tree);
        } else {
            this.printExpr(tree);
        }
    }

    private void printBrackets(Tree.TypeArray typeArray) {
        while (true) {
            Tree tree = typeArray.elemtype;
            this.print("[]");
            if (!(tree instanceof Tree.TypeArray)) break;
            typeArray = (Tree.TypeArray)tree;
        }
    }

    @Override
    public void visitTypeApply(Tree.TypeApply typeApply) {
        this.printExpr(typeApply.clazz);
        this.print("<");
        this.printExprs(typeApply.arguments);
        this.print(">");
    }

    @Override
    public void visitTypeParameter(Tree.TypeParameter typeParameter) {
        this.print(typeParameter.name);
        if (typeParameter.bounds.nonEmpty()) {
            this.print(" extends ");
            this.printExprs(typeParameter.bounds, " & ");
        }
    }

    @Override
    public void visitTypeArgument(Tree.TypeArgument typeArgument) {
        this.print("" + (Object)((Object)typeArgument.kind));
        if (typeArgument.kind != BoundKind.UNBOUND) {
            this.printExpr(typeArgument.inner);
        }
    }

    @Override
    public void visitErroneous(Tree.Erroneous erroneous) {
        this.print("(ERROR)");
    }

    @Override
    public void visitLetExpr(Tree.LetExpr letExpr) {
        this.print("(let " + letExpr.defs + " in " + letExpr.expr + ")");
    }

    @Override
    public void visitModifiers(Tree.Modifiers modifiers) {
        this.printAnnotations(modifiers.annotations);
        this.printFlags(modifiers.flags);
    }

    @Override
    public void visitAnnotation(Tree.Annotation annotation) {
        this.print("@");
        this.printExpr(annotation.annotationType);
        this.print("(");
        this.printExprs(annotation.args);
        this.print(")");
    }

    @Override
    public void visitTree(Tree tree) {
        this.print("(UNKNOWN: " + tree + ")");
        this.println();
    }
}

