/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.axiondb.tools.BaseReport;
import org.axiondb.tools.BatchSqlCommandRunner;

public class Console {
    private Connection _conn = null;
    private Statement _stmt = null;
    private PrintWriter _writer = null;
    private BaseReport _report = null;
    private String _dbName = null;
    private String _dbLoc = null;
    private static final String _PROMPT = "axion> ";

    public Console(String dbName, PrintWriter writer) throws SQLException {
        this(dbName, null, writer);
    }

    public Console(String dbName, String dbLoc, PrintWriter writer) throws SQLException {
        if (writer == null) {
            throw new NullPointerException("Must provide PrintWriter for output");
        }
        this._writer = writer;
        this._dbLoc = dbLoc;
        this._dbName = dbName;
        this.connect();
        this._report = new BaseReport(this._writer);
    }

    private void connect() throws SQLException {
        if (this._dbName == null) {
            throw new NullPointerException("Must provide database name");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("jdbc:axiondb:");
        buf.append(this._dbName);
        if (this._dbLoc != null) {
            buf.append(":");
            buf.append(this._dbLoc);
        }
        try {
            this._conn = DriverManager.getConnection(buf.toString());
            this._stmt = this._conn.createStatement();
        }
        catch (SQLException e) {
            this.cleanUp();
            throw e;
        }
    }

    public Connection getConnection() {
        return this._conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String input) throws SQLException {
        if (input != null && (input = input.trim()).length() != 0) {
            while (input.endsWith(";")) {
                input = input.substring(0, input.length() - 1).trim();
            }
            StringTokenizer tokens = new StringTokenizer(input);
            String token = null;
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken().toUpperCase();
            }
            if (token.equals("DESCRIBE") || token.equals("DESC")) {
                this.consumeToken(tokens, "TABLE");
                this.describeTable(this.getToken(tokens, true));
            } else if (token.equals("LIST")) {
                this.listTables(this.getToken(tokens, false));
            } else if (token.equals("SHOW")) {
                if (!tokens.hasMoreTokens()) {
                    throw new IllegalArgumentException("Parser Error: Expected TABLES, DBLINKS, INDICES, INDEXES found EOF");
                }
                token = tokens.nextToken().toUpperCase();
                if (token.equals("TABLE")) {
                    this.consumeToken(tokens, "PROPERTIES");
                    this.showTableProperties(this.getToken(tokens, false));
                } else if (token.equals("DBLINKS")) {
                    this.showLinks(this.getToken(tokens, false));
                } else if (token.equals("INDICES") || token.equals("INDEXES")) {
                    this.showIndices(this.getToken(tokens, false));
                }
            } else if (token.equals("SET")) {
                this.consumeToken(tokens, "AUTOCOMMIT");
                if (!tokens.hasMoreTokens()) {
                    throw new IllegalArgumentException("Parser Error: Expected AUTOCIMMIT [ON|OFF]");
                }
                token = tokens.nextToken().toUpperCase();
                if (token.equals("ON")) {
                    this._conn.setAutoCommit(true);
                } else if (token.equals("OFF")) {
                    this._conn.setAutoCommit(false);
                }
            } else if (token.equals("COMMIT")) {
                if (!this._conn.getAutoCommit()) {
                    this._conn.commit();
                }
            } else if (token.equals("ROLLBACK")) {
                if (!this._conn.getAutoCommit()) {
                    this._conn.rollback();
                }
            } else if (token.equals("RESET")) {
                if (!this._conn.isClosed()) {
                    this.cleanUp();
                    this.connect();
                }
            } else if (input.startsWith("@")) {
                String filename = input.substring(1);
                File batch = null;
                BufferedReader reader = null;
                try {
                    batch = new File(filename);
                    reader = new BufferedReader(new FileReader(batch));
                    BatchSqlCommandRunner runner = new BatchSqlCommandRunner(this.getConnection(), this._writer);
                    runner.runCommands(reader);
                    this._writer.println("Successfully loaded file " + batch);
                }
                catch (IOException e) {
                    this._writer.println("Error reading file " + filename);
                    this._report.reportException(e);
                }
                catch (SQLException e) {
                    this._report.reportException(e);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                    reader = null;
                    batch = null;
                }
            } else {
                this.executeSql(input);
            }
        }
    }

    private String getToken(StringTokenizer tokens, boolean throwErr) throws SQLException {
        if (tokens.hasMoreTokens()) {
            return tokens.nextToken();
        }
        if (throwErr) {
            throw new SQLException("Parser Error: found EOF");
        }
        return "";
    }

    private void consumeToken(StringTokenizer tokens, String keyword) throws SQLException {
        if (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().toUpperCase();
            if (!token.equals(keyword)) {
                throw new SQLException("Parser Error: Unrecognized Token");
            }
        } else {
            throw new SQLException("Parser Error: Expected " + keyword + " found EOF");
        }
    }

    private void showLinks(String linkname) {
        StringBuffer query = new StringBuffer("select LINK_NAME, LINK_URL, LINK_USERNAME from AXION_DB_LINKS");
        if (linkname != null && linkname.trim().length() != 0) {
            query.append(" where LINK_NAME ");
            query.append(linkname.indexOf("%") == -1 ? "= '" : "like '");
            query.append(linkname.toUpperCase()).append("'");
        }
        this.executeSql(query.toString());
    }

    private void showTableProperties(String tablename) {
        String query = "select PROPERTY_NAME, PROPERTY_VALUE from AXION_TABLE_PROPERTIES where TABLE_NAME = '" + tablename.toUpperCase() + "' ORDER BY PROPERTY_NAME";
        this.executeSql(query);
    }

    private void describeTable(String table) {
        String query = "select COLUMN_NAME, TYPE_NAME, COLUMN_SIZE, DECIMAL_DIGITS, IS_NULLABLE from AXION_COLUMNS where TABLE_NAME = '" + table.toUpperCase() + "' order by ORDINAL_POSITION";
        this.executeSql(query);
    }

    private void listTables(String type) {
        String query = "select TABLE_NAME, TABLE_TYPE from AXION_TABLES where TABLE_TYPE LIKE '%" + type.toUpperCase() + "%' " + "order by TABLE_NAME";
        this.executeSql(query);
    }

    private void showIndices(String indexName) {
        StringBuffer query = new StringBuffer("select index_name, table_name, column_name, index_type from AXION_INDEX_INFO order by INDEX_NAME");
        if (indexName != null && indexName.trim().length() != 0) {
            query.append(" where index_name ");
            query.append(indexName.indexOf("%") == -1 ? "= '" : "like '");
            query.append(indexName.toUpperCase()).append("'");
        }
        this.executeSql(query.toString());
    }

    private void executeSql(String sql) {
        try {
            long startTime = System.currentTimeMillis();
            boolean hasResultSet = this._stmt.execute(sql);
            long endTime = System.currentTimeMillis();
            if (hasResultSet) {
                ResultSet rset = this._stmt.getResultSet();
                this._report.reportResultSet(rset);
                rset.close();
            } else {
                int ct = this._stmt.getUpdateCount();
                this._report.reportUpdateCount(ct);
            }
            this._writer.println("Execution time: " + (endTime - startTime) + " ms.");
        }
        catch (SQLException e) {
            this._report.reportException(e);
        }
    }

    public void cleanUp() {
        try {
            this._stmt.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this._conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String input = null;
        boolean quit = false;
        if (args.length < 1) {
            System.out.println("Usage: java org.axiondb.tools.Console dbName");
            System.out.println(" or    java org.axiondb.tools.Console dbName location");
            System.out.println(" or    java org.axiondb.tools.Console dbName location outputFilePath");
        } else {
            Console axion = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                PrintWriter out = new PrintWriter(System.out, true);
                switch (args.length) {
                    case 3: {
                        try {
                            PrintWriter fw;
                            out = fw = new PrintWriter((Writer)new FileWriter(new File(args[2])), true);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        axion = new Console(args[0], args[1], out);
                        break;
                    }
                    case 2: {
                        axion = new Console(args[0], args[1], out);
                        break;
                    }
                    case 1: {
                        axion = new Console(args[0], out);
                        break;
                    }
                }
                System.out.println();
                System.out.println("Type 'quit' to quit the program.");
                while (!quit) {
                    System.out.print(_PROMPT);
                    input = in.readLine();
                    quit = "quit".equalsIgnoreCase(input) || "exit".equalsIgnoreCase(input);
                    if (quit || input == null || "".equals(input.trim())) continue;
                    try {
                        axion.execute(input);
                    }
                    catch (SQLException sqle) {
                        sqle.printStackTrace();
                    }
                }
            }
            catch (SQLException sqle) {
                System.out.println("Unable to connect to database");
                sqle.printStackTrace();
            }
            catch (IOException ioe) {
                System.out.println("Error while reading input");
                ioe.printStackTrace();
            }
            finally {
                try {
                    axion.cleanUp();
                }
                catch (Exception e) {}
            }
        }
    }

    static {
        try {
            Class.forName("org.axiondb.jdbc.AxionDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

