/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.coco.runtime;

import com.sun.encoder.coco.runtime.CobolDataConverter;
import com.sun.encoder.coco.runtime.RuleNode;
import com.sun.encoder.coco.runtime.messages.ErrorManager;
import com.sun.encoder.coco.runtime.messages.Message;
import com.sun.encoder.coco.runtime.messages.MessageCatalog;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class MarshalHandler
implements ContentHandler {
    private static final ErrorManager cErrorMgr = ErrorManager.getManager("OpenESB.encoder.COBOLCopybook." + MarshalHandler.class.getName());
    private final RuleNode mTopRule;
    private final OutputStream mOutputStream;
    private final NoSyncStack<MarshalContext> mStack;
    private final StringBuilder mBuffer = new StringBuilder(1024);
    private final boolean[] mTrackRedefined;
    private final Integer[] mOccursDependOn;
    private MatchDirection mMatchDirection;
    private RuleNode mRuleToBeSkipped = null;
    private int mSkippingLevel;

    public MarshalHandler(RuleNode topRule, OutputStream output) {
        if (topRule == null) {
            throw new NullPointerException("no top rule.");
        }
        if (output == null) {
            throw new NullPointerException("no output");
        }
        this.mTopRule = topRule;
        this.mTrackRedefined = new boolean[this.mTopRule.getContext().getRedefinedNodes().length];
        this.mOccursDependOn = new Integer[this.mTopRule.getContext().getOccursDependOnNodes().length];
        this.mOutputStream = output;
        this.mStack = new NoSyncStack();
        this.mStack.push(new MarshalContext(RuleNode.wrapAsSuperNode(this.mTopRule)));
        this.mMatchDirection = MatchDirection.FIRST_CHILD;
        this.mSkippingLevel = 0;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.isSkipping() && this.mSkippingLevel > 0) {
            ++this.mSkippingLevel;
            return;
        }
        RuleNode matchedNode = this.match(uri, localName);
        if (matchedNode != this.mStack.peek().mRule) {
            this.mStack.push(new MarshalContext(matchedNode));
            this.mStack.peek().mRepetition = 1;
        } else {
            ++this.mStack.peek().mRepetition;
        }
        this.enterProc(this.mStack.peek());
        this.mMatchDirection = MatchDirection.FIRST_CHILD;
        if (!this.isSkipping()) {
            this.mBuffer.setLength(0);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.isSkipping()) {
            this.mBuffer.append(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        RuleNode[] children;
        if (this.isSkipping() && this.mSkippingLevel > 0) {
            --this.mSkippingLevel;
            if (this.mSkippingLevel == 0) {
                this.mMatchDirection = this.mStack.peek().mRule.getMaxOccurs() > 1 ? MatchDirection.CURRENT : MatchDirection.NEXT_SIBLING;
            }
            return;
        }
        if (this.mMatchDirection != MatchDirection.FIRST_CHILD) {
            this.exitProc(this.mStack.pop(), uri, localName);
        } else {
            this.flushData();
        }
        RuleNode rule = this.mStack.peek().mRule;
        this.mMatchDirection = rule.getMaxOccurs() > 1 ? MatchDirection.CURRENT : MatchDirection.NEXT_SIBLING;
        int idx = rule.getOccursDependOnIndex();
        if (idx >= 0) {
            this.mOccursDependOn[idx] = new Integer(this.mBuffer.toString());
        }
        if ((children = rule.getChildren()) != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getRedefineIndex() < 0 || this.mTrackRedefined[children[i].getRedefineIndex()]) continue;
                throw new SAXException("Value is missing for redefined entry: " + rule.getContext().getRedefinedNodes()[children[i].getRedefineIndex()].getQName());
            }
        }
    }

    public void startDocument() throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    private RuleNode match(String uri, String localName) throws SAXException {
        int index;
        RuleNode currentRule = this.mStack.peek().mRule;
        switch (this.mMatchDirection) {
            case FIRST_CHILD: {
                index = 0;
                break;
            }
            case CURRENT: {
                if (currentRule.getQName().getLocalPart().equals(localName)) {
                    return currentRule;
                }
            }
            default: {
                this.exitProc(this.mStack.pop(), uri, localName);
                index = currentRule.getIndex() + 1;
                currentRule = this.mStack.peek().mRule;
            }
        }
        RuleNode[] children = currentRule.getChildren();
        if (children == null) {
            throw new SAXException("No matched rule for tag: '" + localName + "'");
        }
        while (index < children.length) {
            if (children[index].getQName().getLocalPart().equals(localName)) {
                return children[index];
            }
            if (children[index].getMinOccurs() > 0) {
                throw new SAXException("Expecting: " + children[index].getQName() + ", found: " + new QName(uri, localName));
            }
            ++index;
        }
        throw new SAXException("No matched rule for tag: '" + localName + "'");
    }

    private void enterProc(MarshalContext context) {
        RuleNode[] children;
        RuleNode redefinedNode = context.mRule.getRedefinedNode();
        if (redefinedNode != null && this.mTrackRedefined[redefinedNode.getRedefineIndex()]) {
            this.mRuleToBeSkipped = context.mRule;
            this.mSkippingLevel = 1;
        }
        if (!this.isSkipping() && (children = context.mRule.getChildren()) != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getRedefineIndex() < 0) continue;
                this.mTrackRedefined[children[i].getRedefineIndex()] = false;
            }
        }
    }

    private boolean isSkipping() {
        return this.mRuleToBeSkipped != null;
    }

    private void exitProc(MarshalContext context, String uri, String localName) throws SAXException {
        RuleNode dependOn;
        RuleNode redefined;
        if (context.mRule == this.mRuleToBeSkipped) {
            this.mRuleToBeSkipped = null;
            this.mSkippingLevel = 0;
            return;
        }
        if (context.mRule.getRedefineIndex() >= 0) {
            this.mTrackRedefined[context.mRule.getRedefineIndex()] = true;
        }
        if ((redefined = context.mRule.getRedefinedNode()) != null) {
            this.mTrackRedefined[redefined.getRedefineIndex()] = true;
        }
        if ((dependOn = context.mRule.getOccursDependOn()) != null) {
            Integer occurs = this.mOccursDependOn[dependOn.getOccursDependOnIndex()];
            if (occurs == null) {
                throw new SAXException("Occurs Depending On value is missing for " + context.mRule.getQName());
            }
            if (context.mRepetition < occurs) {
                throw new SAXException(context.mRule.getQName() + " should repeat " + occurs + " time(s) but now it only repeated " + context.mRepetition + " time(s)");
            }
            if (context.mRepetition < occurs) {
                throw new SAXException(context.mRule.getQName() + " can only repeat " + occurs + " time(s) but now it" + " repeated " + context.mRepetition + " time(s)");
            }
        } else if (context.mRepetition < context.mRule.getMinOccurs()) {
            throw new SAXException("Expecting: " + context.mRule.getQName() + ", found: " + new QName(uri, localName));
        }
    }

    private void flushData() throws SAXException {
        RuleNode rule = this.mStack.peek().mRule;
        if (rule.getChildren() == null || rule.getChildren().length == 0) {
            try {
                block1 : switch (rule.getCharacteristics().getUsage()) {
                    case 8: {
                        CobolDataConverter.encodeToFloat(this.mOutputStream, Float.parseFloat(this.mBuffer.toString()));
                        break;
                    }
                    case 9: {
                        CobolDataConverter.encodeToDouble(this.mOutputStream, Double.parseDouble(this.mBuffer.toString()));
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        CobolDataConverter.encodeToBinary(this.mOutputStream, new BigDecimal(this.mBuffer.toString()), rule.getPicture(), rule.getCharacteristics());
                        break;
                    }
                    case 5: 
                    case 6: {
                        CobolDataConverter.encodeToPacked(this.mOutputStream, new BigDecimal(this.mBuffer.toString()), rule.getPicture(), rule.getCharacteristics());
                        break;
                    }
                    case 7: {
                        CobolDataConverter.encodeToNativeBinary(this.mOutputStream, new BigDecimal(this.mBuffer.toString()), rule.getPicture(), rule.getCharacteristics());
                        break;
                    }
                    case 11: {
                        CobolDataConverter.encodeToIndex(this.mOutputStream, Integer.parseInt(this.mBuffer.toString()), rule.getCharacteristics());
                        break;
                    }
                    case 1: {
                        switch (rule.getCharacteristics().getPicCategory()) {
                            case 7: {
                                CobolDataConverter.encodeToExternalFloat(this.mOutputStream, new BigDecimal(this.mBuffer.toString()), rule.getPicture(), rule.getCharacteristics(), rule.getCharEncoding());
                                break block1;
                            }
                            case 4: {
                                CobolDataConverter.encodeToZoned(this.mOutputStream, new BigDecimal(this.mBuffer.toString()), rule.getPicture(), rule.getCharacteristics(), rule.getCharEncoding());
                                break block1;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 5: {
                                CobolDataConverter.encodeToDisplay(this.mOutputStream, this.mBuffer.toString(), rule.getCharacteristics(), rule.getCharEncoding());
                                break block1;
                            }
                            case 6: {
                                CobolDataConverter.encodeToDbcs(this.mOutputStream, this.mBuffer.toString().getBytes(rule.getCharEncoding()), rule.getCharacteristics().getSize());
                                break block1;
                            }
                        }
                        Message msg = MessageCatalog.getMessage("CCCB4113");
                        String err = msg.formatText(new Object[]{rule.getQName(), rule.getCharacteristics().getUsage()});
                        cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
                        throw new SAXException(err);
                    }
                    case 10: {
                        CobolDataConverter.encodeToDbcs(this.mOutputStream, this.mBuffer.toString().getBytes(rule.getCharEncoding()), rule.getCharacteristics().getSize());
                        break;
                    }
                    default: {
                        Message msg = MessageCatalog.getMessage("CCCB4112");
                        String err = msg.formatText(new Object[]{rule.getQName(), rule.getCharacteristics().getUsage()});
                        cErrorMgr.log(ErrorManager.Severity.ERROR, null, err);
                        throw new SAXException(err);
                    }
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NoSyncStack<E>
    extends LinkedList<E> {
        private static final long serialVersionUID = 1L;

        private NoSyncStack() {
        }

        @Override
        public void push(E o) {
            this.add(o);
        }

        @Override
        public E pop() {
            if (!this.isEmpty()) {
                return this.removeLast();
            }
            throw new RuntimeException("Stack underflow.");
        }

        @Override
        public E peek() {
            if (!this.isEmpty()) {
                return this.getLast();
            }
            throw new RuntimeException("Stack underflow.");
        }
    }

    private static final class MarshalContext {
        public final RuleNode mRule;
        public int mRepetition;

        public MarshalContext(RuleNode rule) {
            this.mRule = rule;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MatchDirection {
        FIRST_CHILD,
        CURRENT,
        NEXT_SIBLING;

    }
}

