/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.TraceFilter;
import com.sun.jdmk.TraceListener;
import com.sun.jdmk.TraceNotification;
import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.trace.Trace;
import com.sun.jdmk.trace.TraceDestination;
import com.sun.jdmk.trace.TraceTags;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class TraceManager
implements TraceTags {
    private static final boolean logging;
    private static Handler handler;
    private static final HashSet loggerNames;
    private static ArrayList listeners;
    private static int selectedLevels;
    private static int selectedTypes;
    private static HashMap type_seq;
    protected static final String UNKOWNTYPE = "Unknown type";
    private static TraceListener traceListener;
    private static Constructor co;
    static /* synthetic */ Class class$java$util$logging$Logger;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$util$logging$Formatter;
    static /* synthetic */ Class class$java$util$logging$StreamHandler;

    private TraceManager() {
    }

    private static boolean isSelected(int n, int n2) {
        boolean bl = false;
        bl = n == 1 && selectedLevels != 0 ? true : (selectedLevels & n) != 0;
        return bl &= (selectedTypes & n2) != 0;
    }

    public static void parseTraceProperties() throws IOException {
        TraceManager.parseTraceProperties(null, null);
    }

    public static void parseTraceProperties(Properties properties, ClassLoader classLoader) throws IOException {
        Object object;
        int n = 0;
        int n2 = 0;
        Properties properties2 = properties;
        String string = TraceManager.getProperty(properties2, "TRACE_OUTPUT");
        if (TraceManager.getProperty(properties2, "LEVEL_TRACE") != null) {
            n |= 1;
        }
        if (TraceManager.getProperty(properties2, "LEVEL_DEBUG") != null) {
            n |= 2;
        }
        if (TraceManager.getProperty(properties2, "INFO_ADAPTOR_HTML") != null) {
            n2 |= 0x10;
        }
        if (TraceManager.getProperty(properties2, "INFO_CONNECTOR_HTTP") != null) {
            n2 |= 0x200;
        }
        if (TraceManager.getProperty(properties2, "INFO_CONNECTOR_HTTPS") != null) {
            n2 |= 0x800;
        }
        if (TraceManager.getProperty(properties2, "INFO_CONNECTOR_RMI") != null) {
            n2 |= 0x100;
        }
        if (TraceManager.getProperty(properties2, "INFO_ADAPTOR_SNMP") != null) {
            n2 |= 0x400;
        }
        if (TraceManager.getProperty(properties2, "INFO_ADAPTOR_CONNECTOR") != null) {
            n2 |= 0xF10;
        }
        if (TraceManager.getProperty(properties2, "INFO_DISCOVERY") != null) {
            n2 |= 0x1000;
        }
        if (TraceManager.getProperty(properties2, "INFO_MBEANSERVER") != null) {
            n2 |= 1;
        }
        if (TraceManager.getProperty(properties2, "INFO_MLET") != null) {
            n2 |= 2;
        }
        if (TraceManager.getProperty(properties2, "INFO_SNMP") != null) {
            n2 |= 0x40;
        }
        if (TraceManager.getProperty(properties2, "INFO_MONITOR") != null) {
            n2 |= 4;
        }
        if (TraceManager.getProperty(properties2, "INFO_TIMER") != null) {
            n2 |= 8;
        }
        if (TraceManager.getProperty(properties2, "INFO_NOTIFICATION") != null) {
            n2 |= 0x80;
        }
        if (TraceManager.getProperty(properties2, "INFO_HEARTBEAT") != null) {
            n2 |= 0x2000;
        }
        if (TraceManager.getProperty(properties2, "INFO_RELATION") != null) {
            n2 |= 0x4000;
        }
        if (TraceManager.getProperty(properties2, "INFO_MODELMBEAN") != null) {
            n2 |= 0x8000;
        }
        if (TraceManager.getProperty(properties2, "INFO_MISC") != null) {
            n2 |= 0x20;
        }
        if (TraceManager.getProperty(properties2, "INFO_ALL") != null) {
            n2 = 65535;
        }
        if (string != null || n != 0 || n2 != 0) {
            if (n == 0) {
                n = 1;
            }
            if (n2 == 0) {
                n2 = 65535;
            }
            object = new TraceFilter(n, n2);
            TraceManager.removeNotificationListener(traceListener);
            if (logging) {
                TraceManager.undoLoggingConfiguration();
            }
            traceListener = string != null && !string.equals("") ? new TraceListener(string) : new TraceListener();
            if (TraceManager.getProperty(properties2, "TRACE_VERBOSE") != null) {
                traceListener.setFormated(true);
            }
            if (logging) {
                TraceManager.configureLogging(properties2, n2, TraceManager.traceListener.out);
            }
            TraceManager.addNotificationListener(traceListener, (NotificationFilter)object, null);
        }
        object = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        String string3 = System.getProperty("os.version");
        String string4 = System.getProperty("java.version");
        String string5 = DefaultPaths.getInstallDir();
        Trace.send(1, 32, "Java DMK", "TraceManager", "Java DMK home [" + string5 + "], " + "Java DMK build version [" + "5.1-b34.1" + "], " + "JMX version : [" + "1.2 Maintenance Release" + "], " + "Java version [" + string4 + "], " + "os name [" + (String)object + "], " + "os arch [" + string2 + "], " + "os version [" + string3 + "]");
    }

    private static void setLevel(Level level, String string) {
        Logger.getLogger(string).setLevel(level);
        loggerNames.add(string);
    }

    private static synchronized void undoLoggingConfiguration() {
        if (!logging) {
            return;
        }
        if (handler == null) {
            return;
        }
        Logger.getLogger("com.sun.jdmk").removeHandler(handler);
        Logger.getLogger("javax.management").removeHandler(handler);
        handler = null;
        try {
            Iterator iterator = loggerNames.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Logger.getLogger(string).setLevel(null);
                iterator.remove();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static synchronized void configureLogging(Properties properties, int n, OutputStream outputStream) {
        if (!logging) {
            return;
        }
        Level level = Level.INFO;
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        try {
            if (co == null) {
                co = (class$java$util$logging$StreamHandler == null ? (class$java$util$logging$StreamHandler = TraceManager.class$("java.util.logging.StreamHandler")) : class$java$util$logging$StreamHandler).getConstructor(class$java$io$OutputStream == null ? (class$java$io$OutputStream = TraceManager.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$util$logging$Formatter == null ? (class$java$util$logging$Formatter = TraceManager.class$("java.util.logging.Formatter")) : class$java$util$logging$Formatter);
            }
            handler = (Handler)co.newInstance(outputStream, simpleFormatter);
        }
        catch (Throwable throwable) {
            System.err.println("WARNING: Can't configure Java DMK logging traces: " + throwable);
            return;
        }
        handler.setLevel(Level.FINEST);
        Logger.getLogger("com.sun.jdmk").addHandler(handler);
        Logger.getLogger("javax.management").addHandler(handler);
        if (TraceManager.getProperty(properties, "LEVEL_SEVERE") != null) {
            level = Level.SEVERE;
        }
        if (TraceManager.getProperty(properties, "LEVEL_WARNING") != null) {
            level = Level.WARNING;
        }
        if (TraceManager.getProperty(properties, "LEVEL_INFO") != null) {
            level = Level.INFO;
        }
        if (TraceManager.getProperty(properties, "LEVEL_CONFIG") != null) {
            level = Level.CONFIG;
        }
        if (TraceManager.getProperty(properties, "LEVEL_FINE") != null) {
            level = Level.FINE;
        }
        if (TraceManager.getProperty(properties, "LEVEL_FINER") != null) {
            level = Level.FINER;
        }
        if (TraceManager.getProperty(properties, "LEVEL_TRACE") != null) {
            level = Level.FINER;
        }
        if (TraceManager.getProperty(properties, "LEVEL_FINEST") != null) {
            level = Level.FINEST;
        }
        if (TraceManager.getProperty(properties, "LEVEL_DEBUG") != null) {
            level = Level.FINEST;
        }
        if ((n & 0xFFFF) == 65535) {
            TraceManager.setLevel(level, "com.sun.jdmk");
            TraceManager.setLevel(level, "javax.management");
            return;
        }
        if ((n & 0x10) != 0) {
            TraceManager.setLevel(level, "com.sun.jdmk.html.adaptor");
        }
        if ((n & 0x200) != 0) {
            TraceManager.setLevel(level, "com.sun.jdmk.comm.legacy.connector.http");
        }
        if ((n & 0x800) != 0) {
            TraceManager.setLevel(level, "com.sun.jdmk.comm.legacy.connector.https");
        }
        if ((n & 0x100) != 0) {
            TraceManager.setLevel(level, "com.sun.jdmk.comm.legacy.connector.rmi");
        }
        if ((n & 0x400) != 0) {
            TraceManager.setLevel(level, "com.sun.jdmk.snmp.adaptor");
        }
        if ((n & 0x1000) != 0) {
            TraceManager.setLevel(level, "com.sun.jdmk.discovery");
        }
        if ((n & 1) != 0) {
            TraceManager.setLevel(level, "com.sun.jdmk.mbeanserver");
            TraceManager.setLevel(level, "javax.management.mbeanserver");
        }
        if ((n & 2) != 0) {
            TraceManager.setLevel(level, "javax.management.mlet");
        }
        if ((n & 0x40) != 0) {
            TraceManager.setLevel(level, "com.sun.jdmk.snmp.runtime");
        }
        if ((n & 4) != 0) {
            TraceManager.setLevel(level, "javax.management.monitor");
        }
        if ((n & 8) != 0) {
            TraceManager.setLevel(level, "javax.management.timer");
        }
        if ((n & 0x80) != 0) {
            TraceManager.setLevel(level, "com.sun.jdmk.notification");
            TraceManager.setLevel(level, "javax.management.notification");
        }
        if ((n & 0x2000) != 0) {
            TraceManager.setLevel(level, "com.sun.jdmk.comm.legacy.connector.heartbeat");
        }
        if ((n & 0x4000) != 0) {
            TraceManager.setLevel(level, "javax.management.relation");
        }
        if ((n & 0x8000) != 0) {
            TraceManager.setLevel(level, "javax.management.modelmbean");
        }
        if ((n & 0x20) != 0) {
            TraceManager.setLevel(level, "javax.management.misc");
        }
    }

    public static void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        TraceFilter traceFilter;
        if (notificationListener == null) {
            throw new IllegalArgumentException("A listener should be specified.");
        }
        if (notificationFilter == null) {
            traceFilter = new TraceFilter(2, 65535);
        } else if (notificationFilter instanceof TraceFilter) {
            traceFilter = (TraceFilter)notificationFilter;
        } else {
            throw new IllegalArgumentException("The filter should be an instance of the class TraceFilter.");
        }
        listeners.add(new ListenerInfo(notificationListener, traceFilter, object));
        TraceManager.updateSelected(traceFilter.getLevels(), traceFilter.getTypes());
    }

    public static void addNotificationListener(TraceListener traceListener, Object object) throws IllegalArgumentException {
        if (traceListener == null) {
            throw new IllegalArgumentException("A listener should be specified.");
        }
        TraceFilter traceFilter = new TraceFilter(1, 65535);
        listeners.add(new ListenerInfo(traceListener, new TraceFilter(1, 65535), object));
        TraceManager.updateSelected(1, 65535);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNotificationListener(NotificationListener notificationListener) {
        ListenerInfo listenerInfo;
        int n;
        ArrayList arrayList = listeners;
        synchronized (arrayList) {
            for (n = 0; n < listeners.size(); ++n) {
                listenerInfo = (ListenerInfo)listeners.get(n);
                if (listenerInfo.listener != notificationListener) continue;
                listeners.remove(n);
                break;
            }
        }
        arrayList = listeners;
        synchronized (arrayList) {
            for (n = 0; n < listeners.size(); ++n) {
                listenerInfo = (ListenerInfo)listeners.get(n);
                TraceManager.updateSelected(listenerInfo.filter.getLevels(), listenerInfo.filter.getTypes());
            }
        }
    }

    public static void removeAllListeners() {
        listeners.clear();
        selectedLevels = 0;
        selectedTypes = 0;
    }

    static void register() {
        Trace.setDestination(new Destination());
    }

    static boolean selectedCheck(int n, int n2) {
        boolean bl = n == 1 || n == 2 || n == 3;
        return bl &= (n2 | 0xFFFF) == 65535;
    }

    static String getType(int n) {
        String string = "";
        switch (n) {
            case 16: {
                string = "INFO_ADAPTOR_HTML";
                break;
            }
            case 4096: {
                string = "INFO_DISCOVERY";
                break;
            }
            case 1: {
                string = "INFO_MBEANSERVER";
                break;
            }
            case 2: {
                string = "INFO_MLET";
                break;
            }
            case 4: {
                string = "INFO_MONITOR";
                break;
            }
            case 8: {
                string = "INFO_TIMER";
                break;
            }
            case 32: {
                string = "INFO_MISC";
                break;
            }
            case 3856: {
                string = "INFO_ADAPTOR_CONNECTOR";
                break;
            }
            case 256: {
                string = "INFO_CONNECTOR_RMI";
                break;
            }
            case 512: {
                string = "INFO_CONNECTOR_HTTP";
                break;
            }
            case 2048: {
                string = "INFO_CONNECTOR_HTTPS";
                break;
            }
            case 1024: {
                string = "INFO_ADAPTOR_SNMP";
                break;
            }
            case 64: {
                string = "INFO_SNMP";
                break;
            }
            case 128: {
                string = "INFO_NOTIFICATION";
                break;
            }
            case 8192: {
                string = "INFO_HEARTBEAT";
                break;
            }
            case 16384: {
                string = "INFO_RELATION";
                break;
            }
            case 32768: {
                string = "INFO_MODELMBEAN";
                break;
            }
        }
        return string;
    }

    static String getLevel(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "LEVEL_TRACE";
                break;
            }
            case 2: {
                string = "LEVEL_DEBUG";
                break;
            }
            default: {
                string = "Unkown level";
            }
        }
        return string;
    }

    private static boolean JDMKSelectedCheck(int n, int n2) {
        boolean bl = n == 1 || n == 2 || n == 3;
        return bl &= (n2 | 0xFFFF) == 65535;
    }

    private static String getProperty(Properties properties, final String string) {
        if (properties != null) {
            return properties.getProperty(string);
        }
        String string2 = null;
        try {
            string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string);
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return string2;
    }

    private static boolean send(int n, int n2, String string, String string2, String string3) {
        if (!TraceManager.isSelected(n, n2)) {
            return false;
        }
        TraceNotification traceNotification = new TraceNotification("Trace", TraceManager.getSeq(n2), TraceManager.getSeq(0), n, n2, string, string2, string3, null);
        TraceManager.distribute(traceNotification);
        return true;
    }

    private static boolean send(int n, int n2, String string, String string2, Throwable throwable) {
        if (!TraceManager.isSelected(n, n2)) {
            return false;
        }
        TraceNotification traceNotification = new TraceNotification("Trace", TraceManager.getSeq(n2), TraceManager.getSeq(0), n, n2, string, string2, null, throwable);
        TraceManager.distribute(traceNotification);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void distribute(TraceNotification traceNotification) {
        ArrayList arrayList = listeners;
        synchronized (arrayList) {
            for (int i = 0; i < listeners.size(); ++i) {
                ListenerInfo listenerInfo = (ListenerInfo)listeners.get(i);
                if (listenerInfo.filter != null && !listenerInfo.filter.isNotificationEnabled(traceNotification)) continue;
                try {
                    listenerInfo.listener.handleNotification(traceNotification, listenerInfo.handback);
                    continue;
                }
                catch (Exception exception) {
                    TraceManager.removeNotificationListener(listenerInfo.listener);
                    if (!TraceManager.isSelected(2, 32)) continue;
                    TraceManager.send(2, 32, "Trace", "distribute", exception);
                }
            }
        }
    }

    private static void updateSelected(int n, int n2) {
        selectedLevels |= n;
        selectedTypes |= n2;
    }

    private static long getSeq(int n) {
        long l;
        Integer n2 = new Integer(n);
        Long l2 = (Long)type_seq.get(n2);
        if (l2 == null) {
            l2 = new Long(0L);
            type_seq.put(n2, l2);
        }
        l = (l = l2.longValue()) == Long.MAX_VALUE ? 1L : ++l;
        type_seq.put(n2, new Long(l));
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        boolean bl = false;
        try {
            Class clazz = class$java$util$logging$Logger == null ? (class$java$util$logging$Logger = TraceManager.class$("java.util.logging.Logger")) : class$java$util$logging$Logger;
            bl = true;
        }
        catch (Error error) {
            // empty catch block
        }
        logging = bl;
        TraceManager.register();
        handler = null;
        loggerNames = new HashSet();
        listeners = new ArrayList();
        selectedLevels = 0;
        selectedTypes = 0;
        type_seq = new HashMap(20);
        traceListener = null;
        co = null;
    }

    private static class ListenerInfo {
        public NotificationListener listener;
        public TraceFilter filter;
        public Object handback;

        public ListenerInfo(NotificationListener notificationListener, TraceFilter traceFilter, Object object) {
            this.listener = notificationListener;
            this.filter = traceFilter;
            this.handback = object;
        }
    }

    private static final class Destination
    implements TraceDestination {
        private Destination() {
        }

        public boolean isSelected(int n, int n2) {
            return TraceManager.isSelected(n, n2);
        }

        public boolean send(int n, int n2, String string, String string2, String string3) {
            return TraceManager.send(n, n2, string, string2, string3);
        }

        public boolean send(int n, int n2, String string, String string2, Throwable throwable) {
            return TraceManager.send(n, n2, string, string2, throwable);
        }

        public void reset() throws IOException {
            TraceManager.parseTraceProperties();
        }
    }
}

