/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.navigation;

import java.awt.Component;
import java.util.List;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JToggleButtonOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.EditorOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.xhtml.FormNamePanel;

public class NavigatorOperator
extends JComponentOperator {
    private static final String DEFAULT_LINK_ID = "case1";
    private static final String PAGE_NAVIGATION_TITLE = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.navigation.Bundle", "NavigationView");
    private static final String NAVIGATION_BUTTON = Bundle.getStringTrimmed("org.netbeans.modules.visualweb.navigation.Bundle", "ViewNavigation");
    ComponentOperator desktop = null;
    private JToggleButtonOperator _btSource;
    private JToggleButtonOperator _btNavigation;

    public NavigatorOperator(ContainerOperator parent) {
        super(parent, (ComponentChooser)new NavigatorChooser());
        this.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(true, true));
    }

    public NavigatorOperator() {
        this((ContainerOperator)Util.getMainWindow());
    }

    public JToggleButtonOperator btSource() {
        if (this._btSource == null) {
            TopComponentOperator topComponent = new TopComponentOperator((ContainerOperator)Util.getMainWindow());
            this._btSource = new JToggleButtonOperator((ContainerOperator)topComponent, "XML");
        }
        return this._btSource;
    }

    public JToggleButtonOperator btNavigation() {
        if (this._btNavigation == null) {
            TopComponentOperator topComponent = new TopComponentOperator((ContainerOperator)Util.getMainWindow());
            this._btNavigation = new JToggleButtonOperator((ContainerOperator)topComponent, NAVIGATION_BUTTON);
        }
        return this._btNavigation;
    }

    public void switchToSource() {
        this.btSource().pushNoBlock();
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    public void switchToNavigation() {
        this.btNavigation().pushNoBlock();
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    public static NavigatorOperator show() {
        Util.getMainTab().setSelectedIndex(Util.getMainTab().findPage("Page Navigation"));
        return new NavigatorOperator();
    }

    private ComponentOperator getDesktop() {
        if (this.desktop == null) {
            this.desktop = new NavigatorGraphFrameOperator();
        }
        return this.desktop;
    }

    public void pushPopup(String menuText) {
        this.getDesktop().clickForPopup(1, 1);
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            // empty catch block
        }
        new JPopupMenuOperator().pushMenuNoBlock(menuText);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clickForPopup(int x, int y) {
        this.getDesktop().clickForPopup(x, y);
    }

    public void clickMouse(int x, int y) {
        this.getDesktop().clickMouse(x, y, 1);
    }

    public void clickMouse(int x, int y, int count) {
        this.getDesktop().clickMouse(x, y, count);
    }

    public void link(String page1, String page2) {
        this.linkUsingXmlSource(page1, page2);
    }

    public void link(String page1, String page2, String linkId) {
        this.linkUsingXmlSource(page1, page2, linkId);
    }

    public void linkUsingXmlSource(List webPageNameList) {
        this.linkUsingXmlSource(webPageNameList, DEFAULT_LINK_ID);
    }

    public void linkUsingXmlSource(List webPageNameList, String linkId) {
        this.switchToSource();
        Util.wait(1000);
        new QueueTool().waitEmpty();
        EditorOperator editor = this.getEditorOperator();
        for (int i = 0; i < webPageNameList.size() - 1; ++i) {
            String masterWebPageName = (String)webPageNameList.get(i);
            String slaveWebPageName = (String)webPageNameList.get(i + 1);
            this.appendLinkXmlTags(editor, masterWebPageName, slaveWebPageName, linkId);
            TestUtils.outMsg("+++ Web page link [" + linkId + "] from [" + masterWebPageName + "] to [" + slaveWebPageName + "] is created");
        }
        this.switchToNavigation();
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    public void linkUsingXmlSource(String fromPageName, String toPageName) {
        this.linkUsingXmlSource(fromPageName, toPageName, DEFAULT_LINK_ID);
    }

    public void linkUsingXmlSource(String fromPageName, String toPageName, String linkId) {
        this.switchToSource();
        Util.wait(1000);
        new QueueTool().waitEmpty();
        EditorOperator editor = this.getEditorOperator();
        this.appendLinkXmlTags(editor, fromPageName, toPageName, linkId);
        this.switchToNavigation();
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    private void appendLinkXmlTags(EditorOperator editor, String fromPageName, String toPageName, String linkId) {
        this.putCaretToBeginOfLastLine(editor);
        Util.wait(500);
        new QueueTool().waitEmpty();
        String linkXmlTags = this.getLinkXmlTags(fromPageName, toPageName, linkId);
        TestUtils.outMsg("+++ xml-tags used for link [" + linkId + "] between pages [" + fromPageName + "] and [" + toPageName + "]: " + linkXmlTags);
        editor.insert(linkXmlTags);
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    private void putCaretToBeginOfLastLine(EditorOperator editor) {
        if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            editor.pushKey(35, 256);
        } else {
            editor.pushKey(35, 128);
        }
        Util.wait(1000);
        new QueueTool().waitEmpty();
        editor.pushUpArrowKey();
        Util.wait(1000);
        new QueueTool().waitEmpty();
    }

    private String getLinkXmlTags(String fromPageName, String toPageName, String linkId) {
        String[] xmlTags = new String[]{"    <navigation-rule>", "        <from-view-id>/" + fromPageName + "</from-view-id>", "            <navigation-case>", "                <from-outcome>" + linkId + "</from-outcome>", "                <to-view-id>/" + toPageName + "</to-view-id>", "        </navigation-case>", "    </navigation-rule>"};
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < xmlTags.length; ++i) {
            buffer.append(xmlTags[i]);
            buffer.append("\n");
        }
        return buffer.toString();
    }

    private EditorOperator getEditorOperator() {
        TopComponentOperator topComponent = new TopComponentOperator((ContainerOperator)Util.getMainWindow());
        EditorOperator editor = new EditorOperator((ContainerOperator)topComponent, PAGE_NAVIGATION_TITLE);
        Util.wait(1000);
        new QueueTool().waitEmpty();
        TestUtils.outMsg("+++ Source editor for [" + PAGE_NAVIGATION_TITLE + "] found");
        return editor;
    }

    public static class NavigatorChooser
    implements ComponentChooser {
        public boolean checkComponent(Component comp) {
            return false;
        }

        public String getDescription() {
            return null;
        }
    }

    public class NavigatorGraphFrameChooser
    implements ComponentChooser {
        public boolean checkComponent(Component comp) {
            return false;
        }

        public String getDescription() {
            return FormNamePanel.class.getName();
        }
    }

    public class NavigatorGraphFrameOperator
    extends ComponentOperator {
        public NavigatorGraphFrameOperator() {
            super((ContainerOperator)NavigatorOperator.this, (ComponentChooser)new NavigatorGraphFrameChooser());
        }
    }
}

