/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.mtom.AbstractXOPType;
import org.codehaus.xfire.aegis.type.mtom.ByteArrayType;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.Base64;

public class Base64Type
extends Type {
    private static ByteArrayType optimizedType = new ByteArrayType();

    public Object readObject(MessageReader mreader, MessageContext context) throws XFireFault {
        boolean mtomEnabled = Boolean.valueOf((String)context.getContextualProperty("mtom-enabled"));
        XMLStreamReader reader = mreader.getXMLStreamReader();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int event = reader.next();
            while (!(reader.isCharacters() || reader.isEndElement() || reader.isStartElement())) {
                event = reader.next();
            }
            if (reader.isStartElement() && reader.getName().equals(AbstractXOPType.XOP_INCLUDE)) {
                if (mtomEnabled) {
                    return optimizedType.readObject(mreader, context);
                }
                throw new XFireFault("Unexpected element: " + reader.getName(), XFireFault.SENDER);
            }
            if (reader.isEndElement()) {
                return new byte[0];
            }
            int length = reader.getTextLength();
            char[] myBuffer = new char[length];
            int sourceStart = 0;
            while (true) {
                int nCopied = reader.getTextCharacters(sourceStart, myBuffer, 0, length);
                Base64.decode((char[])myBuffer, (int)0, (int)nCopied, (OutputStream)bos);
                if (nCopied < length) break;
                sourceStart += length;
            }
            while (reader.getEventType() != 2) {
                reader.next();
            }
            reader.next();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new XFireFault("Could not parse base64Binary data.", (Throwable)e, XFireFault.SENDER);
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Could not parse base64Binary data.", (Throwable)e, XFireFault.SENDER);
        }
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        boolean mtomEnabled = Boolean.valueOf((String)context.getContextualProperty("mtom-enabled"));
        if (mtomEnabled) {
            optimizedType.writeObject(object, writer, context);
            return;
        }
        byte[] data = (byte[])object;
        writer.writeValue(Base64.encode((byte[])data));
    }
}

