/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.runtime;

import com.sun.sql.framework.jdbc.DBConnectionFactory;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.ScEncrypt;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class RuntimeUtil {
    public static final String EVT_COLLAB_STARTED = "ETL-00001";
    public static final String EVT_COLLAB_STOPPED = "ETL-00002";
    public static final String EVT_COLLAB_EXCEPTION = "ETL-00003";
    public static final String EVT_ACTIVITY_STARTED = "ETL-00004";
    public static final String EVT_ACTIVITY_STOPPED = "ETL-00005";
    public static final String EVT_ACTIVITY_EXCEPTION = "ETL-00006";
    private static final String LOG_CATEGORY = RuntimeUtil.class.getName();
    public static final String COLLAB_NAME = "collabName";
    public static final String COLLAB_ID = "collabId";
    public static final String PROJECT_NAME = "projectName";
    public static final String DEPLOYMENT_NAME = "deploymentName";
    public static final String ENV_NAME = "envName";
    public static final String LOGICAL_HOST_NAME = "logicalHostName";
    public static final String PHYSICAL_HOST_NAME = "physicalHostName";
    public static final String IS_NAME = "integrationServerName";
    public static final String TARGET_TABLE_NAME = "targetTableName";
    public static final String EXECUTION_ID = "executionId";
    public static final String EXECEPTION = "exception";

    public static Map getLDAPResolvedParameters(String jdbcUid, String jdbcPswd) throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("userName", jdbcUid);
        ret.put("password", jdbcPswd);
        boolean uidChanged = false;
        String resolvedUid = null;
        String resolvedPswd = null;
        if (jdbcPswd != null) {
            if (jdbcUid == null) {
                jdbcUid = "";
            }
            jdbcPswd = ScEncrypt.decrypt(jdbcUid, jdbcPswd);
            Logger.print(10000, LOG_CATEGORY, "Decrypted PSWD.");
        }
        if (DBConnectionFactory.isLDAPQuery(jdbcUid)) {
            if (resolvedUid == null) {
                resolvedUid = jdbcUid;
            }
            ret.put("userName", resolvedUid);
            uidChanged = true;
            Logger.print(10000, LOG_CATEGORY, "Looked-up UID:" + resolvedUid);
        } else {
            resolvedUid = jdbcUid;
        }
        if (DBConnectionFactory.isLDAPQuery(jdbcPswd)) {
            Logger.print(10000, LOG_CATEGORY, "Looked-up PSWD.");
            resolvedPswd = ScEncrypt.encrypt(resolvedUid.trim(), resolvedPswd.trim());
            ret.put("password", resolvedPswd);
            Logger.print(10000, LOG_CATEGORY, "New encrypted PSWD:" + resolvedPswd);
        } else if (uidChanged) {
            resolvedPswd = ScEncrypt.encrypt(resolvedUid.trim(), jdbcPswd);
            ret.put("password", resolvedPswd);
            Logger.print(10000, LOG_CATEGORY, "New encrypted PSWD:" + resolvedPswd);
        }
        return ret;
    }

    public static String getExceptionStackTrace(Throwable ex) {
        StringBuffer sb = new StringBuffer("Exception is:");
        sb.append("(");
        sb.append(ex.getClass().getName());
        sb.append(")");
        sb.append(ex.getMessage());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            ex.printStackTrace(pw);
            sb.append("\n");
            sb.append(sw.toString());
            pw.close();
            sw.close();
        }
        catch (Exception ex1) {
            Logger.printThrowable(10000, LOG_CATEGORY, RuntimeUtil.class, "Exception while send exception alert message.", ex1);
            sb = new StringBuffer("\nException stack trace not available.");
        }
        return sb.toString();
    }
}

