/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.component;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.jbi.component.Jbi4CorbaSUManager;
import it.imolinfo.jbi4corba.jbi.component.runtime.AbstractMessageExchangeHandler;
import it.imolinfo.jbi4corba.jbi.component.runtime.RuntimeHelper;
import it.imolinfo.jbi4corba.jbi.endpoint.Jbi4CorbaEndpoint;
import it.imolinfo.jbi4corba.jbi.processor.ExchangeProcessor;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;

public class Jbi4CorbaMessageExchangeHandler
extends AbstractMessageExchangeHandler {
    public static final long SEND_SYNC_TIMEOUT = 60000L;
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4CorbaMessageExchangeHandler.class);
    private Jbi4CorbaSUManager suManager = null;

    public Jbi4CorbaMessageExchangeHandler(Jbi4CorbaSUManager suManager) {
        this.suManager = suManager;
    }

    protected final void processMessage() {
        InOut inOutMX = (InOut)this.getMessageExchange();
        Jbi4CorbaEndpoint corbaEndpoint = this.suManager.getStartedEndpoint(inOutMX.getEndpoint());
        LOG.info("Received message invocation for the endpoint:" + corbaEndpoint.getEndpointName());
        ExchangeProcessor processor = corbaEndpoint.getExchangeProcessor();
        processor.process((MessageExchange)inOutMX);
    }

    protected void validateMessageExchange() throws MessagingException {
        MessageExchange msgExchange = this.getMessageExchange();
        if (this.getMessageExchange() == null) {
            throw new MessagingException("MessageExchange Object is null in MessageExchageHandler");
        }
        if (MessageExchange.Role.CONSUMER.equals(msgExchange.getRole())) {
            throw new MessagingException("Provider Message Exchange Handler can not have MessageExchange with CONSUMER Role");
        }
        if (!(msgExchange instanceof InOut)) {
            throw new MessagingException("InOut Message Exchange Handler MessageExchange object should be instanceof javax.jbi.messaging.InOut ");
        }
    }

    protected void processFault(Fault fault) {
        RuntimeHelper.logError("InOut Message exchange provider received FAULT");
    }

    protected void processDone() {
        RuntimeHelper.logVerbose("InOut Message Exchange Provider handler received DONE : END of service invocation");
    }

    protected void processError(Exception ex) {
        RuntimeHelper.logError("InOut Message Exchange Provider handler received Error");
        RuntimeHelper.logError(ex);
    }
}

