<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">

  <xsl:output method="html" indent="yes"/>

  <!-- template rule matching source root element -->
  <xsl:template match="/">
    <html> <head> 
    <title>Java AVK for the Enterprise Report Tool </title>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <LINK href="./appVerification.css" rel="stylesheet" type="text/css"> 
    </LINK>
    </meta>
    </head>

    <xsl:apply-templates select="app-verification"/>

    </html>
  </xsl:template>

  <xsl:template match="app-verification">
     <body bgcolor="#FFFFFF" background="./Lt_BluePaperTexture.gif">
     <form method="post" action="">
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
           <tr bgcolor="7171A5">
             <td width="100%"> 
                <div class="page-title-text" align="left">Java AVK for the Enterprise - Suite Summary </div>
             </td>
           </tr>
        </table>
  <br>
  <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td width="2%"/>
      <td width="98%"/>
    </tr>
    <tr> 
      <td width="1%"/>
      <td width="99%"> 
        <table border="0" cellpadding="1" cellspacing="0" bgcolor="#000000">
          <tr> 
            <td> 
              <table border="0" cellspacing="0" cellpadding="0" class="button ">
                <tr> 
                  <td align="center" valign="middle"><a href="verifierSummary.html" class="button-link-text" title="Save Changes Button">Click to See Static Archive Tests Summary </a></td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
  </br>

  <br>
  <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr>
      <td width="2%"/>
      <td width="98%"/>
    </tr>
    <tr> 
      <td width="1%"/>
      <td width="99%"> 
        <table border="0" cellpadding="1" cellspacing="0" bgcolor="#000000">
          <tr> 
            <td> 
              <table border="0" cellspacing="0" cellpadding="0" class="button ">
                <tr> 
                  <td align="center" valign="middle"><a href="codeSummary.html" class="button-link-text" title="Save Changes Button">Click to See Code Scanning Tests Summary </a></td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
  </br>
      <xsl:apply-templates select="percentage"/> 

     </form>
     </body>
  </xsl:template>

  <xsl:template match="percentage">
      <br>
      <xsl:choose>
      <xsl:when test="count(bean-percentage) != 0">
      <table border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr> 
          <td> 
            <div class="table-title-text">EJB Method Coverage </div>
          </td>
        </tr>
      </table>

      <table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
      <tr> 
      <td> 
        <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
          <tr class="header-row"> 
          <td width="40%"> 
              <div class="table-header-text" align="left">EAR File </div>
          </td>
          <td width="60%"> 
              <div class="table-header-text" align="left">Status </div>
          </td>
          </tr>
          <tr height="1"> 
          <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
	      <xsl:for-each select="bean-percentage">
                <tr> 
                <td width="40%" valign="top"> 
                <div class="table-normal-text"><a href="ejbCoverage.html"><xsl:value-of select="app-name"/> </a></div>
                </td>
                <td width="60%" valign="bottom"> 
		  <xsl:variable name="ejb-percent" select="normalize-space(ejb-percentage)"/>
		  <xsl:choose>
		    <xsl:when test="$ejb-percent &lt; '80'">
                      <div class="table-failed-text">Failed <xsl:value-of select="ejb-percentage"/>% of methods called </div>
		    </xsl:when>
		    <xsl:otherwise>
	              <xsl:choose>
	              <xsl:when test="count(//enterprise-bean/method/exception) != 0">
                          <div class="table-failed-text">Failed <xsl:value-of select="ejb-percentage"/>% of methods called, exceptions found </div>
	              </xsl:when>
	              <xsl:otherwise>
                         <div class="table-normal-text">Passed <xsl:value-of select="ejb-percentage"/>% of methods called </div>
	              </xsl:otherwise>
	              </xsl:choose>
		    </xsl:otherwise>
		  </xsl:choose>
	        </td>
	        </tr>
	      </xsl:for-each>
	</table>
      </td>
      </tr>
      </table>
      </xsl:when>
      <xsl:otherwise>
          <h3>No Ejbs found in this application </h3>
      </xsl:otherwise>
      </xsl:choose>
      </br>

      <br>
      <xsl:choose>
      <xsl:when test="count(web-percentage) != 0">
      <table border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr> 
          <td> 
            <div class="table-title-text">Web Component Coverage </div>
          </td>
        </tr>
      </table>

      <table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
      <tr> 
      <td> 
        <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
          <tr class="header-row"> 
          <td colspan="2" width="100%"> 
              <div class="table-header-text" align="left">Status </div>
          </td>
          </tr>
          <tr height="1"> 
          <td class="line-row" colspan="2"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
          </tr>
	  <tr>
	  <xsl:variable name="web-percent" select="normalize-space(web-percentage)"/>
	  <xsl:choose>
	    <xsl:when test="$web-percent != '100'">
               <td width="35%" valign="top"> 
               <div class="table-failed-text"> <a href="webCoverage.html">Failed </a></div>
                </td>
               <td width="65%" valign="bottom"> 
               <div class="table-failed-text"> <xsl:value-of select="web-percentage"/>% of web components called </div>
                </td>
	    </xsl:when>
	    <xsl:otherwise>
	       <xsl:choose>
	       <xsl:when test="count(//web-component/web-entity/exception) != 0">
               <td width="35%" valign="top"> 
               <div class="table-failed-text"><a href="webCoverage.html">Failed </a></div>
                </td>
               <td width="65%" valign="bottom"> 
               <div class="table-failed-text"><xsl:value-of select="web-percentage"/>% of web components called, exceptions found </div>
                </td>
	       </xsl:when>
	       <xsl:otherwise>
               <td width="35%" valign="top"> 
               <div class="table-normal-text"><a href="webCoverage.html">Passed </a></div>
                </td>
               <td width="65%" valign="bottom"> 
               <div class="table-normal-text"><xsl:value-of select="web-percentage"/>% of web components called </div>
                </td>
	       </xsl:otherwise>
	       </xsl:choose>
	    </xsl:otherwise>
	  </xsl:choose>
	  </tr>
	</table>
      </td>
      </tr>
      </table>
      </xsl:when>
      <xsl:otherwise>
          <h3>No Web components found in this application </h3>
      </xsl:otherwise>
      </xsl:choose>
      </br>
  </xsl:template>

<xsl:template/>
</xsl:stylesheet>