/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.nodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.tree.TreePath;
import javax.xml.XMLConstants;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.model.api.BpelEntity;

import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeTreePathBuilderVisitor;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeLinkedToTargetTreeFinderVisitor;

import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewModel;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;

/**
 *
 * @author radval
 *
 */
public class NodeHelper {
    
    /**
     * find child SchemaNode  whose name is name and parentNode is passed.
     * @param parentNode parentNode
     * @param name name of child node
     * @param holdingEntity is bpel element which holds an expression that
     * include this parent\child node xpath expression.
     */
    public static TreeNode findSchemaNode(TreeNode parentNode, 
                                              String name, 
                                              BpelEntity holdingEntity) {
        if(name == null) {
            return null;
        }
        
        //create QName for example if it namespace qualified we would get xs:paramA
        //with out namespace we would get paramA
        int colonIdx = name.lastIndexOf(":");    //NOI18N
        String prefix = null;
        String localPart = null;
        if(colonIdx != -1) {
        	prefix = name.substring(0, colonIdx);
        	localPart = name.substring(colonIdx+1, name.length());
        } else {
        	//need use empty prefix
        	prefix= XMLConstants.DEFAULT_NS_PREFIX;
        	localPart = name;
        }
        
        QName elementQName = new QName(null, localPart, prefix);
        QName resultantElementQName = null;
        
        if(prefix != null && !prefix.equals(XMLConstants.DEFAULT_NS_PREFIX)) {
            //find the namespace for the prefix
            if(holdingEntity instanceof AbstractDocumentComponent) {
                AbstractDocumentComponent adc = (AbstractDocumentComponent) holdingEntity;
                String namespace = adc.lookupNamespaceURI(prefix);
                if(namespace != null) {
                    resultantElementQName = new QName(namespace, elementQName.getLocalPart());
                } 
            }
        } 
        
        if(resultantElementQName == null) {
            resultantElementQName = new QName(elementQName.getLocalPart());
        }
            
        List children = parentNode.getChildren();
        Iterator it = children.iterator();
        while(it.hasNext()) {
            TreeNode child = (TreeNode) it.next();
            if(child instanceof SchemaNode) {
            	SchemaNode sNode = (SchemaNode) child;
            	QName schemaQName = sNode.getQName();
                String ns = schemaQName.getNamespaceURI();
                String localName = schemaQName.getLocalPart();
                //if prefix is null then we just want to compare name
                if(prefix == null || prefix.equals(XMLConstants.DEFAULT_NS_PREFIX)) {
                    if(name.equals(localName)) {
	                return child;
	            }
                } else {
                    if(ns != null && ns.equals(resultantElementQName.getNamespaceURI())
                       && localName.equals(resultantElementQName.getLocalPart())) {
                        return child;
                    }
                }
	            
            }
            
        }
        
        return null;
    }
    
    
    private static IMapperTreeNode findTargetMapperTreeNode(TreeNode treeNode, IBasicViewModel viewModel) {
        IMapperTreeNode mapperTreeNode = null;
        NodeTreePathBuilderVisitor ntpBuilder = new NodeTreePathBuilderVisitor();
        treeNode.accept(ntpBuilder);
        TreePath treePath = ntpBuilder.getTreePath();
        List nodes = viewModel.getNodes();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            IMapperNode node = (IMapperNode) it.next();
            if (node instanceof IMapperTreeNode) {
                IMapperTreeNode iterTreeNode = (IMapperTreeNode) node;
                if (iterTreeNode.isDestTreeNode()) {
                    TreePath path = iterTreeNode.getPath();
                    Node tNode = (Node) path.getLastPathComponent();
                    if (tNode.equals(treeNode)) {
                        mapperTreeNode = iterTreeNode;
                        break;
                    }
                }
            }
        }
        
        return mapperTreeNode;
    }

    
    public static List findDirectLinksToTargetTree(
            Node node, IBasicViewModel viewModel) {
        List links = new ArrayList();
        List outputs = null;
        if (node instanceof CanvasNode) {
            outputs = ((CanvasNode) node).getOutputs();
        } else if (node instanceof TreeNode) {
            outputs = ((TreeNode) node).getConnectedOutputNodes();
        }
        Iterator it = outputs.iterator();
        while (it.hasNext()) {
            Node  outputNode = (Node) it.next();
            if(outputNode instanceof TreeNode) {
                IMapperNode sourceNode = node.getOutputFieldNode(outputNode);
                IMapperNode targetNode = findTargetMapperTreeNode((TreeNode)outputNode, viewModel);;
                List l = findLinksToTargetTree(sourceNode, targetNode);
                if (l != null) {
                    links.addAll(l);
                }
                
            }
        }
        
        return links;
    }
    
    
    public static List findSubsequentLinksToTargetTree(Node targetNodeOfALink,
            IBasicViewModel viewModel) {
        List links = new ArrayList();
        NodeLinkedToTargetTreeFinderVisitor nlttFinder = new NodeLinkedToTargetTreeFinderVisitor();
        targetNodeOfALink.accept(nlttFinder);
        List nodes = nlttFinder.getNodes();
        Iterator it = nodes.iterator();
        while(it.hasNext()) {
            Node  nodeConnectedToTree = (Node) it.next();
            List l = findLinksToTargetTree(nodeConnectedToTree, viewModel);
            if (l != null) {
                links.addAll(l);
            }
        }
        
        return links;
    }
    
    
    private static List findLinksToTargetTree(
            Node nodeConnectedToTree,
            IBasicViewModel viewModel) {
        List links = new ArrayList();
        List outputs = null;
        if (nodeConnectedToTree instanceof CanvasNode) {
            outputs = ((CanvasNode) nodeConnectedToTree).getOutputs();
        } else if (nodeConnectedToTree instanceof TreeNode) {
            outputs = ((TreeNode) nodeConnectedToTree).getConnectedOutputNodes();
        }
        Iterator it = outputs.iterator();
        while(it.hasNext()) {
            Node node = (Node) it.next();
            if(node instanceof TreeNode) {
                TreeNode treeNode = (TreeNode) node;
                IMapperNode targetNode = findTargetMapperTreeNode(treeNode, viewModel);
                IMapperNode sourceNode = nodeConnectedToTree.getOutputFieldNode(treeNode);
                List l = findLinksToTargetTree(sourceNode, targetNode);
                if (l != null) {
                    links.addAll(l);
                }
            }
        }
        
        return links;
    }
    
    
    private static List findLinksToTargetTree(IMapperNode sourceNode, IMapperNode targetNode) {
        if (sourceNode != null && targetNode != null) {
            List matchingLinks = new ArrayList();
            List links = targetNode.getLinks();
            Iterator it = links.iterator();
            while (it.hasNext()) {
                IMapperLink link = (IMapperLink) it.next();
                if (sourceNode.equals(link.getStartNode()) && targetNode.equals(link.getEndNode())) {
                    matchingLinks.add(link);
                }
            }
            return matchingLinks;
        }
        return null;
    }
}
