/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.expression.impl;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.netbeans.modules.bpel.xpath.model.node.visitor.ValidateVisitor;
import org.netbeans.modules.bpel.xpath.model.node.visitor.XPathGeneratorVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.RootPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.view.impl.PredicateXPathExpressionView;
import org.netbeans.modules.bpel.xpath.view.visitor.PredicateLocationStepLocatorVisitor;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeView;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.LocationStep;
import org.netbeans.modules.xml.xpath.XPathException;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathModel;
import org.openide.util.NbBundle;


/**
 *
 * @author Ravi Shankar
 * @version 
 */
public class PredicateMapperDialog extends JDialog {
    
    private static final Logger LOGGER = Logger.getLogger(PredicateMapperDialog.class.getName());

    private PredicateXPathExpressionView mView;
    private MapperView mMapper;
    private Node mStepNodeSource;
    private LocationStep mLocationStep;
    
    
    public PredicateMapperDialog(Frame owner, PredicateXPathExpressionView view, Node stepNodeSource) {
        super(owner);
        mView = view;
        mMapper = view.getMapperView();
        mStepNodeSource = stepNodeSource;
        
        init();
        
        pack();
        
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = getSize();
        setLocation(
                (screenSize.width  - windowSize.width)  / 2,
                (screenSize.height - windowSize.height) / 2);
    }
    
    
    private void init() {
        setTitle(NbBundle.getMessage(getClass(), "STR_PREDICATE_DLG_TITLE"));   // NOI18N
        setModal(true);
        
        JButton okButton = new JButton(
                NbBundle.getMessage(PredicateMapperDialog.class, "PredicateMapperDialog_OK"));  // NOI18N
        JButton cancelButton = new JButton(
                NbBundle.getMessage(PredicateMapperDialog.class, "PredicateMapperDialog_CANCEL"));  // NOI18N
        Dimension size = cancelButton.getPreferredSize();
        okButton.setMinimumSize(size);
        okButton.setMaximumSize(size);
        okButton.setPreferredSize(size);
        JPanel btnPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
        btnPanel.add(okButton);
        btnPanel.add(cancelButton);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(mView.getComponent(), BorderLayout.CENTER);
        panel.add(btnPanel, BorderLayout.SOUTH);
        
        getContentPane().add(panel);
        
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent actionEvent) {
                applyChanges();
            }
        });
        
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent actionEvent) {
                dispose();
            }
        });
        
        getRootPane().setDefaultButton(okButton);
    }
    
    public void applyChanges() {
        IMapperTreeView destView = mMapper.getMapperViewManager().getDestView();
        TreeNode targetTreeNode = null;
        RootPlaceHolderNode root = (RootPlaceHolderNode) destView.getTree().getModel().getRoot();
        Iterator it = root.getChildren().iterator();
        if (it.hasNext()) {
            targetTreeNode = (TreeNode) it.next();
        }
        
        String validationErrors = validateConnections(targetTreeNode);
        if (validationErrors == null) {
            List inputs = targetTreeNode.getConnectedInputNodes();
            List expressions = new ArrayList();
            for (Iterator iter=inputs.iterator(); iter.hasNext();) {
                Node input = (Node) iter.next();
                String expression = generateXPath(input);
                if (expression != null) {
                    expressions.add(expression);
                }
            }
            mLocationStep = generateLocationStep(mStepNodeSource, expressions);
            if (mLocationStep != null) {
                dispose();
            }
            
        } else {
            JOptionPane.showMessageDialog(
                    this,
                    validationErrors,
                    NbBundle.getMessage(getClass(), "STR_INVALID_PREDICATE_TITLE"), // NOI18N
                    JOptionPane.ERROR_MESSAGE);
        }
    }
    
    private String validateConnections(Node node) {
        ValidateVisitor validator = new ValidateVisitor();
        node.accept(validator);
        return validator.getValidationErrors();
    }
    
    public LocationStep getLocationStep() {
        return mLocationStep;
    }
    
    private String generateXPath(Node input) {
        XPathGeneratorVisitor generator = new XPathGeneratorVisitor(mMapper.getBPELDocument().getProcess());
        input.accept(generator);
        return generator.getXPath();
    }
    
    private LocationStep generateLocationStep(Node node, List predicateExpressions) {
        String sourceExpression = generateXPath(node);
        // take the original expression and add the new predicate section(s) (wrap with [])
        StringBuffer buf = new StringBuffer();
        buf.append(sourceExpression);
        for (Iterator iter=predicateExpressions.iterator(); iter.hasNext();) {
            String iterExpression = (String) iter.next();
            buf.append(
                    PredicatesManager.PREDICATE_BEGIN + 
                    iterExpression + 
                    PredicatesManager.PREDICATE_END);
        }
        String wholeExpression = buf.toString();
        
        XPathModel xpImpl = AbstractXPathModelHelper.getInstance().newXPathModel();
        XPathExpression result = null;
        
        try {
            result = xpImpl.parseExpression(wholeExpression);
        } catch (XPathException xpe) {
            JLabel textComponent = new JLabel("<HTML>" + xpe.getMessage() + "</HTML>"); // NOI18N
            JOptionPane pane = new JOptionPane(
                    textComponent, 
                    JOptionPane.ERROR_MESSAGE, 
                    JOptionPane.DEFAULT_OPTION);
            JDialog dialog = pane.createDialog(
                    this, 
                    NbBundle.getMessage(getClass(), "STR_INVALID_PREDICATE_TITLE"));    // NOI18N
            dialog.setResizable(true);
            dialog.setSize(500, 200);
            dialog.setVisible(true);
            return null;
        }
        
        PredicateLocationStepLocatorVisitor visitor = new PredicateLocationStepLocatorVisitor();
        result.accept(visitor);
        return visitor.getLocationStep();
    }
}
