
/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * NamespacePanel.java
 *
 * Created on December 20, 2005, 5:49 PM
 */

package org.netbeans.modules.compapp.casaeditor.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.namespace.QName;
import org.netbeans.modules.compapp.casaeditor.properties.NamespaceEditor.PrefixNamespacePair;
import org.openide.util.NbBundle;

/**
 * Modified from SchemaUI.
 * @author Todd Fast, todd.fast@sun.com
 */
public class NamespaceEditorPanel extends JPanel
implements ActionListener, ListSelectionListener, DocumentListener {

    static final long serialVersionUID = 1L;
    
    public static final String PROP_VALID_SELECTION="validSelection";
    
    private boolean isValid = true;
    private Collection<PrefixNamespacePair> mURIs;
    
    
    public NamespaceEditorPanel(
            QName currentTns, 
            Collection<PrefixNamespacePair> uris, 
            Collection<NamespaceEditor.Option> options)
    {
        mURIs = uris;
        initComponents();        
        initialize(currentTns, options);        
        // Add document listeners after initialization!
        // This is to make sure property change event caused by validation 
        // checking doesn't get lost/filtered.
        initializeCustomListeners();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        schemaNamespaceRadioButton = new javax.swing.JRadioButton();
        otherNamespaceRadioButton = new javax.swing.JRadioButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        uriList = new javax.swing.JList();
        otherNamespaceTextField = new javax.swing.JTextField();
        dummyLabel1 = new javax.swing.JLabel();
        dummyLabel2 = new javax.swing.JLabel();
        namespaceEntryLabel = new javax.swing.JLabel();
        prefixEntryLabel = new javax.swing.JLabel();
        prefixTextField = new javax.swing.JTextField();
        localNameEntryLabel = new javax.swing.JLabel();
        localNameTextField = new javax.swing.JTextField();
        prefixErrorLabel = new javax.swing.JLabel();
        uriListLabel = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(schemaNamespaceRadioButton, org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "LBL_SchemaNamespace")); // NOI18N
        schemaNamespaceRadioButton.setToolTipText(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "HINT_SchemaNamespace")); // NOI18N
        schemaNamespaceRadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        schemaNamespaceRadioButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        buttonGroup1.add(schemaNamespaceRadioButton);
        schemaNamespaceRadioButton.addActionListener(this);

        org.openide.awt.Mnemonics.setLocalizedText(otherNamespaceRadioButton, org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "LBL_OtherNamespace")); // NOI18N
        otherNamespaceRadioButton.setToolTipText(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "HINT_OtherNamespace")); // NOI18N
        otherNamespaceRadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        otherNamespaceRadioButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        buttonGroup1.add(otherNamespaceRadioButton);
        otherNamespaceRadioButton.addActionListener(this);

        uriList.addListSelectionListener(this);
        jScrollPane1.setViewportView(uriList);
        uriList.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSN_NameSpacesList")); // NOI18N
        uriList.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSD_NameSpacesListDescription")); // NOI18N

        namespaceEntryLabel.setLabelFor(otherNamespaceTextField);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/compapp/casaeditor/properties/Bundle"); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(namespaceEntryLabel, bundle.getString("LBL_NamespaceEntry")); // NOI18N

        prefixEntryLabel.setLabelFor(prefixTextField);
        org.openide.awt.Mnemonics.setLocalizedText(prefixEntryLabel, bundle.getString("LBL_PrefixEntry")); // NOI18N

        prefixTextField.setToolTipText(bundle.getString("HINT_Prefix")); // NOI18N

        localNameEntryLabel.setLabelFor(localNameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(localNameEntryLabel, bundle.getString("LBL_LocalNameEntry")); // NOI18N

        localNameTextField.setToolTipText(bundle.getString("HINT_LocalName")); // NOI18N

        prefixErrorLabel.setForeground(new java.awt.Color(255, 0, 0));

        uriListLabel.setLabelFor(uriList);
        org.openide.awt.Mnemonics.setLocalizedText(uriListLabel, "List of pre-existing Namespaces:");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, dummyLabel1)
                            .add(layout.createSequentialGroup()
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(otherNamespaceRadioButton)
                                    .add(layout.createSequentialGroup()
                                        .add(17, 17, 17)
                                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                            .add(layout.createSequentialGroup()
                                                .add(prefixEntryLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                                .add(prefixTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 56, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                                .add(225, 225, 225))
                                            .add(layout.createSequentialGroup()
                                                .add(namespaceEntryLabel)
                                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                                .add(otherNamespaceTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 281, Short.MAX_VALUE)))))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(prefixErrorLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .add(layout.createSequentialGroup()
                                .add(schemaNamespaceRadioButton)
                                .add(22, 22, 22)
                                .add(dummyLabel2)
                                .add(151, 151, 151))
                            .add(layout.createSequentialGroup()
                                .add(localNameEntryLabel)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(localNameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 324, Short.MAX_VALUE))
                            .add(layout.createSequentialGroup()
                                .add(17, 17, 17)
                                .add(uriListLabel))))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(27, 27, 27)
                        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 365, Short.MAX_VALUE)))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {namespaceEntryLabel, prefixEntryLabel}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(11, 11, 11)
                .add(dummyLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(dummyLabel2)
                    .add(localNameEntryLabel)
                    .add(localNameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(schemaNamespaceRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(uriListLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 124, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(42, 42, 42)
                        .add(prefixErrorLabel))
                    .add(layout.createSequentialGroup()
                        .add(18, 18, 18)
                        .add(otherNamespaceRadioButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                            .add(namespaceEntryLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(otherNamespaceTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(prefixEntryLabel)
                            .add(prefixTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(32, Short.MAX_VALUE))
        );

        schemaNamespaceRadioButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSN_PreExsitingNameSpace")); // NOI18N
        schemaNamespaceRadioButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSD_PreExisitngNameSpace")); // NOI18N
        otherNamespaceRadioButton.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSN_NewNameSpace")); // NOI18N
        otherNamespaceRadioButton.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSD_NewNameSpace")); // NOI18N
        otherNamespaceTextField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "HINT_OtherNamespace")); // NOI18N
        otherNamespaceTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "HINT_OtherNamespace")); // NOI18N
        namespaceEntryLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSN_NameSpaceURI")); // NOI18N
        namespaceEntryLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSD_NameSpaceURI")); // NOI18N
        prefixEntryLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSN_Prefix")); // NOI18N
        prefixEntryLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSD_Prefix")); // NOI18N
        prefixTextField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSN_PrefixEditor")); // NOI18N
        prefixTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSD_PrefixEditor")); // NOI18N
        localNameEntryLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ASCN_LocalName")); // NOI18N
        localNameEntryLabel.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSD_LocalName")); // NOI18N
        localNameTextField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ASCN_LocalNameEditor")); // NOI18N
        localNameTextField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NamespaceEditorPanel.class, "ACSD_LocalNameEditor")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents


    private void initializeCustomListeners() {
        localNameTextField.getDocument().addDocumentListener(this);
        prefixTextField.getDocument().addDocumentListener(this);
        otherNamespaceTextField.getDocument().addDocumentListener(this);
    }
    
    private void initialize(
            QName currentTns, 
            Collection<NamespaceEditor.Option> options)
    {
        PrefixNamespacePair currentPairing = null;
        if (currentTns != null) {
            currentPairing = new PrefixNamespacePair(
                    currentTns.getPrefix(), 
                    currentTns.getNamespaceURI());
        }
        
        // hide radio button for uri list and uri list
        if (mURIs == null || mURIs.isEmpty()) {
            schemaNamespaceRadioButton.setVisible(false);
            uriList.setVisible(false);
            jScrollPane1.setVisible(false);
        } else {
            uriList.setListData(mURIs.toArray(new PrefixNamespacePair[mURIs.size()]));
        }
        if(currentTns==null) {
            uriList.setEnabled(false);
            if (otherNamespaceRadioButton.isVisible()) {
                otherNamespaceRadioButton.setSelected(true);
                otherNamespaceTextField.setEnabled(true);
                prefixTextField.setEnabled(true);
            }
        } else if (mURIs != null && mURIs.contains(currentPairing)) {
            localNameTextField.setText(currentTns.getLocalPart());
            schemaNamespaceRadioButton.setSelected(true);
            uriList.setSelectedValue(currentPairing,true);
            uriList.setEnabled(true);
            otherNamespaceTextField.setEnabled(false);
            prefixTextField.setEnabled(false);
        } else {
            uriList.setEnabled(false);
            if(otherNamespaceRadioButton.isVisible()) {
                otherNamespaceRadioButton.setSelected(true);
                otherNamespaceTextField.setText(currentTns.getNamespaceURI());
                localNameTextField.setText(currentTns.getLocalPart());
                otherNamespaceTextField.setEnabled(true);
                prefixTextField.setEnabled(true);
            }
        }
    }
        
    public void setEditable(boolean isEditable) {
        schemaNamespaceRadioButton.setEnabled(isEditable);
        otherNamespaceRadioButton.setEnabled(isEditable);
        uriList.setEnabled(isEditable);
        localNameTextField.setEditable(isEditable);
        prefixTextField.setEditable(isEditable);
        otherNamespaceTextField.setEditable(isEditable);
    }
    
    public void checkValidity() {
        boolean newValue = false;
        if (schemaNamespaceRadioButton.isSelected()) {
            newValue = 
                localNameTextField.getText().trim().length() > 0 &&
                uriList.getSelectedValue() != null;

        } else if (otherNamespaceRadioButton.isSelected()) {
            newValue = 
                localNameTextField.getText().trim().length() > 0      &&
                otherNamespaceTextField.getText().trim().length() > 0 &&
                prefixTextField.getText().trim().length() > 0;
            newValue = newValue && !isDuplicatePrefix();

        }
        firePropertyChange(PROP_VALID_SELECTION, isValid, newValue);
        isValid = newValue;
    }

    private boolean isDuplicatePrefix() {
        boolean isDuplicatePrefix = false;
        String prefix = prefixTextField.getText().trim();
        if (prefix.length() > 0) {
            for (PrefixNamespacePair pair : mURIs) {
                if (prefix.equals(pair.getPrefix())) {
                    isDuplicatePrefix = true;
                    break;
                }
            }
            if (isDuplicatePrefix) {
                prefixErrorLabel.setText(NbBundle.getMessage(getClass(), "LBL_PrefixAlreadyExists"));

            } else {
                prefixErrorLabel.setText("");
            }
        }
        return isDuplicatePrefix;
    }
    
    public QName getCurrentSelection() {
        if (schemaNamespaceRadioButton.isSelected()) {
            PrefixNamespacePair selectedPair = 
                    (PrefixNamespacePair) uriList.getSelectedValue();
            return new QName(
                    selectedPair.getNamespace(), 
                    localNameTextField.getText().trim(), 
                    selectedPair.getPrefix());
        } else if (otherNamespaceRadioButton.isSelected()) {
            return new QName(
                    otherNamespaceTextField.getText().trim(), 
                    localNameTextField.getText().trim(), 
                    prefixTextField.getText().trim());
        }
        return null;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source.equals(otherNamespaceRadioButton)) {
            uriList.setEnabled(false);
            otherNamespaceTextField.setEnabled(true);
            prefixTextField.setEnabled(true);
        } else if(source.equals(schemaNamespaceRadioButton)) {
            otherNamespaceTextField.setEnabled(false);
            prefixTextField.setEnabled(false);
            uriList.setEnabled(true);
        }
        checkValidity();
    }

    public void valueChanged(ListSelectionEvent e) {
        checkValidity();
    }

    public void insertUpdate(DocumentEvent e) {
        checkValidity();
    }

    public void removeUpdate(DocumentEvent e) {
        checkValidity();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.ButtonGroup buttonGroup1;
    public javax.swing.JLabel dummyLabel1;
    public javax.swing.JLabel dummyLabel2;
    public javax.swing.JScrollPane jScrollPane1;
    public javax.swing.JLabel localNameEntryLabel;
    public javax.swing.JTextField localNameTextField;
    public javax.swing.JLabel namespaceEntryLabel;
    public javax.swing.JRadioButton otherNamespaceRadioButton;
    public javax.swing.JTextField otherNamespaceTextField;
    public javax.swing.JLabel prefixEntryLabel;
    public javax.swing.JLabel prefixErrorLabel;
    public javax.swing.JTextField prefixTextField;
    public javax.swing.JRadioButton schemaNamespaceRadioButton;
    public javax.swing.JList uriList;
    public javax.swing.JLabel uriListLabel;
    // End of variables declaration//GEN-END:variables

}
