package it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.validator;

import it.imolinfo.jbi4corba.netbeansplugin.wsdlextension.CorbaQName;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.modules.xml.wsdl.validator.spi.ValidatorSchemaFactory;

public class CorbaValidatorSchemaFactory extends ValidatorSchemaFactory {

    private static final String FILE_XSD_URL
            = "/it/imolinfo/jbi4corba/netbeansplugin/wsdlextension/resources/corba-ext.xsd";

    public CorbaValidatorSchemaFactory() {
    }

    public String getNamespaceURI() {
        return CorbaQName.CORBA_NS_URI;
    }

    public InputStream getSchemaInputStream() {
        return CorbaValidatorSchemaFactory.class.getResourceAsStream(FILE_XSD_URL);
    }

    /**
     * Returns the Inputstream related to this schema
     */
    public Source getSchemaSource() {
        Class clazz = CorbaValidatorSchemaFactory.class;
        InputStream in = clazz.getResourceAsStream(FILE_XSD_URL);
        Source s = new StreamSource(in);

        s.setSystemId(clazz.getResource(FILE_XSD_URL).toString());
        return s;
    }
}
