/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.wlm.model.impl;

import java.util.List;

import org.netbeans.modules.wlm.model.api.Group;
import org.netbeans.modules.wlm.model.api.Role;
import org.netbeans.modules.wlm.model.api.TAssignment;
import org.netbeans.modules.wlm.model.api.User;
import org.netbeans.modules.wlm.model.api.WLMComponent;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.wlm.model.api.WLMVisitor;

import org.w3c.dom.Element;

public class AssignmentImpl extends ExpressionImpl implements TAssignment {

	public AssignmentImpl(WLMModel model, Element e) {
		super(model, e);
		// TODO Auto-generated constructor stub
	}

	public AssignmentImpl(WLMModel model) {
		this(model, createNewElement(WLMQNames.ASSIGNMENT.getQName(), model));
	}

	public void addGroup(Group group) {
		// TODO Auto-generated method stub
		addAfter(GROUP_PROPERTY, group, TypeCollection.FOR_ASSIGNMENT_GROUP.types());
	}

	public void addRole(Role role) {
		// TODO Auto-generated method stub
		addAfter(ROLE_PROPERTY, role, TypeCollection.FOR_ASSIGNMENT_ROLE.types());
	}

	public void addUser(User user) {
		// TODO Auto-generated method stub
		addAfter(USER_PROPERTY, user, TypeCollection.FOR_ASSIGNMENT_USER.types());
	}

	public List<Group> getGroups() {
		// TODO Auto-generated method stub
		return getChildren(Group.class);
	}

	public List<Role> getRoles() {
		// TODO Auto-generated method stub
		return getChildren(Role.class);
	}

	public List<User> getUsers() {
		// TODO Auto-generated method stub
		return getChildren(User.class);
	}

	public void removeGroup(Group group) {
		// TODO Auto-generated method stub
		removeChild(GROUP_PROPERTY, group);
	}

	public void removeRole(Role role) {
		// TODO Auto-generated method stub
		removeChild(ROLE_PROPERTY, role);
	}

	public void removeUser(User user) {
		// TODO Auto-generated method stub
		removeChild(USER_PROPERTY, user);
	}

	public void accept(WLMVisitor visitor) {
		// TODO Auto-generated method stub
		visitor.visitAssignment(this);
	}

	public WLMComponent createChild(Element childEl) {
		// TODO Auto-generated method stub
		WLMComponent child = null;
		if (childEl != null) {
			String localName = childEl.getLocalName();
			if (localName == null || localName.length() == 0) {
				localName = childEl.getTagName();
			}
			if (localName.equals(USER_PROPERTY)) {
				child = new UserImpl(getModel(), childEl);
			} else if (localName.equals(GROUP_PROPERTY)) {
				child = new GroupImpl(getModel(), childEl);
			} else if (localName.equals(ROLE_PROPERTY)) {
				child = new RoleImpl(getModel(), childEl);
			}
		}
		return child;
	}

}
