/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringElementSupport;
import org.netbeans.modules.j2ee.refactoring.jaxwssupport.JaxWsXmlRefactoringSupport;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/**
 * This class handles renaming of a webservice imlementation class
 * in jax-ws.xml (handles only webservices from WSDL file, other types
 * of webservices are supported through other means).
 *
 * @author Erno Mononen
 */
public class JaxWsXmlMoveClassRefactoring extends JaxWsXmlRefactoringSupport {
    
    /**
     * Creates a new instance of JaxWsMoveClassRefactoring
     */
    public JaxWsXmlMoveClassRefactoring() {
    }
    
    /**
     * Finds uages in jax-ws.xml
     */
    public Problem prepare(MoveClassRefactoring moveClassRefactor,
            Collection resources, RefactoringElementsBag refactoringElements) {
        
        for (Iterator it = resources.iterator(); it.hasNext();) {
            Resource elem = (Resource) it.next();
            
            for (Iterator it2 = elem.getClassifiers().iterator(); it2.hasNext();) {
                JavaClass javaClass = (JavaClass) it2.next();
                
                JaxWsModel model = getModel(javaClass);
                if (model == null){
                    // no jax-ws.xml in the project
                    return null;
                }
                if (!isWebSvcFromWsdl(javaClass)){
                    continue;
                }
                
                String newName = moveClassRefactor.getTargetPackageName(elem) + "." + javaClass.getSimpleName();
                Service service = model.findServiceByImplementationClass(javaClass.getName());
                if (service != null){
                    RefactoringElementImplementation refactoringElem =
                            new JaxWsXmlMoveClassRefactoringElement(javaClass.getName(), newName, model, service, model.getJaxWsFile());
                    
                    refactoringElements.add(moveClassRefactor, refactoringElem);
                    
                }
            }
        }
        
        return null;
    }
    
    /**
     * Move class refactoring element for jax-ws.xml
     */
    private static class JaxWsXmlMoveClassRefactoringElement extends JaxWsXmlRefactoringElementSupport {
        
        /**
         * Creates a new instance of JaxWsXmlMoveClassRefactoringElement
         * @param oldName the fully qualified old name of the implementation class
         * @param newName the fully qualified new name of the implementation class
         * @service the service whose implementation class is to be renamed
         * @parentFile the file object representing jax-ws.xml
         */
        public JaxWsXmlMoveClassRefactoringElement(String oldName,  String newName,
                JaxWsModel model, Service service, FileObject parentFile) {
            super(oldName, newName, model, service, parentFile);
        }
        
        /**
         * Returns text describing the refactoring formatted for display (using HTML tags).
         * @return Formatted text.
         */
        public String getDisplayText() {
            Object[] args = new Object [] {parentFile.getNameExt(), oldName, newName};
            return MessageFormat.format(NbBundle.getMessage(JaxWsXmlMoveClassRefactoring.class, "TXT_JaxWsXmlMoveClass"), args);
        }
        
    }
    
}
