/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disc cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <sys/types.h>
#include <time.h>
#include <limits.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>

#include "indexdb.h"
#include "nls.h"

#ifdef WORDS_BIGENDIAN
#define COPY_INT32(i1,i2) \
	((char *)(i1))[0] = ((char *)(i2))[3];\
	((char *)(i1))[1] = ((char *)(i2))[2];\
	((char *)(i1))[2] = ((char *)(i2))[1];\
	((char *)(i1))[3] = ((char *)(i2))[0];
#define COPY_TIMET(i1,i2) \
{\
	int idx;\
	for (idx = 0 ; idx < sizeof(time_t) ; idx++)\
	{\
		((char *)(i1))[idx] = ((char *)(i2))[sizeof(time_t)-1-idx];\
	}\
}
#else
#define COPY_INT32(i1,i2)  *((int32 *) i1) = *((int32 *) i2);
#define COPY_TIMET(i1,i2)  *((time_t *) i1) = *((time_t *) i2);
#endif


static char *ns_cache_db_name = NULL;
static DB *ns_cache_db = NULL;

void ns_cache_gen_key(key , urlstr)
DBT *key;
char *urlstr;
{
	int32 length, size;
	char *tmp;

	size = sizeof(int32); 		/* check sum */
	size += sizeof(int32);		/* size of urlstr */
	size += strlen(urlstr)+1;	/* urlstr */
	size += sizeof(int32);		/* post data */

	key->size = size;
	key->data = (void *)malloc(size);

	tmp = key->data;

	COPY_INT32(tmp, &key->size);
	tmp += sizeof(int32);

	length = strlen(urlstr) + 1;
	COPY_INT32(tmp, &length);
	tmp += sizeof(int32);

	strcpy(tmp , urlstr);
	tmp += strlen(urlstr)+1;

	*(int32 *)tmp = 0;
	tmp += sizeof(int32);
}

ns_cache_record *ns_cache_dbt_to_record(data)
DBT *data;
{
	ns_cache_record *ret;
	char *tmp = data->data;
	int32 slen, size;
	
	COPY_INT32(&size, tmp);
	if(data->size != size) return NULL;
	
	ret = (ns_cache_record *) malloc(sizeof(ns_cache_record));
	memset(ret , '\0' , sizeof(ns_cache_record));

	COPY_INT32(&ret->size, tmp);
	tmp += sizeof(int32);

	COPY_INT32(&ret->version, tmp);
	tmp += sizeof(int32);
	
	COPY_TIMET(&ret->last_modified, tmp);
	tmp += sizeof(time_t);

	COPY_TIMET(&ret->last_accessed, tmp);
	tmp += sizeof(time_t);

	COPY_TIMET(&ret->expires, tmp);
	tmp += sizeof(time_t);

	COPY_INT32(&ret->content_length, tmp);
	tmp += sizeof(uint32);

	ret->is_netsite = *(bool *)tmp;
	tmp += sizeof(bool);

	COPY_TIMET(&ret->lock_date, tmp);
	tmp += sizeof(time_t);

	COPY_INT32(&slen, tmp);
	tmp += sizeof(int32);

	ret->filename = slen ? strdup(tmp) : NULL;
	tmp += slen;

	COPY_INT32(&ret->filename_len, tmp);
	tmp += sizeof(int32);

	ret->is_relative_path = *(bool *)tmp;
	tmp += sizeof(bool);

	COPY_INT32(&ret->security_on, tmp);
	tmp += sizeof(int32);

	COPY_INT32(&slen, tmp);
	tmp += sizeof(int32);

	ret->sec_info = slen ? strdup(tmp) : NULL;
	tmp += slen;

	COPY_INT32(&ret->method, tmp);
        tmp += sizeof(int32);

	COPY_INT32(&slen, tmp);
	tmp += sizeof(int32);

	ret->address = slen ? strdup(tmp) : NULL;
		tmp += slen;

	if (ret->version == 4)
	{

		COPY_INT32(&ret->post_data_size, tmp);
		tmp += sizeof(uint32);

		if  (ret->post_data_size)
		{
			ret->post_data = malloc(ret->post_data_size+1);
			memcpy(ret->post_data , tmp , ret->post_data_size+1);
			tmp += ret->post_data_size;
		}

		COPY_INT32(&slen, tmp);
		tmp += sizeof(int32);

		ret->post_headers = slen ? strdup(tmp) : NULL;
		tmp += slen;

		tmp += 4;
	}

	COPY_INT32(&slen, tmp);
	tmp += sizeof(int32);

	ret->content_type = slen ? strdup(tmp) : NULL;
	tmp += slen;

	COPY_INT32(&slen, tmp);
	tmp += sizeof(int32);

	ret->content_encoding = slen ? strdup(tmp) : NULL;
	tmp += slen;

	COPY_INT32(&slen, tmp);
	tmp += sizeof(int32);

	ret->charset = slen ? strdup(tmp) : NULL;
	tmp += slen;

	ret->incomplete_file = *(bool *)tmp;
	tmp += sizeof(bool);

	COPY_INT32(&ret->total_content_length, tmp);
	tmp += sizeof(uint32);

	COPY_INT32(&slen, tmp);
	tmp += sizeof(int32);

	ret->page_services_url = slen ? strdup(tmp) : NULL;
	tmp += slen;

	return ret;
}

int ns_cache_open_db(name)
char *name;
{
	HASHINFO hash_info = {
		4*1024,  /* bucket size */
		0,        /* fill factor */
		0,        /* number of elements */
		96*1024,  /* bytes to cache */
		0,        /* hash function */
		0};       /* byte order */


	ns_cache_db = dbopen(name, O_RDWR , 0600 , DB_HASH , &hash_info);
	if (!ns_cache_db && ((errno == 13) || (errno == 30)))
	{
		/* if "Permission denied" or "Read-only file system" */
		/* try at least reading it.                          */
		ns_cache_db = dbopen(name, O_RDONLY , 0600 , DB_HASH , &hash_info);

	}

	if (ns_cache_db)
	{
		if (ns_cache_db_name)
			g_free(ns_cache_db_name);
	}

	ns_cache_db_name = g_strdup(name);

	return !ns_cache_db;
}

char *ns_cache_get_db_name()
{
	return ns_cache_db_name;
}

void ns_cache_close_db()
{
	ns_cache_db->close(ns_cache_db);
}

GSList *ns_cache_read_db()
{
	GSList *retv = NULL;
	DBT key,data;

	while (!ns_cache_db->seq(ns_cache_db , &key , &data , R_NEXT))
	{
		ns_cache_record *nr = ns_cache_dbt_to_record(&data);
		if (nr)
		{
			nr->urlstr = g_strdup(((char *)key.data) + 8);
			nr->list_row = 0;
			nr->tree_node = NULL;

			retv = g_slist_prepend(retv , nr);
		}
	}

	return retv;
}

void ns_cache_free_record(rec)
ns_cache_record *rec;
{
	if (rec->filename) free(rec->filename);
	if (rec->sec_info) free(rec->sec_info);
	if (rec->address) free(rec->address);
	if (rec->post_data) free(rec->post_data);
	if (rec->post_headers) free(rec->post_headers);
	if (rec->content_type) free(rec->content_type);
	if (rec->content_encoding) free(rec->content_encoding);
	if (rec->charset) free(rec->charset);
	if (rec->page_services_url) free(rec->page_services_url);
	if (rec->etag) free(rec->etag);
	if (rec->urlstr) free(rec->urlstr);

	free(rec);
}

int ns_cache_del_rec(url)
char *url;
{
	DBT key;
	int s;

	ns_cache_gen_key(&key , url);

	s = ns_cache_db->del(ns_cache_db , &key , R_CURSOR);

	free(key.data);

	return s;
}

void ns_cache_dump(short_list)
int short_list;
{
	GSList *ptr;

	ptr = ns_cache_read_db();

	while(ptr)
	{
		ns_cache_record *rec;

		rec = (ns_cache_record *)ptr->data;

		if (short_list)
			printf("%s\t%s\n", rec->filename, rec->urlstr);
		else
		{
			char pom[256];
			struct tm *tm;

			printf(gettext("File: %s\n"), rec->filename);
			printf(gettext("\tURL: %s\n"), rec->urlstr);
			printf(gettext("\tMIME type: %s\n"), rec->content_type);
			printf(gettext("\tSize: %d\n"), rec->total_content_length);
			printf(gettext("\tEncoding: %s\n"), rec->content_encoding ? rec->content_encoding : "");
			printf(gettext("\tCharacter set: %s\n"), rec->charset ? rec->charset : "");
			tm =  localtime(&rec->last_modified);
			strftime(pom, sizeof(pom), "%H:%M %d.%m.%Y", tm);
			printf(gettext("\tModification time: %s\n"), pom);
			tm =  localtime(&rec->last_accessed);
			strftime(pom, sizeof(pom), "%H:%M %d.%m.%Y", tm);
			printf(gettext("\tAccess time: %s\n"), pom);
			if (rec->expires)
			{
				tm =  localtime(&rec->expires);
				strftime(pom, sizeof(pom), "%H:%M %d.%m.%Y", tm);
			}
			else
				pom[0] = '\0';
			printf(gettext("\tExpiration time: %s\n"), pom);
		}
		ptr = g_slist_remove_link(ptr, ptr);
	}
}

