// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/cg_helper.cpp,v 1.3 2001/11/02 01:57:14 xhshi Exp $
//

#include "defines.h"
#include "orp_types.h"
#include "jit_runtime_support.h"
#include "jit_intf.h"
#include <iostream.h>
#include <stdarg.h>
#include "code_emitter.h"
#include "cg_prepass.h"
#include "operand.h"
#include "profiling.h"
#include "lazy_code_selector.h"
#include "register_manager.h"
#include "stack.h"
#include "cg_helper.h"

#ifndef NO_BOUNDS_CHECKING
#include "bounds_checking.h"
#endif // NO_BOUNDS_CHECKING

int gen_instanceof(Mem_Manager& mem_manager,
					Code_Emitter& emitter,
					Stack& stack,
					Code_Patch *& code_patch_list,
					Class_Handle class_handle,
                    Compile_Handle comp_handle,
					unsigned index,
					Jit_Method_Info *method_info,
					Frame &frame) {
	stack.call_home(1);
	//
	// get the class handle
	//
    Loader_Exception lexc;
	class_handle = resolve_class(comp_handle,class_handle,index,&lexc);
    if (!class_handle)
        return 1;

//#ifdef FAST_INSTOF
	int depth = class_get_depth(class_handle);
//#endif
	//
	// pop the arguments
	//
	Operand *obj_ref = stack.pop();

//#ifdef FAST_INSTOF
	if((class_get_flags(class_handle) & ACC_INTERFACE) ||
		class_get_name(class_handle)[0] == '[' ||
		(depth >= MAX_FAST_INSTOF_DEPTH)) {
//#endif
	void *addr = orp_get_rt_support_addr(ORP_RT_INSTANCEOF);
	emitter.emit_push(&Imm_Opnd((unsigned)class_handle));
    make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
	obj_ref->emit_push(emitter,1);
	obj_ref->free_opnd(&stack.reg_manager);
    make_esp_record(emitter.get_offset(),2,method_info,mem_manager);
	unsigned patch_offset = emitter.get_offset()+1;
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;
	emitter.emit_call((char*)addr);
    method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0x2; // outarg 1 is a ref
    method_info->cs_info[method_info->cnt].m_handle = NULL;
    method_info->cs_info[method_info->cnt++].num_out_args = 2;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
	//
	// push the return value
	//
    stack.push(stack.reg_manager.get_reg(eax_reg));
//#ifdef FAST_INSTOF
	} else {
	    Reg_Operand *reg;
		reg = stack.reg_manager.get_reg();
		assert(reg);
		obj_ref->emit_mov_to_reg(emitter,&reg->opnd);
		obj_ref = reg;
		R_Opnd *reg_opnd = &((Reg_Operand*)obj_ref)->opnd;
		X86_Reg_No reg_no = reg_opnd->reg_no();

		emitter.emit_test(reg_opnd, reg_opnd);
		emitter.emit_branch8(cc_eq, &Imm_Opnd((unsigned)0), 0);
		int br_off1 = emitter.get_offset();
		char *br_patch1 = emitter.get_next() - 1;
		//
		// For statistics, inserting instruments
		//
		if(inner_statistics){
			assert(emitter.prof_rec) ;
			inner_bb_instrumenting_code(emitter,
				(unsigned*)&((PROF_COUNTER*)&((unsigned short*)&emitter.prof_rec->back_edge[emitter.prof_rec->n_back_edge])[emitter.prof_rec->n_back_edge])[emitter.inner_bb_cnt_offset++]);
		}

		M_Base_Opnd vtable(reg_no, 0);
		emitter.emit_mov(&((Reg_Operand*)obj_ref)->opnd, &vtable);
		int offset = vtable_get_super_array_offset() + (depth - 1) * sizeof(void *);
		M_Base_Opnd superarray_element(reg_no, offset);
		emitter.emit_alu(cmp_opc, &superarray_element, &Imm_Opnd((unsigned)class_handle));
		emitter.emit_mov(reg_opnd, &Imm_Opnd(1));
		emitter.emit_branch8(cc_eq, &Imm_Opnd((unsigned)0), 0);
		int br_off2 = emitter.get_offset();
		char *br_patch2 = emitter.get_next() - 1;

		//
		// For statistics, inserting instruments
		//
		if(inner_statistics){
			assert(emitter.prof_rec) ;
			inner_bb_instrumenting_code(emitter,
				(unsigned*)&((PROF_COUNTER*)&((unsigned short*)&emitter.prof_rec->back_edge[emitter.prof_rec->n_back_edge])[emitter.prof_rec->n_back_edge])[emitter.inner_bb_cnt_offset++]);
		}
		emitter.emit_alu(xor_opc, reg_opnd, reg_opnd);
	    *br_patch2 = emitter.get_offset() - br_off2;
	    *br_patch1 = emitter.get_offset() - br_off1;
		Reg_Operand *result = new (mem_manager) Reg_Operand(reg_opnd->reg_no());
		stack.push(result);

		//
		// For statistics
		//
		b_inner_counter = true ;

	}
//#endif
    return 0;
}

int gen_checkcast(Mem_Manager& mem_manager,
				  Code_Emitter& emitter,
				  Stack& stack,
				  Code_Patch *& code_patch_list,
				  Class_Handle class_handle,
                  Compile_Handle comp_handle,
				  unsigned index,
                  Jit_Method_Info *method_info,
				  Frame &frame) {
	stack.call_home(1);
	//
	// get the class handle
	//
    Loader_Exception lexc;
	class_handle = resolve_class(comp_handle,class_handle,index,&lexc);
    if (!class_handle)
        return 1;

//#ifdef FAST_INSTOF
	int depth = class_get_depth(class_handle);
//#endif
	Operand *obj_ref = stack.pop();
#if 1
//#ifdef FAST_INSTOF
	if((class_get_flags(class_handle) & ACC_INTERFACE) ||
		class_get_name(class_handle)[0] == '[' ||
		(depth >= MAX_FAST_INSTOF_DEPTH)) {
//#endif
    //
    // If the obj's vatable is the same as class's vtable, we don't need to
    // call instanceof.
    //  
    void *vtab = class_get_vtable(class_handle);
	obj_ref->free_opnd(&stack.reg_manager);
    Reg_Operand *dst = stack.reg_manager.get_reg(eax_reg);
    assert(dst);
    Reg_Operand *obj_reg = dst;
    if (!obj_ref->is_reg() || !obj_ref->contain(eax_reg))
        obj_ref->emit_mov_to_reg(emitter,&dst->opnd);
    emitter.emit_alu(cmp_opc, &obj_reg->opnd, &Imm_Opnd(0));
    emitter.emit_branch(cc_eq,0,0);
    int patch_null_off = emitter.get_offset();
    char *patch_null_br = emitter.get_next() -1;
	//
	// For statistics, inserting instruments
	//
	if(inner_statistics){
		assert(emitter.prof_rec) ;
		inner_bb_instrumenting_code(emitter,
			(unsigned*)&((PROF_COUNTER*)&((unsigned short*)&emitter.prof_rec->back_edge[emitter.prof_rec->n_back_edge])[emitter.prof_rec->n_back_edge])[emitter.inner_bb_cnt_offset++]);
	}
    //
    // get vtable
    //
    Reg_Operand *vreg = stack.reg_manager.get_reg();
	emitter.emit_alu(cmp_opc,&M_Base_Opnd(obj_reg->opnd.reg_no(),0),&Imm_Opnd((unsigned)vtab));
	emitter.emit_branch(cc_eq,0,0);
    vreg->free_opnd(&stack.reg_manager);
    int patch_br_off = emitter.get_offset();
    char *patch_br = emitter.get_next() -1;
	//
	// For statistics, inserting instruments
	//
	if(inner_statistics){
		assert(emitter.prof_rec) ;
		inner_bb_instrumenting_code(emitter,
			(unsigned*)&((PROF_COUNTER*)&((unsigned short*)&emitter.prof_rec->back_edge[emitter.prof_rec->n_back_edge])[emitter.prof_rec->n_back_edge])[emitter.inner_bb_cnt_offset++]);
	}

	//
	// generate CheckCast(object_handle,class_handle);
	//
    void *addr = orp_get_rt_support_addr(ORP_RT_CHECKCAST);
	emitter.emit_push(&Imm_Opnd((unsigned)class_handle));
    make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
	unsigned offset = (stack.size - stack.depth() + frame.n_callee) << 2;
	//
	// pop the arguments
	//
	obj_reg->emit_push(emitter,1);
    make_esp_record(emitter.get_offset(),2,method_info,mem_manager);
	unsigned patch_offset = emitter.get_offset()+1;
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 1;
	emitter.emit_call((char*)addr);
    method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0x2; // outarg 1 is a ref
    method_info->cs_info[method_info->cnt].m_handle = NULL;
    method_info->cs_info[method_info->cnt++].num_out_args = 2;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
    *patch_null_br = emitter.get_offset() - patch_null_off;
    *patch_br = emitter.get_offset() - patch_br_off; // patch branch offset
	//
	// push the return value
	//
    stack.push(dst);
#else
	emitter.emit_push(&Imm_Opnd((unsigned)class_handle));
    make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
	unsigned offset = (stack.size - stack.depth() + frame.n_callee) << 2;
	//
	// pop the arguments
	//
	obj_ref->emit_push(emitter,1);
	obj_ref->free_opnd(&stack.reg_manager);
    make_esp_record(emitter.get_offset(),2,method_info,mem_manager);
	unsigned patch_offset = emitter.get_offset()+1;
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 1;
	emitter.emit_call((char*)addr);
    method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0x2; // outarg 1 is a ref
    method_info->cs_info[method_info->cnt].m_handle = NULL;
    method_info->cs_info[method_info->cnt++].num_out_args = 2;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
	//
	// push the return value
	//
    stack.push(stack.reg_manager.get_reg(eax_reg));
#endif

//#ifdef FAST_INSTOF
	} else {
		void *vtab = class_get_vtable(class_handle);
		obj_ref->free_opnd(&stack.reg_manager);
		Reg_Operand *reg = stack.reg_manager.get_reg(eax_reg);
		assert(reg);
		Reg_Operand *obj_reg = reg;
		if (!obj_ref->is_reg() || !obj_ref->contain(eax_reg))
			obj_ref->emit_mov_to_reg(emitter,&reg->opnd); //## mov [] -> reg2 (?)

		R_Opnd *reg_opnd = &((Reg_Operand*)obj_reg)->opnd;
		emitter.emit_alu(cmp_opc, &obj_reg->opnd, &Imm_Opnd(0)); //## cmp 0 -> eax
		emitter.emit_branch(cc_eq,0,0); //## je br_patch1
		int br_off1 = emitter.get_offset();
		char *br_patch1 = emitter.get_next() - 1;
		//
		// For statistics, inserting instruments
		//
		if(inner_statistics){
			assert(emitter.prof_rec) ;
			inner_bb_instrumenting_code(emitter,
				(unsigned*)&((PROF_COUNTER*)&((unsigned short*)&emitter.prof_rec->back_edge[emitter.prof_rec->n_back_edge])[emitter.prof_rec->n_back_edge])[emitter.inner_bb_cnt_offset++]);
		}

		X86_Reg_No reg_no = reg_opnd->reg_no();
		M_Base_Opnd vtable(reg_no, 0);//offset
		Reg_Operand *reg2 = stack.reg_manager.get_reg();
		emitter.emit_mov(&((Reg_Operand*)reg2)->opnd, &vtable); //## mov [eax+vtable_offset] -> edx

		R_Opnd *reg_opnd2 = &((Reg_Operand*)reg2)->opnd;
		X86_Reg_No reg_no2 = reg_opnd2->reg_no();
		int offset = vtable_get_super_array_offset() + (depth - 1) * sizeof(void *);
		M_Base_Opnd superarray_element(reg_no2, offset);
		emitter.emit_alu(cmp_opc, &superarray_element, &Imm_Opnd((unsigned)class_handle));//## cmp xxxx -> [edx+superclasses_offset]
		emitter.emit_branch8(cc_eq, &Imm_Opnd((unsigned)0), 0); //## je ,cc_eq
		reg2->free_opnd(&stack.reg_manager);
		int br_off2 = emitter.get_offset();
		char *br_patch2 = emitter.get_next() - 1;
		//
		// For statistics, inserting instruments
		//
		if(inner_statistics){
			assert(emitter.prof_rec) ;
			inner_bb_instrumenting_code(emitter,
				(unsigned*)&((PROF_COUNTER*)&((unsigned short*)&emitter.prof_rec->back_edge[emitter.prof_rec->n_back_edge])[emitter.prof_rec->n_back_edge])[emitter.inner_bb_cnt_offset++]);
		}

		//
		// generate CheckCast(object_handle,class_handle);
		//
		void *addr = orp_get_rt_support_addr(ORP_RT_CHECKCAST);
		emitter.emit_push(&Imm_Opnd((unsigned)class_handle));
		make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
		offset = (stack.size - stack.depth() + frame.n_callee) << 2;
		//
		// pop the arguments
		//
		obj_reg->emit_push(emitter,1);
		make_esp_record(emitter.get_offset(),2,method_info,mem_manager);
		unsigned patch_offset = emitter.get_offset()+1;
		method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
		method_info->cs_info[method_info->cnt].returns_ref = 1;
		emitter.emit_call((char*)addr);
		method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
		method_info->cs_info[method_info->cnt].outarg_bv = 0x2; // outarg 1 is a ref
		method_info->cs_info[method_info->cnt].m_handle = NULL;
		method_info->cs_info[method_info->cnt++].num_out_args = 2;
		code_patch_list =
			new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);

		*br_patch2 = emitter.get_offset() - br_off2;
	    *br_patch1 = emitter.get_offset() - br_off1;
		//
		// push the return value
		//
		stack.push(reg);
	}
//#endif

	//
	// For statistics
	//
	b_inner_counter = true ;

    return 0;
}

void gen_athrow(Mem_Manager& mem_manager,
				Code_Emitter& emitter,
				Stack& stack,
				Code_Patch *& code_patch_list,
                Jit_Method_Info *method_info,
				Frame &frame) {
	stack.home_all();
	//
	// get the class handle
	//
	void *addr = orp_get_rt_support_addr(ORP_RT_ATHROW);
	//
	// generate Throw(object_handle);
	//
	unsigned offset = (stack.size - stack.depth() + frame.n_callee) << 2;
	Operand *obj_ref = stack.pop();
	emitter.emit_push(&M_Base_Opnd(esp_reg,offset));
    make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
	unsigned patch_offset = emitter.get_offset()+1;
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 1;
	emitter.emit_call((char*)addr);
    method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0x1; // outarg 0 is a ref
    method_info->cs_info[method_info->cnt].m_handle = NULL;
    method_info->cs_info[method_info->cnt++].num_out_args = 1;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
}



int gen_new(Mem_Manager& mem_manager,
            Code_Emitter& emitter,
            Stack& stack,
            Code_Patch *& code_patch_list,
            Class_Handle class_handle,
            Compile_Handle comp_handle,
            unsigned index,
            Jit_Method_Info *method_info)
{
	stack.call_home(0);
	//
	// generate New(class_handle);
	//
    Loader_Exception ld_exc;
    Class_Handle resolved_class =
        resolve_class_new(comp_handle, class_handle, index, &ld_exc);
    assert(resolved_class);  // What should we do in this case?
	void *addr;
    if(class_has_non_default_finalizer(resolved_class)) {
	    addr = orp_get_rt_support_addr(ORP_RT_NEW_WITH_FINALIZER_RESOLVED);
    } else {
	    addr = orp_get_rt_support_addr(ORP_RT_NEW_RESOLVED);
    }
	emitter.emit_push(&Imm_Opnd((unsigned)resolved_class));
	unsigned patch_offset = emitter.get_offset()+1;
	make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 1;
	emitter.emit_call((char*)addr);
	method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0;
    method_info->cs_info[method_info->cnt].m_handle = NULL;
	method_info->cs_info[method_info->cnt++].num_out_args = 1;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
	//
	// push the return value
	//

	stack.push(stack.reg_manager.get_reg(eax_reg));

    return 0;
}

void gen_newarray(Mem_Manager& mem_manager,
				  Code_Emitter& emitter,
				  Stack& stack,
				  Code_Patch *& code_patch_list,
				  Class_Handle class_handle,
				  unsigned atype,
				  Jit_Method_Info *method_info,
				  Frame &frame
#ifndef NO_BOUNDS_CHECKING
				  , Bounds_Checking& bounds
#endif // NO_BOUNDS_CHECKING
                  ) {

	stack.call_home(1);
	//
	// get the class handle
	//
	void *addr = orp_get_rt_support_addr(ORP_RT_NEWARRAY);
	//
	// generate NewArray(type,n_elems);
	//
	unsigned offset = (stack.size - stack.depth() + frame.n_callee) << 2;
	//
	// pop the arguments
	//
	Operand *n_elem = stack.pop();
	n_elem->emit_push(emitter,0);
	n_elem->free_opnd(&stack.reg_manager);
	make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
	emitter.emit_push(&Imm_Opnd((unsigned)atype));
	unsigned patch_offset = emitter.get_offset()+1;
	make_esp_record(emitter.get_offset(),2,method_info,mem_manager);
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 1;
	emitter.emit_call((char*)addr);
	method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0x0;
    method_info->cs_info[method_info->cnt].m_handle = NULL;
	method_info->cs_info[method_info->cnt++].num_out_args = 2;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
	//
	// push the return value
	//
	stack.push(stack.reg_manager.get_reg(eax_reg));
#ifndef NO_BOUNDS_CHECKING
	if (n_elem->kind == Operand::Imm) {
		stack.reg_manager.set_newarray_in_reg(eax_reg);
		bounds.set_scratch_bound(eax_reg,((Imm_Operand*)n_elem)->imm_opnd.value);
	}
#endif // NO_BOUNDS_CHECKING
} //gen_newarray



void gen_anewarray(Mem_Manager& mem_manager,
				   Code_Emitter& emitter,
				   Stack& stack,
				   Code_Patch *& code_patch_list,
				   Class_Handle class_handle,
                   Compile_Handle comp_handle,
				   unsigned index,
				   Jit_Method_Info *method_info,
				   Frame &frame
#ifndef NO_BOUNDS_CHECKING
				   , Bounds_Checking& bounds
#endif // NO_BOUNDS_CHECKING
                   )
{
	stack.call_home(1);

	//
	// get the class handle
	//
    Loader_Exception lexc;
    Class_Handle arr_elem_class_handle =
        resolve_class(comp_handle, class_handle, index, &lexc);
    Class_Handle arr_class_handle =
        resolve_class_array_of_class(comp_handle, arr_elem_class_handle, &lexc);
	void *addr = orp_get_rt_support_addr(ORP_RT_ANEWARRAY_RESOLVED);

	//
	// generate ANewArray(class_handle, n_elems);
	//
	unsigned offset = (stack.size - stack.depth() + frame.n_callee) << 2;
	//
	// pop the arguments
	//
	Operand *n_elem = stack.pop();
	n_elem->emit_push(emitter,0);
	n_elem->free_opnd(&stack.reg_manager);
	make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
	emitter.emit_push(&Imm_Opnd((unsigned)arr_class_handle));
	make_esp_record(emitter.get_offset(),2,method_info,mem_manager);
	unsigned patch_offset = emitter.get_offset()+1;
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 1;
	emitter.emit_call((char*)addr);
	method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0;
    method_info->cs_info[method_info->cnt].m_handle = NULL;
	method_info->cs_info[method_info->cnt++].num_out_args = 2;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
	//
	// push the return value
	//
	stack.push(stack.reg_manager.get_reg(eax_reg));
#ifndef NO_BOUNDS_CHECKING
	if (n_elem->kind == Operand::Imm) {
		stack.reg_manager.set_newarray_in_reg(eax_reg);
		bounds.set_scratch_bound(eax_reg,((Imm_Operand*)n_elem)->imm_opnd.value);
	}
#endif // NO_BOUNDS_CHECKING
} //gen_anewarray



void gen_multianewarray(Mem_Manager& mem_manager,
                        Code_Emitter& emitter,
                        Stack& stack,
                        Code_Patch *& code_patch_list,
                        unsigned n_dim,
                        Class_Handle class_handle,
                        Compile_Handle comp_handle,
                        unsigned index,
                        Jit_Method_Info *method_info,
                        Frame &frame)
{
	stack.call_home(n_dim);

	//
	// get the class handle
	//
    Loader_Exception lexc;
    Class_Handle anewarray_class_handle =
        resolve_class(comp_handle, class_handle, index, &lexc);
    assert(anewarray_class_handle);

	void *addr = orp_get_rt_support_addr(ORP_RT_MULTIANEWARRAY_RESOLVED);

	//
	// generate MultiANewArrayResolved(class, n_dim, c1, c1, ...);
	//
	unsigned offset = (stack.size - stack.depth() + frame.n_callee + n_dim - 1) << 2;
	unsigned i;
	for (i=0; i < n_dim; i++) {
		if (i != 0)
			make_esp_record(emitter.get_offset(),i,method_info,mem_manager);
		stack.nth(n_dim - i - 1)->emit_push(emitter,i);

	}
	make_esp_record(emitter.get_offset(), n_dim, method_info, mem_manager);
	emitter.emit_push(&Imm_Opnd(n_dim));
	make_esp_record(emitter.get_offset(), 1 + n_dim, method_info, mem_manager);
	emitter.emit_push(&Imm_Opnd((unsigned)anewarray_class_handle));
	unsigned patch_offset = emitter.get_offset()+1;
	make_esp_record(emitter.get_offset(), 2 + n_dim, method_info, mem_manager);
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 1;
	emitter.emit_call((char*)addr);
	make_esp_record(emitter.get_offset(), 2 + n_dim, method_info, mem_manager);
    method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
	method_info->cs_info[method_info->cnt].num_out_args = 2 + n_dim;
	method_info->cs_info[method_info->cnt].is_caller_pop = 1;
    method_info->cs_info[method_info->cnt].outarg_bv = 0;
    method_info->cs_info[method_info->cnt].m_handle = NULL;
	method_info->cnt++;
	emitter.emit_alu(add_opc, &esp_opnd, &Imm_Opnd(8 + (n_dim<<2)));
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list, patch_offset, (char*)addr);

	//
	// pop the arguments
	// 
	for (i=0; i < n_dim; i++) 
		stack.pop()->free_opnd(&stack.reg_manager);

	//
	// push the return value
	//
	stack.push(stack.reg_manager.get_reg(eax_reg));
} //gen_multianewarray



void gen_monitorenter(Mem_Manager& mem_manager,
					  Code_Emitter& emitter,
					  Stack& stack,
					  Code_Patch *& code_patch_list,
                      Jit_Method_Info *method_info,
					  Frame &frame) {
#ifdef TUNING
	stack.call_home(1);
#else // TUNING
	stack.home_all();
#endif // TUNING

    //
	// generate MonEnter(object_handle);
	//
	unsigned offset = (stack.size - stack.depth() + frame.n_callee) << 2;
	Operand *obj_ref = stack.pop();

	void *addr = orp_get_rt_support_addr(ORP_RT_MONITOR_ENTER);
#ifdef TUNING
	obj_ref->emit_push(emitter);
	obj_ref->free_opnd(&stack.reg_manager);
#else // TUNING
	emitter.emit_push(&M_Base_Opnd(esp_reg,offset));
#endif // TUNING
    make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
	unsigned patch_offset = emitter.get_offset()+1;
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;
	emitter.emit_call((char*)addr);
    method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0x1; // outarg 0 is a ref
    method_info->cs_info[method_info->cnt].m_handle = NULL;
    method_info->cs_info[method_info->cnt++].num_out_args = 1;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
}

extern void gen_monitorexit(Mem_Manager& mem_manager,
						 	Code_Emitter& emitter,
							Stack& stack,
							Code_Patch *& code_patch_list,
                            Jit_Method_Info *method_info,
							Frame &frame) {
#ifdef TUNING
	stack.call_home(1);
#else // TUNING
	stack.home_all();
#endif // TUNING

    //
	// generate MonExit(object_handle);
	//
	unsigned offset = (stack.size - stack.depth() + frame.n_callee) << 2;
	Operand *obj_ref = stack.pop();

	void *addr = orp_get_rt_support_addr(ORP_RT_MONITOR_EXIT);
#ifdef TUNING
	obj_ref->emit_push(emitter);
	obj_ref->free_opnd(&stack.reg_manager);
#else // TUNING
	emitter.emit_push(&M_Base_Opnd(esp_reg,offset));
#endif // TUNING
    make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
	unsigned patch_offset = emitter.get_offset()+1;
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;
	emitter.emit_call((char*)addr);
    method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0x1; // outarg 0 is a ref
    method_info->cs_info[method_info->cnt].m_handle = NULL;
    method_info->cs_info[method_info->cnt++].num_out_args = 1;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
}

void gen_synch_method_enter(Mem_Manager& mem_manager,
							Code_Emitter& emitter,
							Code_Patch *& code_patch_list,
							unsigned n_args,
							Jit_Method_Info *method_info,
							Method_Handle method_handle) {
	//
	// get the class handle
	//
	void *addr;
	if (method_handle != NULL) {
		// static method
        Class_Handle class_handle = method_get_class(method_handle);
		addr = orp_get_rt_support_addr(ORP_RT_MONITOR_ENTER_STATIC);
		emitter.emit_push(&Imm_Opnd((unsigned)class_handle));
	} else {
		unsigned offset = (method_info->frame_size - 1) << 2;
		addr = orp_get_rt_support_addr(ORP_RT_MONITOR_ENTER);
		emitter.emit_push(&M_Base_Opnd(esp_reg,offset));
	}
	//
	// generate MonEnter(object_handle);
	//
	unsigned patch_offset = emitter.get_offset()+1;
	make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;
	emitter.emit_call((char*)addr);
	method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    if (method_handle == NULL)
    {
        method_info->cs_info[method_info->cnt].outarg_bv = 0x1; // outarg 0 is a ref
    }
    else
        method_info->cs_info[method_info->cnt].outarg_bv = 0;
    method_info->cs_info[method_info->cnt].m_handle = NULL;
	method_info->cs_info[method_info->cnt++].num_out_args = 1;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
}

void gen_synch_method_exit(Mem_Manager& mem_manager,
						   Code_Emitter& emitter,
						   Code_Patch *& code_patch_list,
						   unsigned n_args,
						   Jit_Method_Info *method_info,
						   Method_Handle method_handle) {
	//
	// get the class handle
	//
	void *addr;
	if (method_handle != NULL) {
		// static method
        Class_Handle class_handle = method_get_class(method_handle);
		addr = orp_get_rt_support_addr(ORP_RT_MONITOR_EXIT_STATIC);
		emitter.emit_push(&Imm_Opnd((unsigned)class_handle));
	} else {
		unsigned offset = (method_info->frame_size - 1) << 2;
		addr = orp_get_rt_support_addr(ORP_RT_MONITOR_EXIT);
		emitter.emit_push(&M_Base_Opnd(esp_reg,offset));
	}
	//
	// generate MonExit(object_handle);
	//
	unsigned patch_offset = emitter.get_offset()+1;
	make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;
	emitter.emit_call((char*)addr);
	method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    if (method_handle == NULL)
    {
        method_info->cs_info[method_info->cnt].outarg_bv = 0x1; // outarg 0 is a ref
    }
    else
        method_info->cs_info[method_info->cnt].outarg_bv = 0;
    method_info->cs_info[method_info->cnt].m_handle = NULL;
	method_info->cs_info[method_info->cnt++].num_out_args = 1;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);
}

